/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.internal.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.ptp.rm.jaxb.control.data.RegexImpl;
import org.eclipse.ptp.rm.jaxb.control.internal.IAssign;
import org.eclipse.ptp.rm.jaxb.control.internal.data.AbstractAssign;
import org.eclipse.ptp.rm.jaxb.control.internal.data.TargetImpl;
import org.eclipse.ptp.rm.jaxb.control.internal.messages.Messages;
import org.eclipse.ptp.rm.jaxb.control.internal.utils.TokenizerLogger;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.MatchType;
import org.eclipse.ptp.rm.jaxb.core.data.RegexType;

public class MatchImpl {
    private RegexImpl regex;
    private final TargetImpl target;
    private List<IAssign> assign;
    private final boolean moveToTop;
    private boolean matched;

    public MatchImpl(String uuid, MatchType match, TargetImpl target, IVariableMap rmVarMap) {
        List assign;
        this.target = target;
        this.moveToTop = match.isMoveToTop();
        this.matched = false;
        RegexType r = match.getExpression();
        if (r != null) {
            this.regex = new RegexImpl(r, uuid, rmVarMap);
        }
        if (!(assign = match.getAddOrAppendOrPut()).isEmpty()) {
            this.assign = new ArrayList<IAssign>();
            for (Object o : assign) {
                AbstractAssign.add(uuid, o, this.assign, rmVarMap);
            }
        }
    }

    public synchronized int doMatch(String sequence) throws Throwable {
        int end = 0;
        String[] tokens = null;
        TokenizerLogger.getLogger().logSegmentInfo(String.valueOf(Messages.MatchImpl_0) + sequence);
        TokenizerLogger.getLogger().logSegmentInfo(String.valueOf(Messages.MatchImpl_1) + this.regex.getExpression() + Messages.MatchImpl_2 + this.regex.getFlags());
        if (this.regex == null) {
            this.matched = true;
            TokenizerLogger.getLogger().logMatchInfo(Messages.MatchImpl_3);
            return sequence.length();
        }
        tokens = this.regex.getMatched(sequence);
        if (tokens == null) {
            TokenizerLogger.getLogger().logMatchInfo(Messages.MatchImpl_4);
            return end;
        }
        this.matched = true;
        end = this.regex.getLastChar();
        TokenizerLogger.getLogger().logMatchInfo(String.valueOf(Messages.MatchImpl_5) + Arrays.asList(tokens));
        if (this.target == null || this.assign == null) {
            return end;
        }
        int incr = 0;
        for (IAssign a : this.assign) {
            if (a.isForceNew()) {
                ++incr;
            }
            a.incrementIndex(incr);
            Object t = this.target.getTarget(a);
            a.setTarget(t);
            a.assign(tokens);
        }
        return end;
    }

    public boolean getMatched() {
        return this.matched;
    }

    public boolean getMoveToTop() {
        return this.moveToTop;
    }

    public RegexImpl getRegex() {
        return this.regex;
    }

    public void reset() {
        this.matched = false;
    }
}

