/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rmsystem;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.core.ModelManager;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.attributes.StringAttribute;
import org.eclipse.ptp.core.attributes.StringAttributeDefinition;
import org.eclipse.ptp.core.elements.IPResourceManager;
import org.eclipse.ptp.core.elements.attributes.ElementAttributes;
import org.eclipse.ptp.core.elements.attributes.ResourceManagerAttributes;
import org.eclipse.ptp.core.listeners.IJobListener;
import org.eclipse.ptp.core.messages.Messages;
import org.eclipse.ptp.internal.core.elements.PResourceManager;
import org.eclipse.ptp.rmsystem.AbstractResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.AbstractResourceManagerControl;
import org.eclipse.ptp.rmsystem.AbstractResourceManagerMonitor;
import org.eclipse.ptp.rmsystem.IJobStatus;
import org.eclipse.ptp.rmsystem.IResourceManager;
import org.eclipse.ptp.rmsystem.IResourceManagerComponentConfiguration;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.IResourceManagerControl;
import org.eclipse.ptp.rmsystem.IResourceManagerMonitor;

public abstract class AbstractResourceManager
implements IResourceManager {
    private final PResourceManager fPResourceManager;
    private final AbstractResourceManagerControl fResourceManagerControl;
    private final AbstractResourceManagerMonitor fResourceManagerMonitor;
    private final ModelManager fModelManager = (ModelManager)PTPCorePlugin.getDefault().getModelManager();
    private AbstractResourceManagerConfiguration fConfig;
    private String fState;

    public AbstractResourceManager(AbstractResourceManagerConfiguration config, AbstractResourceManagerControl control, AbstractResourceManagerMonitor monitor) {
        this.fConfig = config;
        this.fResourceManagerControl = control;
        this.fResourceManagerMonitor = monitor;
        this.fPResourceManager = new PResourceManager(this.fModelManager.getUniverse(), this);
        this.fModelManager.getUniverse().addResourceManager(this.fPResourceManager);
        this.fState = "STOPPED";
    }

    public void addJob(String jobId, IJobStatus status) {
        this.fResourceManagerMonitor.addJob(jobId, status);
    }

    public void addJobListener(IJobListener listener) {
        this.fResourceManagerMonitor.addJobListener(listener);
    }

    public void control(String jobId, String operation, IProgressMonitor monitor) throws CoreException {
        this.fResourceManagerControl.control(jobId, operation, monitor);
    }

    public void dispose() {
        this.doDispose();
        this.fModelManager.getUniverse().removeResourceManager(this.fPResourceManager);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this)) {
            return this;
        }
        if (adapter == IPResourceManager.class) {
            return this.fPResourceManager;
        }
        if (adapter == IResourceManagerConfiguration.class) {
            return this.getConfiguration();
        }
        return null;
    }

    public IResourceManagerConfiguration getConfiguration() {
        return this.fConfig;
    }

    public IResourceManagerControl getControl() {
        return this.fResourceManagerControl;
    }

    public IResourceManagerComponentConfiguration getControlConfiguration() {
        return this.fResourceManagerControl.getControlConfiguration();
    }

    public String getDescription() {
        StringAttributeDefinition descAttrDef = ResourceManagerAttributes.getDescriptionAttributeDefinition();
        StringAttribute descAttr = (StringAttribute)this.fPResourceManager.getAttribute(descAttrDef);
        if (descAttr != null) {
            return descAttr.getValue();
        }
        return this.getName();
    }

    public IJobStatus getJobStatus(String jobId, boolean force, IProgressMonitor monitor) {
        return this.fResourceManagerControl.getJobStatus(jobId, force, monitor);
    }

    public IJobStatus getJobStatus(String jobId, IProgressMonitor monitor) {
        return this.fResourceManagerControl.getJobStatus(jobId, monitor);
    }

    public IResourceManagerMonitor getMonitor() {
        return this.fResourceManagerMonitor;
    }

    public IResourceManagerComponentConfiguration getMonitorConfiguration() {
        return this.fResourceManagerMonitor.getMonitorConfiguration();
    }

    public String getName() {
        return this.getConfiguration().getName();
    }

    public String getResourceManagerId() {
        return this.getConfiguration().getResourceManagerId();
    }

    public synchronized String getState() {
        return this.fState;
    }

    public String getUniqueName() {
        return this.getConfiguration().getUniqueName();
    }

    public void removeJob(String jobId) {
        this.fResourceManagerMonitor.removeJob(jobId);
    }

    public void removeJobListener(IJobListener listener) {
        this.fResourceManagerMonitor.addJobListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfiguration(AbstractResourceManagerConfiguration config) {
        StringAttributeDefinition descAttrDef;
        StringAttribute descAttr;
        AbstractResourceManager abstractResourceManager = this;
        synchronized (abstractResourceManager) {
            this.fConfig = config;
        }
        AttributeManager attrs = new AttributeManager();
        StringAttributeDefinition nameAttrDef = ElementAttributes.getNameAttributeDefinition();
        StringAttribute nameAttr = (StringAttribute)this.fPResourceManager.getAttribute(nameAttrDef);
        if (nameAttr != null) {
            try {
                nameAttr.setValue(config.getName());
                attrs.addAttribute(nameAttr);
            }
            catch (IllegalValueException illegalValueException) {}
        }
        if ((descAttr = (StringAttribute)this.fPResourceManager.getAttribute(descAttrDef = ResourceManagerAttributes.getDescriptionAttributeDefinition())) != null) {
            try {
                descAttr.setValue(config.getDescription());
                attrs.addAttribute(descAttr);
            }
            catch (IllegalValueException illegalValueException) {}
        }
        this.fireResourceManagerChanged();
    }

    public synchronized void setState(String state) {
        this.fState = state;
        this.fireResourceManagerChanged();
    }

    public void start(IProgressMonitor monitor) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        if (this.getState().equals("STOPPED") || this.getState().equals("ERROR")) {
            this.setState("STARTING");
            monitor.subTask(String.valueOf(Messages.AbstractResourceManager_1) + this.getName());
            try {
                this.doStartup((IProgressMonitor)subMon.newChild(100));
            }
            catch (CoreException e) {
                this.setState("ERROR");
                throw e;
            }
            if (monitor.isCanceled()) {
                this.doShutdown();
                this.setState("STOPPED");
            }
        }
    }

    public void stop() throws CoreException {
        if (this.getState().equals("ERROR")) {
            this.setState("STOPPED");
        } else if (this.getState().equals("STARTING") || this.getState().equals("STARTED")) {
            try {
                this.doShutdown();
            }
            finally {
                this.setState("STOPPED");
            }
        }
    }

    public String submitJob(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return this.fResourceManagerControl.submitJob(configuration, mode, monitor);
    }

    public void updateJob(String jobId, IJobStatus status) {
        this.fResourceManagerMonitor.updateJob(jobId, status);
    }

    protected void doDispose() {
        this.fResourceManagerControl.dispose();
        this.fResourceManagerMonitor.dispose();
    }

    protected void doShutdown() throws CoreException {
        CoreException exception = null;
        try {
            this.fResourceManagerControl.stop();
        }
        catch (CoreException e) {
            exception = e;
        }
        this.fResourceManagerMonitor.stop();
        if (exception != null) {
            throw exception;
        }
    }

    protected void doStartup(IProgressMonitor monitor) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.fResourceManagerControl.start((IProgressMonitor)subMon.newChild(50));
        try {
            this.fResourceManagerMonitor.start((IProgressMonitor)subMon.newChild(50));
        }
        catch (CoreException e) {
            this.doShutdown();
            throw e;
        }
    }

    protected void fireJobChanged(String jobId) {
        this.fResourceManagerMonitor.fireJobChanged(jobId);
    }

    protected void fireResourceManagerChanged() {
        this.fModelManager.fireResourceManagerChanged(this);
    }

    protected void fireResourceManagerError(String message) {
        this.setState("ERROR");
        this.fModelManager.fireResourceManagerError(this, message);
    }

    protected void fireResourceManagerStarted() {
        this.setState("STARTED");
    }

    protected void fireResourceManagerStopped() {
        this.setState("STOPPED");
    }
}

