/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.miners;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.ASTNameCollector;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTFunctionStyleMacroParameter;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTImplicitNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorFunctionStyleMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.LookupData;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.index.IIndexFragmentName;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.ptp.internal.rdt.core.miners.RemoteIndexManager;
import org.eclipse.ptp.internal.rdt.core.model.BindingAdapter;
import org.eclipse.ptp.internal.rdt.core.model.CElement;
import org.eclipse.ptp.internal.rdt.core.model.Path;
import org.eclipse.ptp.internal.rdt.core.navigation.OpenDeclarationResult;
import org.eclipse.ptp.internal.rdt.core.navigation.SimpleASTFileLocation;
import org.eclipse.ptp.internal.rdt.core.navigation.SimpleName;
import org.eclipse.ptp.rdt.core.RDTLog;
import org.eclipse.rse.dstore.universal.miners.UniversalServerUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenDeclarationHandler {
    public static final String CLASS_NAME = "CDTMiner-OpenDeclarationHandler";
    private static int PARSE_MODE_FAST = 38;

    public static OpenDeclarationResult handleOpenDeclaration(String scopeName, String scheme, ITranslationUnit workingCopy, String path, String selectedText, int selectionStart, int selectionLength, DataStore _dataStore) {
        UniversalServerUtilities.logDebugMessage((String)CLASS_NAME, (String)("Getting declaration for selection in " + workingCopy.getElementName()), (DataStore)_dataStore);
        UniversalServerUtilities.logDebugMessage((String)CLASS_NAME, (String)("scope: " + scopeName), (DataStore)_dataStore);
        UniversalServerUtilities.logDebugMessage((String)CLASS_NAME, (String)("path: " + workingCopy.getLocationURI()), (DataStore)_dataStore);
        UniversalServerUtilities.logDebugMessage((String)CLASS_NAME, (String)("offset: " + selectionStart), (DataStore)_dataStore);
        UniversalServerUtilities.logDebugMessage((String)CLASS_NAME, (String)("length: " + selectionLength), (DataStore)_dataStore);
        IIndex index = RemoteIndexManager.getInstance().getIndexForScope("__WORKSPACE_ROOT_SCOPE__", _dataStore);
        UniversalServerUtilities.logDebugMessage((String)CLASS_NAME, (String)"Acquiring read lock", (DataStore)_dataStore);
        UniversalServerUtilities.logDebugMessage((String)CLASS_NAME, (String)"Got Read lock", (DataStore)_dataStore);
        return OpenDeclarationHandler.doHandleOpenDeclaration(scopeName, scheme, workingCopy, path, selectedText, selectionStart, selectionLength, index, _dataStore);
    }

    private static IName[] convertNames(IName[] names) {
        int n = names.length;
        IName[] converted = new IName[n];
        int i = 0;
        while (i < n) {
            converted[i] = new SimpleName(names[i]);
            ++i;
        }
        return converted;
    }

    private static OpenDeclarationResult doHandleOpenDeclaration(String scopeName, String scheme, ITranslationUnit workingCopy, String path, String selectedText, int selectionStart, int selectionLength, IIndex index, DataStore _dataStore) {
        IIndex project_index = RemoteIndexManager.getInstance().getIndexForScope(scopeName, _dataStore);
        IASTTranslationUnit ast = null;
        try {
            try {
                UniversalServerUtilities.logDebugMessage((String)CLASS_NAME, (String)"Acquiring read lock for project_index", (DataStore)_dataStore);
                project_index.acquireReadLock();
                ast = workingCopy.getAST(project_index, PARSE_MODE_FAST);
            }
            catch (InterruptedException e) {
                UniversalServerUtilities.logError((String)CLASS_NAME, (String)e.toString(), (Throwable)e, (DataStore)_dataStore);
                OpenDeclarationResult openDeclarationResult = OpenDeclarationResult.failureUnexpectedError();
                UniversalServerUtilities.logDebugMessage((String)CLASS_NAME, (String)"Releasing read lock for project_index", (DataStore)_dataStore);
                project_index.releaseReadLock();
                return openDeclarationResult;
            }
            catch (CoreException e) {
                UniversalServerUtilities.logError((String)CLASS_NAME, (String)e.toString(), (Throwable)e, (DataStore)_dataStore);
                OpenDeclarationResult openDeclarationResult = OpenDeclarationResult.failureUnexpectedError();
                UniversalServerUtilities.logDebugMessage((String)CLASS_NAME, (String)"Releasing read lock for project_index", (DataStore)_dataStore);
                project_index.releaseReadLock();
                return openDeclarationResult;
            }
        }
        finally {
            UniversalServerUtilities.logDebugMessage((String)CLASS_NAME, (String)"Releasing read lock for project_index", (DataStore)_dataStore);
            project_index.releaseReadLock();
        }
        if (ast == null) {
            return OpenDeclarationResult.failureUnexpectedError();
        }
        try {
            IASTNode node;
            UniversalServerUtilities.logDebugMessage((String)CLASS_NAME, (String)"Acquiring read lock for workspace_scope_index", (DataStore)_dataStore);
            index.acquireReadLock();
            IASTNodeSelector nodeSelector = ast.getNodeSelector(null);
            IASTName sourceName = nodeSelector.findEnclosingName(selectionStart, selectionLength);
            Object[] implicitTargets = OpenDeclarationHandler.findImplicitTargets(index, ast, nodeSelector, selectionStart, selectionLength);
            if (sourceName == null) {
                if (implicitTargets.length > 0) {
                    ICElement[] elements = OpenDeclarationHandler.convertToCElements(workingCopy, index, (IName[])implicitTargets, _dataStore);
                    OpenDeclarationResult openDeclarationResult = OpenDeclarationResult.resultCElements(elements);
                    return openDeclarationResult;
                }
            } else {
                IASTNode parent = sourceName.getParent();
                if (parent instanceof IASTPreprocessorIncludeStatement) {
                    String includedPath = ((IASTPreprocessorIncludeStatement)parent).getPath();
                    if (includedPath == null || includedPath.equals("")) {
                        OpenDeclarationResult openDeclarationResult = OpenDeclarationResult.failureIncludeLookup(selectedText);
                        return openDeclarationResult;
                    }
                    OpenDeclarationResult openDeclarationResult = OpenDeclarationResult.resultIncludePath(includedPath);
                    return openDeclarationResult;
                }
                NameKind kind = OpenDeclarationHandler.getNameKind((IName)sourceName);
                IBinding b = sourceName.resolveBinding();
                IBinding[] bindings = new IBinding[]{b};
                if (b instanceof IProblemBinding) {
                    IBinding[] candidateBindings = ((IProblemBinding)b).getCandidateBindings();
                    if (candidateBindings.length != 0) {
                        bindings = candidateBindings;
                    }
                } else if (kind == NameKind.DEFINITION && b instanceof IType) {
                    OpenDeclarationResult openDeclarationResult = OpenDeclarationResult.resultName(new SimpleName((IName)sourceName));
                    return openDeclarationResult;
                }
                Object[] targets = IName.EMPTY_ARRAY;
                String filename = ast.getFilePath();
                IBinding[] iBindingArray = bindings;
                if (bindings.length != 0) {
                    ICElement[] elements;
                    IBinding binding = iBindingArray[0];
                    if (binding != null && !(binding instanceof IProblemBinding)) {
                        IName[] names;
                        IName[] iNameArray = names = OpenDeclarationHandler.findDeclNames(index, ast, kind, binding);
                        int n = names.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IName name = iNameArray[n2];
                            if (!(name == null || name instanceof IIndexName && filename.equals(((IIndexName)name).getFileLocation().getFileName()) || OpenDeclarationHandler.areOverlappingNames(name, (IName)sourceName))) {
                                if (binding instanceof IParameter) {
                                    if (OpenDeclarationHandler.isInSameFunction(sourceName, name)) {
                                        targets = (IName[])ArrayUtil.append((Object[])targets, (Object)name);
                                    }
                                } else if (binding instanceof ICPPTemplateParameter) {
                                    if (OpenDeclarationHandler.isInSameTemplate(sourceName, name)) {
                                        targets = (IName[])ArrayUtil.append((Object[])targets, (Object)name);
                                    }
                                } else {
                                    targets = (IName[])ArrayUtil.append((Object[])targets, (Object)name);
                                }
                            }
                            ++n2;
                        }
                    }
                    if ((elements = OpenDeclarationHandler.convertToCElements(workingCopy, index, (IName[])(targets = (IName[])ArrayUtil.trim((Object[])((IName[])ArrayUtil.addAll((Object[])targets, (Object[])implicitTargets)))), _dataStore)) != null && elements.length > 0) {
                        OpenDeclarationResult openDeclarationResult = OpenDeclarationResult.resultCElements(elements);
                        return openDeclarationResult;
                    }
                    if (OpenDeclarationHandler.hasAtLeastOneLocation((IName[])targets)) {
                        OpenDeclarationResult openDeclarationResult = OpenDeclarationResult.resultNames(OpenDeclarationHandler.convertNames((IName[])targets));
                        return openDeclarationResult;
                    }
                    OpenDeclarationResult openDeclarationResult = OpenDeclarationHandler.navigationFallBack(ast, index, selectedText, _dataStore, workingCopy, sourceName, kind);
                    return openDeclarationResult;
                }
            }
            if ((node = nodeSelector.findEnclosingNode(selectionStart, selectionLength)) instanceof IASTPreprocessorIncludeStatement) {
                String includedPath = ((IASTPreprocessorIncludeStatement)node).getPath();
                if (includedPath != "") {
                    OpenDeclarationResult openDeclarationResult = OpenDeclarationResult.resultIncludePath(includedPath);
                    return openDeclarationResult;
                }
                OpenDeclarationResult openDeclarationResult = OpenDeclarationResult.failureIncludeLookup(selectedText);
                return openDeclarationResult;
            }
            if (node instanceof IASTPreprocessorFunctionStyleMacroDefinition) {
                IASTPreprocessorFunctionStyleMacroDefinition mdef = (IASTPreprocessorFunctionStyleMacroDefinition)node;
                IASTFunctionStyleMacroParameter[] iASTFunctionStyleMacroParameterArray = mdef.getParameters();
                int n = iASTFunctionStyleMacroParameterArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IASTFileLocation location;
                    IASTFunctionStyleMacroParameter par = iASTFunctionStyleMacroParameterArray[n3];
                    String parName = par.getParameter();
                    if (parName.equals(selectedText) && (location = par.getFileLocation()) != null) {
                        OpenDeclarationResult openDeclarationResult = OpenDeclarationResult.resultLocation(new SimpleASTFileLocation(par.getFileLocation()));
                        return openDeclarationResult;
                    }
                    ++n3;
                }
            }
            OpenDeclarationResult openDeclarationResult = OpenDeclarationHandler.navigationFallBack(ast, index, selectedText, _dataStore, workingCopy, sourceName, NameKind.REFERENCE);
            return openDeclarationResult;
        }
        catch (InterruptedException e) {
            UniversalServerUtilities.logError((String)CLASS_NAME, (String)e.toString(), (Throwable)e, (DataStore)_dataStore);
            OpenDeclarationResult openDeclarationResult = OpenDeclarationResult.failureUnexpectedError();
            return openDeclarationResult;
        }
        catch (CoreException e) {
            UniversalServerUtilities.logError((String)CLASS_NAME, (String)e.toString(), (Throwable)e, (DataStore)_dataStore);
            OpenDeclarationResult openDeclarationResult = OpenDeclarationResult.failureUnexpectedError();
            return openDeclarationResult;
        }
        finally {
            UniversalServerUtilities.logDebugMessage((String)CLASS_NAME, (String)"Releasing read lock for workspace_scope_index", (DataStore)_dataStore);
            index.releaseReadLock();
        }
    }

    private static boolean areOverlappingNames(IName n1, IName n2) {
        if (n1 == n2) {
            return true;
        }
        IASTFileLocation loc1 = n1.getFileLocation();
        IASTFileLocation loc2 = n2.getFileLocation();
        if (loc1 == null || loc2 == null) {
            return false;
        }
        return loc1.getFileName().equals(loc2.getFileName()) && Math.max(loc1.getNodeOffset(), loc2.getNodeOffset()) < Math.min(loc1.getNodeOffset() + loc1.getNodeLength(), loc2.getNodeOffset() + loc2.getNodeLength());
    }

    private static boolean isInSameFunction(IASTName refName, IName funcDeclName) {
        if (funcDeclName instanceof IASTName) {
            IASTDeclaration fdef = OpenDeclarationHandler.getEnclosingFunctionDefinition((IASTNode)funcDeclName);
            return fdef != null && fdef.contains((IASTNode)refName);
        }
        return false;
    }

    private static IASTDeclaration getEnclosingFunctionDefinition(IASTNode node) {
        while (node != null && !(node instanceof IASTFunctionDefinition)) {
            node = node.getParent();
        }
        return (IASTDeclaration)node;
    }

    private static boolean isInSameTemplate(IASTName refName, IName templateDeclName) {
        if (templateDeclName instanceof IASTName) {
            IASTDeclaration template = OpenDeclarationHandler.getEnclosingTemplateDeclaration((IASTNode)refName);
            return template != null && template.contains((IASTNode)refName);
        }
        return false;
    }

    private static IASTDeclaration getEnclosingTemplateDeclaration(IASTNode node) {
        while (node != null && !(node instanceof ICPPASTTemplateDeclaration)) {
            node = node.getParent();
        }
        return (IASTDeclaration)node;
    }

    private static ICElement[] convertToCElements(ITranslationUnit unit, IIndex index, IName[] names, DataStore _dataStore) {
        ArrayList<ICElement> elements = new ArrayList<ICElement>();
        IName[] iNameArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            IName name = iNameArray[n2];
            try {
                ICElement element = OpenDeclarationHandler.getCElementForName(unit, index, name);
                if (element instanceof ISourceReference) {
                    elements.add(element);
                }
            }
            catch (CoreException e) {
                UniversalServerUtilities.logError((String)CLASS_NAME, (String)e.toString(), (Throwable)e, (DataStore)_dataStore);
            }
            catch (DOMException e) {
                UniversalServerUtilities.logError((String)CLASS_NAME, (String)e.toString(), (Throwable)e, (DataStore)_dataStore);
            }
            ++n2;
        }
        return elements.toArray(new ICElement[elements.size()]);
    }

    private static ICElement getCElementForName(ITranslationUnit unit, IIndex index, IName name) throws CoreException, DOMException {
        int length;
        int offset;
        IIndexBinding binding;
        boolean isDefinition = name.isDefinition();
        if (name instanceof IIndexName) {
            IIndexName indexName = (IIndexName)name;
            binding = index.findBinding((IName)indexName);
            offset = indexName.getNodeOffset();
            length = indexName.getNodeLength();
        } else if (name instanceof IASTName) {
            IASTName astName = (IASTName)name;
            binding = astName.resolveBinding();
            if (binding == null) {
                return null;
            }
            IASTFileLocation loc = astName.getFileLocation();
            if (loc == null) {
                return null;
            }
            offset = loc.getNodeOffset();
            length = loc.getNodeLength();
        } else {
            return null;
        }
        ICElement element = BindingAdapter.adaptBinding(unit, (IBinding)binding, offset, length, isDefinition);
        if (element == null) {
            return null;
        }
        ((CElement)element).setPath(new Path(name.getFileLocation().getFileName()));
        return element;
    }

    private static boolean hasAtLeastOneLocation(IName[] declNames) {
        IName[] iNameArray = declNames;
        int n = declNames.length;
        int n2 = 0;
        while (n2 < n) {
            IName name = iNameArray[n2];
            IASTFileLocation fileloc = name.getFileLocation();
            if (fileloc != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static IName[] findDeclNames(IIndex index, IASTTranslationUnit ast, NameKind kind, IBinding binding) throws CoreException {
        ICPPClassType clsBinding;
        ICPPMethod method;
        IName[] declNames = OpenDeclarationHandler.findNames(index, ast, kind, binding);
        while (declNames.length == 0 && binding instanceof ICPPSpecialization) {
            if ((binding = ((ICPPSpecialization)binding).getSpecializedBinding()) == null || binding instanceof IProblemBinding) continue;
            declNames = OpenDeclarationHandler.findNames(index, ast, NameKind.DEFINITION, binding);
        }
        if (declNames.length == 0 && binding instanceof ICPPMethod && (method = (ICPPMethod)binding).isImplicit() && (clsBinding = method.getClassOwner()) != null && !(clsBinding instanceof IProblemBinding)) {
            declNames = OpenDeclarationHandler.findNames(index, ast, NameKind.REFERENCE, (IBinding)clsBinding);
        }
        return declNames;
    }

    private static IName[] findNames(IIndex index, IASTTranslationUnit ast, NameKind kind, IBinding binding) throws CoreException {
        IName[] declNames = kind == NameKind.DEFINITION ? OpenDeclarationHandler.findDeclarations(index, ast, binding) : OpenDeclarationHandler.findDefinitions(index, ast, kind, binding);
        if (declNames.length == 0) {
            declNames = kind == NameKind.DEFINITION ? OpenDeclarationHandler.findDefinitions(index, ast, kind, binding) : OpenDeclarationHandler.findDeclarations(index, ast, binding);
        }
        return declNames;
    }

    private static IName[] findDefinitions(IIndex index, IASTTranslationUnit ast, NameKind kind, IBinding binding) throws CoreException {
        ArrayList<IASTName> declNames = new ArrayList<IASTName>();
        declNames.addAll(Arrays.asList(ast.getDefinitionsInAST(binding)));
        Iterator i = declNames.iterator();
        while (i.hasNext()) {
            IASTName name = (IASTName)i.next();
            IBinding b2 = name.resolveBinding();
            if (b2 instanceof ICPPUsingDeclaration) {
                i.remove();
            }
            if (binding == b2 || !(binding instanceof ICPPSpecialization)) continue;
            IBinding spec = binding;
            while (spec instanceof ICPPSpecialization) {
                if ((spec = ((ICPPSpecialization)spec).getSpecializedBinding()) == b2) break;
            }
            if (spec instanceof ICPPSpecialization) continue;
            i.remove();
        }
        if (!declNames.isEmpty()) {
            return (IName[])declNames.toArray(new IASTName[declNames.size()]);
        }
        return index.findNames(binding, 10);
    }

    private static IName[] findDeclarations(IIndex index, IASTTranslationUnit ast, IBinding binding) throws CoreException {
        Object[] declNames = ast.getDeclarationsInAST(binding);
        int i = 0;
        while (i < declNames.length) {
            Object name = declNames[i];
            if (name.isDefinition()) {
                declNames[i] = null;
            }
            ++i;
        }
        if ((declNames = (IName[])ArrayUtil.removeNulls(IName.class, (Object[])declNames)).length == 0) {
            declNames = index.findNames(binding, 9);
        }
        return declNames;
    }

    private static IName[] findImplicitTargets(IIndex index, IASTTranslationUnit ast, IASTNodeSelector nodeSelector, int offset, int length) throws CoreException {
        Object[] definitions = IName.EMPTY_ARRAY;
        IASTImplicitName firstName = nodeSelector.findEnclosingImplicitName(offset, length);
        if (firstName != null) {
            IASTImplicitNameOwner owner = (IASTImplicitNameOwner)firstName.getParent();
            IASTImplicitName[] iASTImplicitNameArray = owner.getImplicitNames();
            int n = iASTImplicitNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTImplicitName name = iASTImplicitNameArray[n2];
                if (((ASTNode)name).getOffset() == ((ASTNode)firstName).getOffset()) {
                    IBinding binding = name.resolveBinding();
                    Object[] declNames = OpenDeclarationHandler.findDeclNames(index, ast, NameKind.REFERENCE, binding);
                    definitions = (IName[])ArrayUtil.addAll((Object[])definitions, (Object[])declNames);
                }
                ++n2;
            }
        }
        return (IName[])ArrayUtil.trim((Object[])definitions);
    }

    private static IBinding getBinding(IName name) {
        if (name instanceof IASTName) {
            return ((IASTName)name).resolveBinding();
        }
        if (name instanceof IIndexFragmentName) {
            try {
                return ((IIndexFragmentName)name).getBinding();
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    private static NameKind getNameKind(IName name) {
        if (name.isDefinition()) {
            if (OpenDeclarationHandler.getBinding(name) instanceof ICPPUsingDeclaration) {
                return NameKind.USING_DECL;
            }
            return NameKind.DEFINITION;
        }
        if (name.isDeclaration()) {
            return NameKind.DECLARATION;
        }
        return NameKind.REFERENCE;
    }

    private static OpenDeclarationResult navigationFallBack(IASTTranslationUnit ast, IIndex index, String selectedText, DataStore _dataStore, ITranslationUnit tu, IASTName sourceName, NameKind kind) {
        if (selectedText == null || selectedText.length() == 0) {
            return null;
        }
        try {
            ICElement[] elements;
            ICElement[] macroName;
            IIndexMacro[] macros;
            IIndexBinding[] idxBindings;
            IASTName[] candidates;
            char[] name = selectedText.toCharArray();
            ArrayList<ICElement[]> nameList = new ArrayList<ICElement[]>();
            ArrayList<ICElement> elems = new ArrayList<ICElement>();
            HashSet<IBinding> primaryBindings = new HashSet<IBinding>();
            ASTNameCollector nc = new ASTNameCollector(selectedText);
            ast.accept((ASTVisitor)nc);
            IASTName[] iASTNameArray = candidates = nc.getNames();
            int n = candidates.length;
            int n2 = 0;
            while (n2 < n) {
                IASTName astName = iASTNameArray[n2];
                try {
                    IBinding b = astName.resolveBinding();
                    if (b != null && !(b instanceof IProblemBinding)) {
                        primaryBindings.add(b);
                    }
                }
                catch (RuntimeException e) {
                    RDTLog.logError((Throwable)e);
                }
                ++n2;
            }
            IndexFilter filter = IndexFilter.getDeclaredBindingFilter((int)ast.getLinkage().getLinkageID(), (boolean)false);
            IIndexBinding[] iIndexBindingArray = idxBindings = index.findBindings(name, false, filter, null);
            int e = idxBindings.length;
            int n3 = 0;
            while (n3 < e) {
                IIndexBinding idxBinding = iIndexBindingArray[n3];
                primaryBindings.add((IBinding)idxBinding);
                ++n3;
            }
            IIndexMacro[] iIndexMacroArray = macros = index.findMacros(name, filter, null);
            int n4 = macros.length;
            e = 0;
            while (e < n4) {
                IIndexMacro macro = iIndexMacroArray[e];
                macroName = new SimpleName(macro.getFileLocation(), macro.getNameCharArray());
                nameList.add(macroName);
                ++e;
            }
            macroName = elements = OpenDeclarationHandler.convertToCElements(tu, index, nameList.toArray(new IName[nameList.size()]), _dataStore);
            int n5 = elements.length;
            n4 = 0;
            while (n4 < n5) {
                ICElement element = macroName[n4];
                elems.add(element);
                ++n4;
            }
            Collection<IBinding> secondaryBindings = ast instanceof ICPPASTTranslationUnit ? OpenDeclarationHandler.cppRemoveSecondaryBindings(primaryBindings, sourceName) : OpenDeclarationHandler.defaultRemoveSecondaryBindings(primaryBindings, sourceName);
            Collection<IBinding> bs = primaryBindings;
            int k = 0;
            while (k < 2) {
                for (IBinding binding : bs) {
                    Object[] names = OpenDeclarationHandler.findNames(index, ast, kind, binding);
                    int i = 0;
                    while (i < names.length) {
                        if (OpenDeclarationHandler.getNameKind((IName)names[i]) == kind) {
                            names[i] = null;
                        }
                        ++i;
                    }
                    names = (IName[])ArrayUtil.removeNulls(IName.class, (Object[])names);
                    ICElement[] iCElementArray = elements = OpenDeclarationHandler.convertToCElements(tu, index, (IName[])names, _dataStore);
                    int n6 = elements.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        ICElement element = iCElementArray[n7];
                        elems.add(element);
                        ++n7;
                    }
                }
                if (!elems.isEmpty()) break;
                bs = secondaryBindings;
                ++k;
            }
            if (!elems.isEmpty()) {
                return OpenDeclarationResult.resultCElements((ICElement[])elems.toArray());
            }
            if (sourceName != null && sourceName.isDeclaration()) {
                return OpenDeclarationResult.resultName(new SimpleName((IName)sourceName));
            }
        }
        catch (CoreException e) {
            UniversalServerUtilities.logError((String)CLASS_NAME, (String)e.toString(), (Throwable)e, (DataStore)_dataStore);
        }
        return OpenDeclarationResult.failureSymbolLookup(selectedText);
    }

    private static Collection<IBinding> defaultRemoveSecondaryBindings(Set<IBinding> primaryBindings, IASTName sourceName) {
        IBinding b;
        if (sourceName != null && (b = sourceName.resolveBinding()) != null && !(b instanceof IProblemBinding)) {
            try {
                Iterator<IBinding> iterator = primaryBindings.iterator();
                while (iterator.hasNext()) {
                    if (OpenDeclarationHandler.checkOwnerNames(b, iterator.next())) continue;
                    iterator.remove();
                }
            }
            catch (DOMException dOMException) {}
        }
        return Collections.emptyList();
    }

    private static boolean checkOwnerNames(IBinding b1, IBinding b2) throws DOMException {
        IBinding o2;
        IBinding o1 = b1.getOwner();
        if (o1 == (o2 = b2.getOwner())) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (!CharArrayUtils.equals((char[])o1.getNameCharArray(), (char[])o2.getNameCharArray())) {
            return false;
        }
        return OpenDeclarationHandler.checkOwnerNames(o1, o2);
    }

    private static Collection<IBinding> cppRemoveSecondaryBindings(Set<IBinding> primaryBindings, IASTName sourceName) {
        IBinding binding;
        ArrayList<IBinding> result = new ArrayList<IBinding>();
        Object[] sourceQualifiedName = null;
        int funcArgCount = -1;
        if (sourceName != null && (binding = sourceName.resolveBinding()) != null) {
            LookupData data;
            sourceQualifiedName = CPPVisitor.getQualifiedName((IBinding)binding);
            if (binding instanceof ICPPUnknownBinding && (data = CPPSemantics.createLookupData((IASTName)sourceName)).isFunctionCall()) {
                funcArgCount = data.getFunctionArgumentCount();
            }
        }
        Iterator<IBinding> iterator = primaryBindings.iterator();
        while (iterator.hasNext()) {
            Object[] qualifiedName;
            IBinding binding2 = iterator.next();
            if (sourceQualifiedName != null && !Arrays.equals(qualifiedName = CPPVisitor.getQualifiedName((IBinding)binding2), sourceQualifiedName)) {
                iterator.remove();
                continue;
            }
            if (funcArgCount == -1 || !(binding2 instanceof ICPPFunction)) continue;
            ICPPFunction f = (ICPPFunction)binding2;
            if (f.getRequiredArgumentCount() > funcArgCount) {
                iterator.remove();
                result.add(binding2);
                continue;
            }
            if (f.takesVarArgs() || f.hasParameterPack()) continue;
            IType[] parameterTypes = f.getType().getParameterTypes();
            int maxArgs = parameterTypes.length;
            if (maxArgs == 1 && SemanticUtil.isVoidType((IType)parameterTypes[0])) {
                maxArgs = 0;
            }
            if (maxArgs >= funcArgCount) continue;
            iterator.remove();
            result.add(binding2);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NameKind {
        REFERENCE,
        DECLARATION,
        USING_DECL,
        DEFINITION;

    }
}

