/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.git.core;

import java.util.EnumSet;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.rdt.sync.core.SyncFlag;
import org.eclipse.ptp.rdt.sync.core.serviceproviders.ISyncServiceProvider;
import org.eclipse.ptp.rdt.sync.git.core.GitRemoteSyncConnection;
import org.eclipse.ptp.rdt.sync.git.core.RemoteSyncException;
import org.eclipse.ptp.rdt.sync.git.core.SyncFileFilter;
import org.eclipse.ptp.rdt.sync.git.core.messages.Messages;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.services.core.ServiceProvider;
import org.eclipse.ui.statushandlers.StatusManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitServiceProvider
extends ServiceProvider
implements ISyncServiceProvider {
    public static final String ID = "org.eclipse.ptp.rdt.sync.git.core.GitServiceProvider";
    private static final String GIT_LOCATION = "location";
    private static final String GIT_CONNECTION_NAME = "connectionName";
    private static final String GIT_SERVICES_ID = "servicesId";
    private static final String GIT_PROJECT_NAME = "projectName";
    private IProject fProject = null;
    private String fLocation = null;
    private IRemoteConnection fConnection = null;
    private GitRemoteSyncConnection fSyncConnection = null;
    private boolean hasBeenSynced = false;
    private static final ReentrantLock syncLock = new ReentrantLock();
    private Integer fWaitingThreadsCount = 0;
    private Integer syncTaskId = -1;
    private int finishedSyncTaskId = -1;

    public String getLocation() {
        if (this.fLocation == null) {
            this.fLocation = this.getString(GIT_LOCATION, null);
        }
        return this.fLocation;
    }

    public IProject getProject() {
        String name;
        if (this.fProject == null && (name = this.getString(GIT_PROJECT_NAME, null)) != null) {
            this.fProject = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        }
        return this.fProject;
    }

    public IRemoteConnection getRemoteConnection() {
        IRemoteServices services;
        String name;
        if (this.fConnection == null && (name = this.getString(GIT_CONNECTION_NAME, null)) != null && (services = this.getRemoteServices()) != null) {
            this.fConnection = services.getConnectionManager().getConnection(name);
        }
        return this.fConnection;
    }

    public IRemoteServices getRemoteServices() {
        String id = this.getString(GIT_SERVICES_ID, null);
        if (id != null) {
            return PTPRemoteCorePlugin.getDefault().getRemoteServices(id);
        }
        return null;
    }

    public boolean isConfigured() {
        return this.getLocation() != null && this.getRemoteConnection() != null && this.getProject() != null;
    }

    public void setLocation(String location) {
        if (this.fLocation != null) {
            throw new RuntimeException(Messages.GSP_ChangeLocationError);
        }
        this.fLocation = location;
        this.putString(GIT_LOCATION, location);
    }

    public void setProject(IProject project) {
        if (this.fProject != null) {
            throw new RuntimeException(Messages.GSP_ChangeProjectError);
        }
        this.fProject = project;
        this.putString(GIT_PROJECT_NAME, project.getName());
    }

    public void setRemoteConnection(IRemoteConnection conn) {
        if (this.fConnection != null) {
            throw new RuntimeException(Messages.GSP_ChangeConnectionError);
        }
        this.fConnection = conn;
        this.putString(GIT_CONNECTION_NAME, conn.getName());
    }

    public void setRemoteServices(IRemoteServices services) {
        this.putString(GIT_SERVICES_ID, services.getId());
    }

    /*
     * Exception decompiling
     */
    public void synchronize(IResourceDelta delta, IProgressMonitor monitor, EnumSet<SyncFlag> syncFlags) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void handleRemoteSyncException(RemoteSyncException e, EnumSet<SyncFlag> syncFlags) throws RemoteSyncException {
        if (syncFlags == SyncFlag.NO_FORCE) {
            throw e;
        }
        String endOfLineChar = System.getProperty("line.separator");
        String message = e.getMessage() != null && e.getMessage().length() > 0 || e.getCause() == null ? String.valueOf(Messages.GSP_SyncErrorMessage) + this.getProject().getName() + ":" + endOfLineChar + endOfLineChar + e.getMessage() : String.valueOf(Messages.GSP_SyncErrorMessage) + this.getProject().getName() + ":" + endOfLineChar + endOfLineChar + e.getCause().getMessage();
        Status status = null;
        int severity = e.getStatus().getSeverity();
        status = new Status(severity, "org.eclipse.ptp.rdt.sync.git.core", message, (Throwable)((Object)e));
        StatusManager.getManager().handle((IStatus)status, severity == 4 ? 2 : 1);
    }

    private boolean irrelevantPath(String path) {
        if (path.endsWith("/.ptp-sync")) {
            return true;
        }
        if (path.endsWith("/.git")) {
            return true;
        }
        return path.endsWith("/.settings");
    }

    public IRemoteConnection getConnection() {
        return this.fConnection;
    }

    public String getConfigLocation() {
        return this.fLocation;
    }

    public void setRemoteToolsConnection(IRemoteConnection connection) {
        syncLock.lock();
        try {
            this.fConnection = connection;
            this.putString(GIT_CONNECTION_NAME, connection.getName());
            this.fSyncConnection = null;
        }
        finally {
            syncLock.unlock();
        }
    }

    public void setConfigLocation(String configLocation) {
        syncLock.lock();
        try {
            this.fLocation = configLocation;
            this.putString(GIT_LOCATION, configLocation);
            this.fSyncConnection = null;
        }
        finally {
            syncLock.unlock();
        }
    }

    private class FileFilter
    implements SyncFileFilter {
        private FileFilter() {
        }

        public boolean shouldIgnore(String fileName) {
            if (fileName.equals(".cproject") || fileName.equals(".project")) {
                return true;
            }
            if (fileName.startsWith(".settings")) {
                return true;
            }
            if (fileName.startsWith(".ptp-sync")) {
                return true;
            }
            return this.isBinaryFile(fileName);
        }

        private boolean isBinaryFile(String fileName) {
            ICElement fileElement;
            block3: {
                try {
                    fileElement = CoreModel.getDefault().create(GitServiceProvider.this.getProject().getFile(fileName));
                    if (fileElement != null) break block3;
                    return false;
                }
                catch (NullPointerException nullPointerException) {
                    return false;
                }
            }
            int resType = fileElement.getElementType();
            return resType == 14;
        }
    }
}

