/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.openmpi.core.rmsystem;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.ptp.core.Preferences;
import org.eclipse.ptp.rm.core.rmsystem.AbstractToolRMConfiguration;
import org.eclipse.ptp.rm.mpi.openmpi.core.OpenMPIPlugin;
import org.eclipse.ptp.rm.mpi.openmpi.core.messages.Messages;
import org.eclipse.ptp.rm.mpi.openmpi.core.rmsystem.IOpenMPIResourceManagerConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;

public class OpenMPIResourceManagerConfiguration
extends AbstractToolRMConfiguration
implements IOpenMPIResourceManagerConfiguration {
    public static int OPENMPI_CAPABILITIES = 19;
    private static final String TAG_VERSION_ID = "versionId";
    private int majorVersion = 0;
    private int minorVersion = 0;
    private int serviceVersion = 0;

    public OpenMPIResourceManagerConfiguration(String namespace, IServiceProvider provider) {
        super(OPENMPI_CAPABILITIES, namespace, provider);
        this.setLaunchCmd(Preferences.getString((String)OpenMPIPlugin.getUniqueIdentifier(), (String)"openmpi-auto-launchCmd"));
        this.setDebugCmd(Preferences.getString((String)OpenMPIPlugin.getUniqueIdentifier(), (String)"openmpi-auto-debugCmd"));
        this.setDiscoverCmd(Preferences.getString((String)OpenMPIPlugin.getUniqueIdentifier(), (String)"openmpi-auto-discoverCmd"));
        this.setRemoteInstallPath(Preferences.getString((String)OpenMPIPlugin.getUniqueIdentifier(), (String)"openmpi-auto-remoteInstallPath"));
        this.setVersionId("auto");
        this.setUseInstallDefaults(true);
        this.setUseToolDefaults(true);
        this.setCommandsEnabled(false);
        this.setDescription(Messages.OpenMPIResourceManagerConfiguration_defaultDescription);
    }

    public String getDetectedVersion() {
        return String.valueOf(this.majorVersion) + "." + this.minorVersion;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getServiceVersion() {
        return this.serviceVersion;
    }

    public String getVersionId() {
        return this.getString(TAG_VERSION_ID, "");
    }

    public void setDefaultNameAndDesc() {
        String name = Messages.OpenMPIResourceManagerConfiguration_defaultName;
        String conn = this.getConnectionName();
        if (conn != null && !conn.equals("")) {
            name = String.valueOf(name) + "@" + conn;
        }
        this.setName(name);
        this.setDescription(Messages.OpenMPIResourceManagerConfiguration_defaultDescription);
    }

    public boolean setDetectedVersion(String version) {
        Pattern p = Pattern.compile("^(\\d+)\\.(\\d+)[^.]*(\\.(\\d+))?");
        Matcher m = p.matcher(version);
        if (m.matches()) {
            this.majorVersion = Integer.valueOf(m.group(1));
            this.minorVersion = Integer.valueOf(m.group(2));
            if (this.majorVersion > 1 || this.minorVersion > 4) {
                this.majorVersion = 1;
                this.minorVersion = 4;
            }
            if (m.group(3) != null) {
                this.serviceVersion = Integer.valueOf(m.group(4));
            }
            if (!this.validateVersion()) {
                return false;
            }
            if (!this.getVersionId().equals("auto")) {
                return this.getVersionId().equals(this.getDetectedVersion());
            }
            return true;
        }
        return false;
    }

    public void setVersionId(String versionId) {
        this.putString(TAG_VERSION_ID, versionId);
    }

    private boolean validateVersion() {
        return this.getDetectedVersion().equals("1.2") || this.getDetectedVersion().equals("1.3") || this.getDetectedVersion().equals("1.4");
    }

    protected void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    protected void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    protected void setServiceVersion(int serviceVersion) {
        this.serviceVersion = serviceVersion;
    }
}

