/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.debug.core.IPBreakpointManager;
import org.eclipse.ptp.debug.core.messages.Messages;
import org.eclipse.ptp.debug.core.model.IJumpToAddress;
import org.eclipse.ptp.debug.core.model.IJumpToLine;
import org.eclipse.ptp.debug.core.model.IPDummyStackFrame;
import org.eclipse.ptp.debug.core.model.IPStackFrame;
import org.eclipse.ptp.debug.core.model.IPThread;
import org.eclipse.ptp.debug.core.model.IRestart;
import org.eclipse.ptp.debug.core.model.IResumeWithoutSignal;
import org.eclipse.ptp.debug.core.model.IRunToAddress;
import org.eclipse.ptp.debug.core.model.IRunToLine;
import org.eclipse.ptp.debug.core.model.PDebugElementState;
import org.eclipse.ptp.debug.core.pdi.IPDISessionObject;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.event.IPDIBreakpointInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEndSteppingRangeInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEventListener;
import org.eclipse.ptp.debug.core.pdi.event.IPDIFunctionFinishedInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDILocationReachedInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDISharedLibraryInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDISignalInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDIWatchpointScopeInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDIWatchpointTriggerInfo;
import org.eclipse.ptp.debug.core.pdi.model.IPDIStackFrame;
import org.eclipse.ptp.debug.core.pdi.model.IPDIThread;
import org.eclipse.ptp.debug.internal.core.model.PDebugElement;
import org.eclipse.ptp.debug.internal.core.model.PDebugTarget;
import org.eclipse.ptp.debug.internal.core.model.PDummyStackFrame;
import org.eclipse.ptp.debug.internal.core.model.PStackFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PThread
extends PDebugElement
implements IPThread,
IRestart,
IResumeWithoutSignal,
IPDIEventListener {
    private static final int MAX_STACK_DEPTH = 100;
    private final IPDIThread pdiThread;
    private ArrayList<IStackFrame> fStackFrames;
    private boolean fRefreshChildren = true;
    private boolean fIsCurrent = false;
    private int fLastStackDepth = 0;
    private boolean fDisposed = false;
    private PDebugTarget fDebugTarget = null;

    public PThread(PDebugTarget target, IPDIThread pdiThread) {
        super(target.getSession(), target.getTasks());
        this.fDebugTarget = target;
        this.pdiThread = pdiThread;
        if (target.getPDISession().isSuspended(target.getTasks())) {
            this.setState(PDebugElementState.SUSPENDED);
            this.setCurrent(true);
        } else {
            this.setState(PDebugElementState.RESUMED);
        }
        this.initialize();
        this.getPDISession().getEventManager().addEventListener(this);
    }

    @Override
    public boolean canRestart() {
        return this.getDebugTarget() instanceof IRestart && this.getDebugTarget().canRestart();
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    @Override
    public boolean canResumeWithoutSignal() {
        return this.getDebugTarget() instanceof IResumeWithoutSignal && this.getDebugTarget().canResumeWithoutSignal();
    }

    public boolean canStepInto() {
        return this.canStep();
    }

    public boolean canStepOver() {
        return this.canStep();
    }

    public boolean canStepReturn() {
        if (!this.canResume()) {
            return false;
        }
        return this.fStackFrames.size() > 1;
    }

    public boolean canSuspend() {
        PDebugElementState state = this.getState();
        return state.equals(PDebugElementState.RESUMED) || state.equals(PDebugElementState.STEPPED);
    }

    public boolean canTerminate() {
        return this.getDebugTarget().canTerminate();
    }

    public List<IStackFrame> computeNewStackFrames() throws DebugException {
        return this.computeStackFrames(true);
    }

    public List<IStackFrame> computeStackFrames() throws DebugException {
        return this.computeStackFrames(this.refreshChildren());
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter.equals(IRunToLine.class) || adapter.equals(IRunToAddress.class) || adapter.equals(IJumpToLine.class) || adapter.equals(IJumpToAddress.class)) {
            try {
                return this.getTopStackFrame();
            }
            catch (DebugException debugException) {}
        }
        if (adapter.equals(PDebugElementState.class)) {
            return this;
        }
        if (adapter == IPStackFrame.class) {
            try {
                return this.getTopStackFrame();
            }
            catch (DebugException debugException) {}
        }
        if (adapter == IMemoryBlockRetrieval.class) {
            return this.getDebugTarget().getAdapter(adapter);
        }
        return super.getAdapter(adapter);
    }

    public IBreakpoint[] getBreakpoints() {
        ArrayList<IBreakpoint> list = new ArrayList<IBreakpoint>(1);
        if (this.isSuspended()) {
            IBreakpoint bkpt = null;
            IPBreakpointManager bMgr = this.fSession.getBreakpointManager();
            if (this.getCurrentStateInfo() instanceof IPDIBreakpointInfo) {
                bkpt = bMgr.getBreakpoint(((IPDIBreakpointInfo)this.getCurrentStateInfo()).getBreakpoint());
            } else if (this.getCurrentStateInfo() instanceof IPDIWatchpointTriggerInfo) {
                bkpt = bMgr.getBreakpoint(((IPDIWatchpointTriggerInfo)this.getCurrentStateInfo()).getWatchpoint());
            }
            if (bkpt != null) {
                list.add(bkpt);
            }
        }
        return list.toArray(new IBreakpoint[list.size()]);
    }

    @Override
    public PDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    public String getName() throws DebugException {
        return this.getPDIThread().toString();
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        List<Object> list = Collections.emptyList();
        try {
            list = this.computeStackFrames();
        }
        catch (DebugException e) {
            this.setStatus(2, e.getStatus().getMessage());
            throw e;
        }
        return list.toArray(new IStackFrame[list.size()]);
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        List<IStackFrame> c = this.computeStackFrames();
        return c.isEmpty() ? null : c.get(0);
    }

    @Override
    public synchronized void handleDebugEvents(IPDIEvent[] events) {
    }

    public boolean hasStackFrames() throws DebugException {
        return !this.getState().equals(PDebugElementState.RESUMED);
    }

    public boolean isStepping() {
        return this.getState().equals(PDebugElementState.STEPPING) || this.getState().equals(PDebugElementState.STEPPED);
    }

    public boolean isSuspended() {
        return this.getState().equals(PDebugElementState.SUSPENDED);
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated();
    }

    @Override
    public void restart() throws DebugException {
        if (this.canRestart()) {
            this.getDebugTarget().restart();
        }
    }

    public void resume() throws DebugException {
        if (!this.canResume()) {
            return;
        }
        PDebugElementState oldState = this.getState();
        this.setState(PDebugElementState.RESUMING);
        try {
            this.getPDISession().resume(this.getTasks(), false);
        }
        catch (PDIException e) {
            this.setState(oldState);
            PThread.targetRequestFailed(e.getMessage(), null);
        }
    }

    @Override
    public void resumeWithoutSignal() throws DebugException {
        if (this.canResumeWithoutSignal()) {
            this.getDebugTarget().resumeWithoutSignal();
        }
    }

    public void stepInto() throws DebugException {
        if (!this.canStepInto()) {
            return;
        }
        PDebugElementState oldState = this.getState();
        this.setState(PDebugElementState.STEPPING);
        try {
            if (!this.isInstructionsteppingEnabled()) {
                this.getPDISession().stepInto(this.getTasks(), 1);
            } else {
                this.getPDISession().stepIntoInstruction(this.getTasks(), 1);
            }
        }
        catch (PDIException e) {
            this.setState(oldState);
            PThread.targetRequestFailed(e.getMessage(), null);
        }
    }

    public void stepOver() throws DebugException {
        if (!this.canStepOver()) {
            return;
        }
        PDebugElementState oldState = this.getState();
        this.setState(PDebugElementState.STEPPING);
        try {
            if (!this.isInstructionsteppingEnabled()) {
                this.getPDISession().stepOver(this.getTasks(), 1);
            } else {
                this.getPDISession().stepOverInstruction(this.getTasks(), 1);
            }
        }
        catch (PDIException e) {
            this.setState(oldState);
            PThread.targetRequestFailed(e.getMessage(), null);
        }
    }

    public void stepReturn() throws DebugException {
        if (!this.canStepReturn()) {
            return;
        }
        IStackFrame[] frames = this.getStackFrames();
        if (frames.length == 0) {
            return;
        }
        PStackFrame f = (PStackFrame)frames[0];
        PDebugElementState oldState = this.getState();
        this.setState(PDebugElementState.STEPPING);
        try {
            f.doStepReturn();
        }
        catch (DebugException e) {
            this.setState(oldState);
            throw e;
        }
    }

    public void suspend() throws DebugException {
        if (!this.canSuspend()) {
            return;
        }
        PDebugElementState oldState = this.getState();
        this.setState(PDebugElementState.SUSPENDING);
        try {
            this.getPDISession().suspend(this.getTasks());
        }
        catch (PDIException e) {
            this.setState(oldState);
            PThread.targetRequestFailed(e.getMessage(), null);
        }
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
    }

    public String toString() {
        String result = "";
        try {
            result = this.getName();
        }
        catch (DebugException debugException) {}
        return result;
    }

    private boolean compareStackFrames(IPDIStackFrame[] newFrames, List<IStackFrame> oldFrames, int offset, int length) {
        int index = offset;
        Iterator<IStackFrame> it = oldFrames.iterator();
        while (it.hasNext() && index < newFrames.length) {
            PStackFrame frame = (PStackFrame)it.next();
            if (frame.getPDIStackFrame().equals(newFrames[index++])) continue;
            return false;
        }
        return true;
    }

    private void handleBreakpointHit(IPDIBreakpointInfo info) {
        this.fireSuspendEvent(16);
    }

    private void handleEndSteppingRange(IPDIEndSteppingRangeInfo info) {
        this.fireSuspendEvent(8);
    }

    private void handleSuspendedBySignal(IPDISignalInfo info) {
        this.fireSuspendEvent(0);
    }

    private boolean refreshChildren() {
        return this.fRefreshChildren;
    }

    private void setLastStackDepth(int depth) {
        this.fLastStackDepth = depth;
    }

    private void setRefreshChildren(boolean refresh) {
        this.fRefreshChildren = refresh;
    }

    private void syncWithBackend() {
        IPDIThread pdiThread = this.getPDIThread();
        IPDIThread currentThread = null;
        try {
            currentThread = pdiThread.getTarget().getCurrentThread();
        }
        catch (PDIException pDIException) {}
        this.setCurrent(pdiThread.equals(currentThread));
    }

    protected void addStackFrames(IPDIStackFrame[] newFrames, int startIndex, int length, boolean append) {
        if (newFrames.length >= startIndex + length) {
            int i = 0;
            while (i < length) {
                if (append) {
                    this.fStackFrames.add(new PStackFrame(this, newFrames[startIndex + i]));
                } else {
                    this.fStackFrames.add(i, new PStackFrame(this, newFrames[startIndex + i]));
                }
                ++i;
            }
        }
    }

    protected boolean canStep() {
        if (!this.isSuspended()) {
            return false;
        }
        return !this.fStackFrames.isEmpty();
    }

    protected void cleanup() {
        this.getPDISession().getEventManager().removeEventListener(this);
        this.disposeStackFrames();
    }

    protected synchronized List<IStackFrame> computeStackFrames(boolean refreshChildren) throws DebugException {
        if (this.isSuspended()) {
            if (this.isTerminated()) {
                this.fStackFrames = new ArrayList();
            } else if (refreshChildren) {
                int depth;
                IStackFrame frame;
                if (this.fStackFrames.size() > 0 && (frame = this.fStackFrames.get(this.fStackFrames.size() - 1)) instanceof IPDummyStackFrame) {
                    this.fStackFrames.remove(frame);
                }
                if ((depth = this.getStackDepth()) >= this.getMaxStackDepth()) {
                    depth = this.getMaxStackDepth() - 1;
                }
                IPDIStackFrame[] frames = depth != 0 ? this.getPDIStackFrames(0, depth - 1) : new IPDIStackFrame[]{};
                depth = frames.length;
                if (this.fStackFrames.isEmpty()) {
                    if (frames.length > 0) {
                        this.addStackFrames(frames, 0, frames.length, false);
                    }
                } else {
                    int length;
                    int diff = depth - this.getLastStackDepth();
                    int offset = diff > 0 ? frames.length - diff : 0;
                    int n = length = diff > 0 ? diff : -diff;
                    if (!this.compareStackFrames(frames, this.fStackFrames, offset, length)) {
                        this.disposeStackFrames(0, this.fStackFrames.size());
                        this.addStackFrames(frames, 0, frames.length, false);
                    }
                    if (diff < 0) {
                        this.disposeStackFrames(0, this.getLastStackDepth() - depth);
                        if (frames.length > 0) {
                            this.updateStackFrames(frames, 0, this.fStackFrames, this.fStackFrames.size());
                            if (this.fStackFrames.size() < frames.length) {
                                this.addStackFrames(frames, this.fStackFrames.size(), frames.length - this.fStackFrames.size(), true);
                            }
                        }
                    } else if (diff > 0) {
                        this.disposeStackFrames(frames.length - depth + this.getLastStackDepth(), depth - this.getLastStackDepth());
                        this.addStackFrames(frames, 0, depth - this.getLastStackDepth(), false);
                        this.updateStackFrames(frames, depth - this.getLastStackDepth(), this.fStackFrames, frames.length - depth + this.getLastStackDepth());
                    } else if (depth != 0) {
                        this.updateStackFrames(frames, 0, this.fStackFrames, frames.length);
                    }
                }
                if (depth > this.getMaxStackDepth()) {
                    this.fStackFrames.add(new PDummyStackFrame(this));
                }
                this.setLastStackDepth(depth);
                this.setRefreshChildren(false);
            }
        }
        return this.fStackFrames;
    }

    protected List<IStackFrame> createAllStackFrames(int depth, IPDIStackFrame[] frames) throws DebugException {
        ArrayList<IStackFrame> list = new ArrayList<IStackFrame>(frames.length);
        int i = 0;
        while (i < frames.length) {
            list.add(new PStackFrame(this, frames[i]));
            ++i;
        }
        if (depth > frames.length) {
            list.add(new PDummyStackFrame(this));
        }
        return list;
    }

    protected void dispose() {
        this.fDisposed = true;
        this.cleanup();
    }

    protected synchronized void disposeStackFrames() {
        for (IStackFrame obj : this.fStackFrames) {
            if (!(obj instanceof PStackFrame)) continue;
            ((PStackFrame)obj).dispose();
        }
        this.fStackFrames.clear();
        this.setLastStackDepth(0);
        this.resetStatus();
        this.setRefreshChildren(true);
    }

    protected void disposeStackFrames(int index, int length) {
        ArrayList<IPStackFrame> removeList = new ArrayList<IPStackFrame>(length);
        Iterator<IStackFrame> it = this.fStackFrames.iterator();
        int counter = 0;
        while (it.hasNext()) {
            IPStackFrame frame = (IPStackFrame)((IAdaptable)it.next()).getAdapter(IPStackFrame.class);
            if (frame instanceof PStackFrame && counter >= index && counter < index + length) {
                ((PStackFrame)frame).dispose();
                removeList.add(frame);
            }
            ++counter;
        }
        this.fStackFrames.removeAll(removeList);
    }

    protected int getLastStackDepth() {
        return this.fLastStackDepth;
    }

    protected int getMaxStackDepth() {
        return 100;
    }

    protected IPDIStackFrame[] getPDIStackFrames() throws DebugException {
        return new IPDIStackFrame[0];
    }

    protected IPDIStackFrame[] getPDIStackFrames(int lowFrame, int highFrame) throws DebugException {
        try {
            return this.getPDIThread().getStackFrames(lowFrame, highFrame);
        }
        catch (PDIException e) {
            this.setStatus(1, NLS.bind((String)Messages.PThread_0, (Object[])new Object[]{e.getMessage()}));
            PThread.targetRequestFailed(e.getMessage(), null);
            return new IPDIStackFrame[0];
        }
    }

    protected IPDIThread getPDIThread() {
        return this.pdiThread;
    }

    protected int getStackDepth() throws DebugException {
        int depth = 0;
        try {
            depth = this.getPDIThread().getStackFrameCount();
        }
        catch (PDIException e) {
            this.setStatus(1, NLS.bind((String)Messages.PThread_0, (Object[])new Object[]{e.getMessage()}));
        }
        return depth;
    }

    protected void initialize() {
        this.fStackFrames = new ArrayList();
    }

    protected boolean isCurrent() {
        return this.fIsCurrent;
    }

    protected boolean isDisposed() {
        return this.fDisposed;
    }

    protected boolean isInstructionsteppingEnabled() {
        return this.getDebugTarget().isInstructionSteppingEnabled();
    }

    protected synchronized void preserveStackFrames() {
        Iterator<IStackFrame> it = this.fStackFrames.iterator();
        while (it.hasNext()) {
            IPStackFrame frame = (IPStackFrame)((IAdaptable)it.next()).getAdapter(IPStackFrame.class);
            if (!(frame instanceof PStackFrame)) continue;
            ((PStackFrame)frame).preserve();
        }
        this.setRefreshChildren(true);
    }

    protected void resumedByTarget(int detail, List<DebugEvent> events) {
        this.syncWithBackend();
        if (this.isCurrent() && detail != 32 && detail != 0) {
            this.setState(PDebugElementState.STEPPED);
            this.preserveStackFrames();
            events.add(this.createResumeEvent(detail));
        } else {
            this.setState(PDebugElementState.RESUMED);
            this.disposeStackFrames();
            events.add(this.createChangeEvent(32));
        }
        this.setCurrent(false);
        this.setCurrentStateInfo(null);
    }

    protected void setCurrent(boolean current) {
        this.fIsCurrent = current;
    }

    protected void suspendByTarget(IPDISessionObject reason, IPDIThread suspensionThread) {
        this.setState(PDebugElementState.SUSPENDED);
        this.setCurrentStateInfo(null);
        if (this.getPDIThread().equals(suspensionThread)) {
            this.setCurrent(true);
            this.setCurrentStateInfo(reason);
            if (reason instanceof IPDIBreakpointInfo) {
                this.handleBreakpointHit((IPDIBreakpointInfo)reason);
            } else if (reason instanceof IPDIEndSteppingRangeInfo) {
                this.handleEndSteppingRange((IPDIEndSteppingRangeInfo)reason);
            } else if (!(reason instanceof IPDIFunctionFinishedInfo) && !(reason instanceof IPDILocationReachedInfo)) {
                if (reason instanceof IPDISignalInfo) {
                    this.handleSuspendedBySignal((IPDISignalInfo)reason);
                } else if (!(reason instanceof IPDISharedLibraryInfo || reason instanceof IPDIWatchpointScopeInfo || reason instanceof IPDIWatchpointTriggerInfo)) {
                    this.fireSuspendEvent(16);
                }
            }
        }
    }

    protected void terminated() {
        this.setState(PDebugElementState.TERMINATED);
        this.dispose();
    }

    protected void updateStackFrames(IPDIStackFrame[] newFrames, int offset, List<IStackFrame> oldFrames, int length) throws DebugException {
        int i = 0;
        while (i < length) {
            PStackFrame frame = (PStackFrame)oldFrames.get(offset);
            frame.setPDIStackFrame(newFrames[offset]);
            ++offset;
            ++i;
        }
    }
}

