/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.launcher.internal;

import java.io.File;
import java.io.PrintWriter;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.remotetools.core.IRemoteCopyTools;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionManager;
import org.eclipse.ptp.remotetools.core.IRemoteFileTools;
import org.eclipse.ptp.remotetools.core.IRemoteItem;
import org.eclipse.ptp.remotetools.core.IRemoteStatusTools;
import org.eclipse.ptp.remotetools.environment.launcher.core.LinuxPath;
import org.eclipse.ptp.remotetools.environment.launcher.data.DownloadRule;
import org.eclipse.ptp.remotetools.environment.launcher.data.ExecutionConfiguration;
import org.eclipse.ptp.remotetools.environment.launcher.internal.ILaunchProcessCallback;
import org.eclipse.ptp.remotetools.environment.launcher.internal.IRuleAction;
import org.eclipse.ptp.remotetools.environment.launcher.internal.Messages;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.exception.RemoteOperationException;

public class DownloadRuleAction
implements IRuleAction {
    private ILaunchProcessCallback process;
    private DownloadRule rule;
    private ExecutionConfiguration configuration;
    private PrintWriter outputWriter;
    private PrintWriter errorWriter;
    private IRemoteExecutionManager manager;

    public DownloadRuleAction(ILaunchProcessCallback process, DownloadRule rule) {
        this.process = process;
        this.rule = rule;
        this.configuration = process.getConfiguration();
        this.outputWriter = process.getOutputWriter();
        this.errorWriter = process.getErrorWriter();
        this.manager = process.getExecutionManager();
    }

    public void run() throws CoreException, CancelException, RemoteConnectionException {
        Path localPath;
        Assert.isNotNull((Object)this.process);
        Assert.isNotNull((Object)this.rule);
        Assert.isNotNull((Object)this.configuration);
        Assert.isNotNull((Object)this.outputWriter);
        Assert.isNotNull((Object)this.errorWriter);
        Assert.isNotNull((Object)this.manager);
        long clockSkew = 0L;
        if (this.rule.getOverwritePolicy() == 3) {
            IRemoteStatusTools statusTools = this.manager.getRemoteStatusTools();
            try {
                long localTime = System.currentTimeMillis();
                long remoteTime = statusTools.getTime();
                clockSkew = localTime - remoteTime;
            }
            catch (RemoteOperationException e) {
                this.errorWriter.println(NLS.bind((String)Messages.DownloadRuleAction_FailedCalculateClockDifference, (Object)e.getMessage()));
                this.errorWriter.println(Messages.DownloadRuleAction_FailedCalculateClockDifference2);
                clockSkew = 0L;
            }
            if (clockSkew < -15000L) {
                this.errorWriter.println(Messages.DownloadRuleAction_WarningClockForward);
            } else if (clockSkew > 15000L) {
                this.errorWriter.println(Messages.DownloadRuleAction_WarningClockBackward);
            }
        }
        if (!(localPath = new Path(this.rule.getLocalDirectory())).isAbsolute()) {
            IPath workspace = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            localPath = workspace.append((IPath)localPath);
        }
        Assert.isTrue((boolean)localPath.isAbsolute(), (String)"localPath.isAbsolute()");
        File localDir = localPath.toFile();
        if (!localDir.exists()) {
            if (!localDir.mkdirs()) {
                this.errorWriter.println(NLS.bind((String)Messages.DownloadRuleAction_FailedCreateLocalDirectory, (Object)localPath.toString()));
                return;
            }
        } else if (!localDir.isDirectory()) {
            this.errorWriter.println(NLS.bind((String)Messages.DownloadRuleAction_FailedLocalDiretoryIsNotDirectory, (Object)localPath.toString()));
            return;
        }
        IPath[] remotePaths = this.rule.getRemoteFilesAsPathArray();
        IPath remoteWorkingPath = this.configuration.getRemoteDirectoryPath();
        int i = 0;
        while (i < remotePaths.length) {
            IPath remotePath = remotePaths[i];
            if (!remotePath.isAbsolute()) {
                remotePath = remoteWorkingPath.append(remotePath);
            }
            remotePath = remotePath.removeTrailingSeparator();
            Assert.isTrue((boolean)remotePath.isAbsolute(), (String)"remotePath.isAbsolute()");
            remotePaths[i] = remotePath;
            ++i;
        }
        IRemoteFileTools fileTools = this.manager.getRemoteFileTools();
        int i2 = 0;
        while (i2 < remotePaths.length) {
            block20: {
                IPath remotePath = remotePaths[i2];
                String remotePathAsString = LinuxPath.toString(remotePath);
                IRemoteItem item = null;
                try {
                    item = fileTools.getItem(remotePathAsString);
                }
                catch (RemoteOperationException remoteOperationException) {
                    this.errorWriter.println(NLS.bind((String)Messages.DownloadRuleAction_FailedFetchAttributes, (Object)remotePathAsString));
                    break block20;
                }
                if (!item.exists()) {
                    this.errorWriter.println(NLS.bind((String)Messages.DownloadRuleAction_FailedRemotePathDoesNotExit, (Object)remotePathAsString));
                } else if (item.isDirectory()) {
                    this.downloadDirectory(item, localDir);
                } else {
                    this.downloadFile(item, localDir);
                }
            }
            ++i2;
        }
    }

    private void downloadFile(IRemoteItem remoteFile, File localDir) throws RemoteConnectionException, CancelException {
        Assert.isTrue((boolean)localDir.isAbsolute(), (String)"localDir.isAbsolute()");
        IPath remoteFilePath = LinuxPath.fromString(remoteFile.getPath());
        File localFile = new File(localDir, remoteFilePath.lastSegment());
        this.outputWriter.println(NLS.bind((String)Messages.DownloadRuleAction_NotifyFileDownload1, (Object)remoteFile.getPath()));
        this.outputWriter.println(NLS.bind((String)Messages.DownloadRuleAction_NotifyFileDownload2, (Object)localFile.getAbsolutePath()));
        this.doFileDownload(remoteFile, localFile);
    }

    /*
     * Unable to fully structure code
     */
    private void downloadDirectory(IRemoteItem remoteDirectory, File localDir) throws RemoteConnectionException, CancelException {
        Assert.isTrue((boolean)localDir.isAbsolute(), (String)"localDir.isAbsolute()");
        this.outputWriter.println(NLS.bind((String)Messages.DownloadRuleAction_NotifyDirectoryDownload1, (Object)remoteDirectory.getPath()));
        this.outputWriter.println(NLS.bind((String)Messages.DownloadRuleAction_NotifyDirectoryDownload2, (Object)localDir.getAbsolutePath()));
        fileTools = this.manager.getRemoteFileTools();
        enumeration = null;
        try {
            enumeration = fileTools.createRecursiveFileEnumeration(remoteDirectory.getPath());
        }
        catch (RemoteOperationException e) {
            this.errorWriter.println(NLS.bind((String)Messages.DownloadRuleAction_FailedFetchRemoteAttributes, (Object)e.getMessage()));
            return;
        }
        remoteRootPath = LinuxPath.fromString(remoteDirectory.getPath());
        localRootPath = new Path(localDir.getAbsolutePath());
        remoteRootPathLength = remoteRootPath.segmentCount();
        ** GOTO lbl29
        {
            this.errorWriter.println(NLS.bind((String)Messages.DownloadRuleAction_FailedFetchRemoteAttributes, (Object)enumeration.nextException()));
            do {
                if (enumeration.hasMoreExceptions()) continue block2;
                remoteItem = enumeration.nextElementAsItem();
                remotePath = LinuxPath.fromString(remoteItem.getPath());
                relativePath = remotePath.removeFirstSegments(remoteRootPathLength);
                localFilePath = localRootPath.append(relativePath);
                localFile = localFilePath.toFile();
                if (remoteItem.isDirectory()) {
                    this.doDirectoryDownload(remoteItem, localFile);
                    continue;
                }
                this.doFileDownload(remoteItem, localFile);
lbl29:
                // 3 sources

            } while (enumeration.hasMoreElements());
        }
        while (enumeration.hasMoreExceptions()) {
            this.errorWriter.println(NLS.bind((String)Messages.DownloadRuleAction_FailedFetchRemoteAttributes, (Object)enumeration.nextException()));
        }
    }

    private void doFileDownload(IRemoteItem remoteFile, File localFile) throws RemoteConnectionException, CancelException {
        Assert.isTrue((boolean)localFile.isAbsolute(), (String)"localFile.isAbsolute()");
        String remoteFileAsString = remoteFile.getPath();
        IRemoteCopyTools copyTools = this.manager.getRemoteCopyTools();
        if (this.rule.getOverwritePolicy() != 2) {
            long difference;
            if (this.rule.getOverwritePolicy() == 1) {
                if (localFile.exists()) {
                    this.outputWriter.println(NLS.bind((String)Messages.DownloadRuleAction_NotiftFileExistsLocally, (Object)localFile.getAbsolutePath()));
                    return;
                }
            } else if (this.rule.getOverwritePolicy() == 3 && (difference = remoteFile.getModificationTime() - localFile.lastModified()) < 1000L) {
                this.outputWriter.println(NLS.bind((String)Messages.DownloadRuleAction_NotiftNewerFileExistsLocally, (Object)localFile.getAbsolutePath()));
                return;
            }
        }
        try {
            copyTools.downloadFileToFile(remoteFileAsString, localFile);
        }
        catch (RemoteOperationException e) {
            this.errorWriter.println(NLS.bind((String)Messages.DownloadRuleAction_FailedSetDownloadFile, (Object)e.getMessage()));
            return;
        }
        boolean write = remoteFile.isWritable();
        boolean execute = remoteFile.isExecutable();
        if (this.rule.isAsReadOnly()) {
            write = false;
        }
        if (this.rule.isAsExecutable()) {
            execute = true;
        }
        IFileSystem localFileSystem = EFS.getLocalFileSystem();
        IFileStore fileStore = localFileSystem.getStore((IPath)new Path(localFile.getPath()));
        IFileInfo fileInfo = fileStore.fetchInfo();
        fileInfo.setAttribute(4, execute);
        fileInfo.setAttribute(2, !write);
        if (this.rule.isPreserveTimeStamp()) {
            long timestamp = remoteFile.getModificationTime();
            fileInfo.setLastModified(timestamp);
        }
        try {
            fileStore.putInfo(fileInfo, 3072, null);
        }
        catch (CoreException coreException) {
            this.errorWriter.println(NLS.bind((String)Messages.DownloadRuleAction_FailedSetLocalFileAttributes, (Object)localFile.getAbsolutePath()));
            return;
        }
    }

    private void doDirectoryDownload(IRemoteItem remoteDir, File localDir) throws RemoteConnectionException, CancelException {
        Assert.isTrue((boolean)localDir.isAbsolute(), (String)"localFile.isAbsolute()");
        if (!localDir.exists() && !localDir.mkdirs()) {
            this.errorWriter.println(NLS.bind((String)Messages.DownloadRuleAction_FailedCreateLocalDirectory, (Object)localDir.getAbsolutePath()));
            return;
        }
        boolean write = remoteDir.isWritable();
        boolean execute = true;
        if (this.rule.isAsReadOnly()) {
            write = false;
        }
        IFileSystem localFileSystem = EFS.getLocalFileSystem();
        IFileStore fileStore = localFileSystem.getStore((IPath)new Path(localDir.getPath()));
        IFileInfo fileInfo = fileStore.fetchInfo();
        fileInfo.setAttribute(4, execute);
        fileInfo.setAttribute(2, !write);
        if (this.rule.isPreserveTimeStamp()) {
            long timestamp = remoteDir.getModificationTime();
            fileInfo.setLastModified(timestamp);
        }
        try {
            fileStore.putInfo(fileInfo, 3072, null);
        }
        catch (CoreException coreException) {
            this.errorWriter.println(NLS.bind((String)Messages.DownloadRuleAction_FailedSetLocalDirectoryAttributes, (Object)localDir.getAbsolutePath()));
            return;
        }
    }
}

