/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.ui.widgets;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.core.Preferences;
import org.eclipse.ptp.remote.ui.IRemoteUIConnectionManager;
import org.eclipse.ptp.remote.ui.PTPRemoteUIPlugin;
import org.eclipse.ptp.remote.ui.messages.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RemoteConnectionWidget
extends Composite {
    private static final String EMPTY_STRING = "";
    private Combo remoteCombo = null;
    private final Combo connectionCombo;
    private final Button newConnectionButton;
    private IRemoteServices[] fRemoteServices;
    private IRemoteConnection fSelectedConnection;
    private IRemoteServices fSelectedServices;
    private final IRunnableContext fContext;
    private String[] fAttrHints;
    private String[] fAttrHintValues;
    private final ListenerList fSelectionListeners = new ListenerList();
    private final WidgetListener fWidgetListener = new WidgetListener();

    public RemoteConnectionWidget(Composite parent, int style, String title, IRunnableContext context) {
        super(parent, style);
        Label label;
        this.fContext = context;
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true));
        RemoteConnectionWidget body = this;
        if (title != null) {
            Group group = new Group((Composite)this, 0);
            group.setText(title);
            group.setLayout((Layout)new GridLayout(1, false));
            group.setLayoutData((Object)new GridData(4, 4, true, true));
            body = group;
        }
        Composite remoteComp = new Composite((Composite)body, 0);
        GridLayout remoteLayout = new GridLayout();
        remoteLayout.numColumns = 4;
        remoteLayout.marginWidth = 0;
        remoteComp.setLayout((Layout)remoteLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 4;
        remoteComp.setLayoutData((Object)gd);
        String id = Preferences.getString((String)PTPRemoteCorePlugin.getUniqueIdentifier(), (String)"remoteServicesId");
        if (id != null) {
            this.fSelectedServices = this.getRemoteServices(id);
        }
        if (this.fSelectedServices == null) {
            this.fSelectedServices = PTPRemoteCorePlugin.getDefault().getDefaultServices();
        }
        if (id == null) {
            label = new Label(remoteComp, 0);
            label.setText(Messages.RemoteConnectionWidget_remoteServiceProvider);
            gd = new GridData();
            gd.horizontalSpan = 1;
            label.setLayoutData((Object)gd);
            this.remoteCombo = new Combo(remoteComp, 12);
            gd = new GridData(768);
            gd.horizontalSpan = 3;
            this.remoteCombo.setLayoutData((Object)gd);
            this.remoteCombo.addModifyListener((ModifyListener)this.fWidgetListener);
            this.remoteCombo.setFocus();
        }
        label = new Label(remoteComp, 0);
        label.setText(Messages.RemoteConnectionWidget_connectionName);
        gd = new GridData();
        gd.horizontalSpan = 1;
        label.setLayoutData((Object)gd);
        this.connectionCombo = new Combo(remoteComp, 12);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.connectionCombo.setLayoutData((Object)gd);
        this.connectionCombo.addModifyListener((ModifyListener)this.fWidgetListener);
        if (id != null) {
            this.connectionCombo.setFocus();
        }
        this.newConnectionButton = new Button(remoteComp, 8);
        this.newConnectionButton.setText(Messages.RemoteConnectionWidget_new);
        GridData data = new GridData();
        this.newConnectionButton.setLayoutData((Object)data);
        this.newConnectionButton.addSelectionListener((SelectionListener)this.fWidgetListener);
        if (this.remoteCombo != null) {
            this.initializeRemoteServicesCombo(null);
        }
        this.handleRemoteServiceSelected(null);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.fSelectionListeners.add((Object)listener);
    }

    public IRemoteConnection getConnection() {
        return this.fSelectedConnection;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.fSelectionListeners.remove((Object)listener);
    }

    public void setConnection(IRemoteConnection connection) {
        this.handleRemoteServiceSelected(connection);
    }

    public void setEnabled(boolean enabled) {
        if (this.remoteCombo != null) {
            this.remoteCombo.setEnabled(enabled);
        }
        this.connectionCombo.setEnabled(enabled);
        this.newConnectionButton.setEnabled(enabled);
    }

    public void setHints(String[] attrHints, String[] attrHintValues) {
        this.fAttrHints = attrHints;
        this.fAttrHintValues = attrHintValues;
    }

    private IRemoteUIConnectionManager getUIConnectionManager() {
        if (this.fSelectedServices != null) {
            return PTPRemoteUIPlugin.getDefault().getRemoteUIServices(this.fSelectedServices).getUIConnectionManager();
        }
        return null;
    }

    private void notifyListeners(SelectionEvent e) {
        Object[] objectArray = this.fSelectionListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((SelectionListener)listener).widgetSelected(e);
            ++n2;
        }
    }

    protected IRemoteConnection getRemoteConnection(IRemoteServices services, String name) {
        IRemoteConnectionManager manager = this.getRemoteConnectionManager(services);
        if (manager != null) {
            return manager.getConnection(name);
        }
        return null;
    }

    protected IRemoteConnectionManager getRemoteConnectionManager(IRemoteServices services) {
        if (services != null) {
            return services.getConnectionManager();
        }
        return null;
    }

    protected IRemoteServices getRemoteServices(String id) {
        if (id != null && !id.equals(EMPTY_STRING)) {
            return PTPRemoteUIPlugin.getDefault().getRemoteServices(id, this.fContext);
        }
        return null;
    }

    protected void handleConnectionSelected() {
        boolean enabled = this.fWidgetListener.isEnabled();
        this.fWidgetListener.disable();
        this.fSelectedConnection = null;
        int currentSelection = this.connectionCombo.getSelectionIndex();
        if (currentSelection >= 0 && this.fSelectedServices != null) {
            String connectionName = this.connectionCombo.getItem(currentSelection);
            this.fSelectedConnection = this.getRemoteConnection(this.fSelectedServices, connectionName);
        }
        Event evt = new Event();
        evt.widget = this;
        this.notifyListeners(new SelectionEvent(evt));
        this.fWidgetListener.setEnabled(enabled);
    }

    protected void handleNewRemoteConnectionSelected() {
        if (this.getUIConnectionManager() != null) {
            this.handleRemoteServiceSelected(this.getUIConnectionManager().newConnection(this.getShell(), this.fAttrHints, this.fAttrHintValues));
        }
    }

    protected void handleRemoteServiceSelected(IRemoteConnection conn) {
        boolean enabled = this.fWidgetListener.isEnabled();
        this.fWidgetListener.disable();
        if (this.remoteCombo != null) {
            if (conn != null) {
                IRemoteServices services = conn.getRemoteServices();
                if (this.fRemoteServices != null) {
                    int index = 0;
                    while (index < this.fRemoteServices.length) {
                        if (this.fRemoteServices[index].getId().equals(services.getId())) {
                            this.remoteCombo.select(index);
                            break;
                        }
                        ++index;
                    }
                }
            }
            int selectionIndex = this.remoteCombo.getSelectionIndex();
            if (this.fRemoteServices != null && this.fRemoteServices.length > 0 && selectionIndex >= 0) {
                this.fSelectedServices = this.fRemoteServices[selectionIndex];
            }
        }
        IRemoteConnectionManager connectionManager = this.fSelectedServices.getConnectionManager();
        IRemoteConnection[] connections = connectionManager.getConnections();
        Arrays.sort(connections, new Comparator<IRemoteConnection>(){

            @Override
            public int compare(IRemoteConnection c1, IRemoteConnection c2) {
                return c1.getName().compareToIgnoreCase(c2.getName());
            }
        });
        this.connectionCombo.removeAll();
        int selected = 0;
        int i = 0;
        while (i < connections.length) {
            this.connectionCombo.add(connections[i].getName());
            if (conn != null && connections[i].getName().equals(conn.getName())) {
                selected = i;
            }
            ++i;
        }
        if (connections.length > 0) {
            this.connectionCombo.select(selected);
        }
        this.handleConnectionSelected();
        this.newConnectionButton.setEnabled(this.fSelectedServices.canCreateConnections());
        this.fWidgetListener.setEnabled(enabled);
    }

    protected String initializeRemoteServicesCombo(String id) {
        boolean enabled = this.fWidgetListener.isEnabled();
        this.fWidgetListener.disable();
        this.fRemoteServices = PTPRemoteUIPlugin.getDefault().getRemoteServices(this.fContext);
        IRemoteServices defServices = id != null ? this.getRemoteServices(id) : PTPRemoteCorePlugin.getDefault().getDefaultServices();
        int defIndex = 0;
        Arrays.sort(this.fRemoteServices, new Comparator<IRemoteServices>(){

            @Override
            public int compare(IRemoteServices c1, IRemoteServices c2) {
                return c1.getName().compareToIgnoreCase(c2.getName());
            }
        });
        this.remoteCombo.removeAll();
        int i = 0;
        while (i < this.fRemoteServices.length) {
            this.remoteCombo.add(this.fRemoteServices[i].getName());
            if (this.fRemoteServices[i].equals(defServices)) {
                defIndex = i;
            }
            ++i;
        }
        if (this.fRemoteServices.length > 0) {
            this.remoteCombo.select(defIndex);
        }
        this.fWidgetListener.setEnabled(enabled);
        return defServices.getId();
    }

    protected class WidgetListener
    implements SelectionListener,
    ModifyListener {
        private boolean listenerEnabled = true;

        protected WidgetListener() {
        }

        public void disable() {
            this.setEnabled(false);
        }

        public void enable() {
            this.setEnabled(true);
        }

        public synchronized boolean isEnabled() {
            return this.listenerEnabled;
        }

        public void modifyText(ModifyEvent e) {
            if (this.isEnabled()) {
                Object source = e.getSource();
                if (source == RemoteConnectionWidget.this.remoteCombo) {
                    RemoteConnectionWidget.this.handleRemoteServiceSelected(null);
                } else if (source == RemoteConnectionWidget.this.connectionCombo) {
                    RemoteConnectionWidget.this.handleConnectionSelected();
                }
            }
        }

        public synchronized void setEnabled(boolean enabled) {
            this.listenerEnabled = enabled;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            if (this.isEnabled()) {
                this.widgetSelected(e);
            }
        }

        public void widgetSelected(SelectionEvent e) {
            Object source;
            if (this.isEnabled() && (source = e.getSource()) == RemoteConnectionWidget.this.newConnectionButton) {
                RemoteConnectionWidget.this.handleNewRemoteConnectionSelected();
            }
        }

        protected void doWidgetDefaultSelected(SelectionEvent e) {
        }
    }
}

