/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.sdm.core;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ptp.core.Preferences;
import org.eclipse.ptp.debug.sdm.core.SDMPreferenceConstants;
import org.eclipse.ptp.debug.sdm.core.utils.DebugUtil;
import org.osgi.framework.BundleContext;

public class SDMDebugCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.ptp.debug.sdm.core";
    public static final String SDM_DEBUGGER_EXTENSION_POINT_ID = "SDMDebugger";
    public static final String DEBUGGER_ELEMENT = "debugger";
    private static SDMDebugCorePlugin plugin;
    private ArrayList<String> debuggerBackends = null;

    public static SDMDebugCorePlugin getDefault() {
        return plugin;
    }

    public static String getUniqueIdentifier() {
        return PLUGIN_ID;
    }

    public SDMDebugCorePlugin() {
        plugin = this;
    }

    public String[] getDebuggerBackends() {
        if (this.debuggerBackends == null) {
            this.initializeDebuggerBackends();
        }
        return this.debuggerBackends.toArray(new String[this.debuggerBackends.size()]);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        DebugUtil.configurePluginDebugOptions();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    private void initializeDebuggerBackends() {
        this.debuggerBackends = new ArrayList();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(SDMDebugCorePlugin.getUniqueIdentifier(), SDM_DEBUGGER_EXTENSION_POINT_ID);
        IConfigurationElement[] configs = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < configs.length) {
            IConfigurationElement configurationElement = configs[i];
            if (configurationElement.getName().equals(DEBUGGER_ELEMENT)) {
                String backend = configurationElement.getAttribute("name");
                this.debuggerBackends.add(backend);
                String isDefault = configurationElement.getAttribute("default");
                if (isDefault != null && isDefault.equals("true")) {
                    Preferences.setDefaultString((String)SDMDebugCorePlugin.getUniqueIdentifier(), (String)SDMPreferenceConstants.SDM_DEBUGGER_BACKEND_TYPE, (String)backend);
                }
            }
            ++i;
        }
    }
}

