/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.composite;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.cdt.internal.core.index.IIndexScope;
import org.eclipse.cdt.internal.core.index.composite.CompositingNotImplementedError;
import org.eclipse.cdt.internal.core.index.composite.ICompositesFactory;
import org.eclipse.core.runtime.CoreException;

public abstract class CompositeIndexBinding
implements IIndexBinding {
    protected final ICompositesFactory cf;
    protected final IIndexFragmentBinding rbinding;

    public CompositeIndexBinding(ICompositesFactory cf, IIndexFragmentBinding rbinding) {
        if (rbinding == null || cf == null) {
            throw new IllegalArgumentException();
        }
        this.cf = cf;
        this.rbinding = rbinding;
    }

    public ILinkage getLinkage() throws CoreException {
        return this.rbinding.getLinkage();
    }

    public String getName() {
        return this.rbinding.getName();
    }

    public char[] getNameCharArray() {
        return this.rbinding.getNameCharArray();
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this.rbinding)) {
            return this.rbinding;
        }
        return null;
    }

    public String[] getQualifiedName() {
        return new String[]{this.getName()};
    }

    public IIndexScope getScope() {
        return this.cf.getCompositeScope(this.rbinding.getScope());
    }

    public boolean hasDefinition() throws CoreException {
        this.fail();
        return false;
    }

    protected final void fail() {
        throw new CompositingNotImplementedError("Compositing feature not implemented");
    }

    public String toString() {
        return this.rbinding.toString();
    }

    public boolean isFileLocal() throws CoreException {
        return this.rbinding != null ? this.rbinding.isFileLocal() : false;
    }

    public IIndexFile getLocalToFile() throws CoreException {
        return this.rbinding != null ? this.rbinding.getLocalToFile() : null;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CompositeIndexBinding)) {
            return false;
        }
        CompositeIndexBinding otherComposite = (CompositeIndexBinding)other;
        return this.rbinding.equals(otherComposite.rbinding) && this.cf.equals(otherComposite.cf);
    }

    public int hashCode() {
        return this.rbinding.hashCode();
    }

    public IIndexBinding getOwner() {
        IIndexFragmentBinding owner = this.rbinding.getOwner();
        if (owner == null) {
            return null;
        }
        return this.cf.getCompositeBinding(owner);
    }

    public IIndexBinding getRawBinding() {
        return this.rbinding;
    }
}

