/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.internal.utils;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import org.eclipse.ptp.core.Preferences;
import org.eclipse.ptp.rm.jaxb.core.JAXBCorePlugin;
import org.eclipse.ptp.rm.jaxb.core.JAXBRMPreferenceConstants;

public class DebuggingLogger {
    private static DebuggingLogger instance;
    private PrintWriter out;
    private final boolean fSegment = Preferences.getBoolean((String)JAXBCorePlugin.getUniqueIdentifier(), (String)JAXBRMPreferenceConstants.SEGMENT_PATTERN);
    private final boolean fMatch = Preferences.getBoolean((String)JAXBCorePlugin.getUniqueIdentifier(), (String)JAXBRMPreferenceConstants.MATCH_STATUS);
    private final boolean fAction = Preferences.getBoolean((String)JAXBCorePlugin.getUniqueIdentifier(), (String)JAXBRMPreferenceConstants.ACTIONS);
    private final boolean fProperties = Preferences.getBoolean((String)JAXBCorePlugin.getUniqueIdentifier(), (String)JAXBRMPreferenceConstants.CREATED_PROPERTIES);
    private final boolean fCommandOutput = Preferences.getBoolean((String)JAXBCorePlugin.getUniqueIdentifier(), (String)JAXBRMPreferenceConstants.COMMAND_OUTPUT);

    public static synchronized DebuggingLogger getLogger() {
        if (instance == null) {
            DebuggingLogger.initialize();
        }
        return instance;
    }

    public static synchronized void initialize() {
        instance = new DebuggingLogger();
    }

    private DebuggingLogger() {
        String path = Preferences.getString((String)JAXBCorePlugin.getUniqueIdentifier(), (String)JAXBRMPreferenceConstants.LOG_FILE);
        if (this.out != null) {
            this.out.flush();
            this.out.close();
        }
        if (path != null && !"".equals(path)) {
            try {
                this.out = new PrintWriter(path);
            }
            catch (FileNotFoundException t) {
                JAXBCorePlugin.log((Throwable)t);
                this.out = new PrintWriter(System.out);
            }
        } else {
            this.out = new PrintWriter(System.out);
        }
    }

    public boolean getActionInfo() {
        return this.fAction;
    }

    public boolean getCommandOutput() {
        return this.fCommandOutput;
    }

    public boolean getMatch() {
        return this.fMatch;
    }

    public boolean getProperties() {
        return this.fProperties;
    }

    public boolean getSegment() {
        return this.fSegment;
    }

    public void logActionInfo(String message) {
        if (this.fAction) {
            this.out.println(message);
            this.out.flush();
        }
    }

    public void logCommandOutput(String message) {
        if (this.fCommandOutput) {
            this.out.println(message);
            this.out.flush();
        }
    }

    public void logMatchInfo(String message) {
        if (this.fMatch) {
            this.out.println(message);
            this.out.flush();
        }
    }

    public void logPropertyInfo(String message) {
        if (this.fProperties) {
            this.out.println(message);
            this.out.flush();
        }
    }

    public void logSegmentInfo(String message) {
        if (this.fSegment) {
            this.out.println(message);
            this.out.flush();
        }
    }
}

