/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.slurm.core.rtsystem;

import org.eclipse.ptp.core.attributes.AttributeDefinitionManager;
import org.eclipse.ptp.core.elements.IPResourceManager;
import org.eclipse.ptp.rm.slurm.core.SLURMJobAttributes;
import org.eclipse.ptp.rm.slurm.core.SLURMNodeAttributes;
import org.eclipse.ptp.rm.slurm.core.rmsystem.ISLURMResourceManagerConfiguration;
import org.eclipse.ptp.rm.slurm.core.rtsystem.SLURMProxyRuntimeClient;
import org.eclipse.ptp.rm.slurm.core.rtsystem.SLURMRuntimeSystem;
import org.eclipse.ptp.rmsystem.IResourceManager;
import org.eclipse.ptp.rtsystem.IRuntimeSystem;
import org.eclipse.ptp.rtsystem.IRuntimeSystemFactory;

public class SLURMRuntimeSystemFactory
implements IRuntimeSystemFactory {
    public IRuntimeSystem create(IResourceManager rm) {
        ISLURMResourceManagerConfiguration config = (ISLURMResourceManagerConfiguration)rm.getConfiguration();
        IPResourceManager prm = (IPResourceManager)rm.getAdapter(IPResourceManager.class);
        int baseId = 0;
        try {
            baseId = Integer.parseInt(prm.getID());
        }
        catch (NumberFormatException numberFormatException) {}
        SLURMProxyRuntimeClient runtimeProxy = new SLURMProxyRuntimeClient(config, baseId);
        SLURMRuntimeSystem slurmRMS = new SLURMRuntimeSystem(runtimeProxy);
        AttributeDefinitionManager attrDefMgr = slurmRMS.getAttributeDefinitionManager();
        attrDefMgr.setAttributeDefinitions(SLURMJobAttributes.getDefaultAttributeDefinitions());
        attrDefMgr.setAttributeDefinitions(SLURMNodeAttributes.getDefaultAttributeDefinitions());
        return slurmRMS;
    }
}

