/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.mpi.analysis.analysis;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTBreakStatement;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTContinueStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTDefaultStatement;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTGotoStatement;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerList;
import org.eclipse.cdt.core.dom.ast.IASTLabelStatement;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNullStatement;
import org.eclipse.cdt.core.dom.ast.IASTProblemStatement;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousExpression;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousStatement;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.BarrierExpression;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.BarrierTable;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.MPICallGraphNode;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.ICallGraph;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.ICallGraphNode;

public class MPIBarrierExprModified
extends ASTVisitor {
    protected BarrierTable bTable_;
    protected ICallGraph cg_;
    protected Hashtable<String, Stack<BarrierExpression>> stacks_;
    private static final boolean traceOn = false;
    protected MPICallGraphNode currentNode_;
    protected int depth = 0;
    protected Stack<IASTNode> caseParent = null;
    protected Stack<Boolean> withBreak = null;
    protected Hashtable<String, Stack<List>> caseBE = null;
    protected final int recursionCorrect = 0;
    protected final int recursionError = 1;
    protected final int noRecursion = 2;

    public MPIBarrierExprModified(BarrierTable btable, ICallGraph cg) {
        this.bTable_ = btable;
        this.cg_ = cg;
    }

    private void init() {
        String comm;
        this.stacks_ = new Hashtable();
        Enumeration<String> e = this.bTable_.getTable().keys();
        while (e.hasMoreElements()) {
            comm = e.nextElement();
            this.stacks_.put(comm, new Stack());
        }
        this.depth = 0;
        this.caseParent = new Stack();
        this.withBreak = new Stack();
        this.caseBE = new Hashtable();
        e = this.bTable_.getTable().keys();
        while (e.hasMoreElements()) {
            comm = e.nextElement();
            this.caseBE.put(comm, new Stack());
        }
    }

    public void run() {
        if (this.bTable_.isEmpty()) {
            return;
        }
        this.shouldVisitExpressions = true;
        this.shouldVisitStatements = true;
        this.shouldVisitDeclarations = true;
        ICallGraphNode n = this.cg_.botEntry();
        while (n != null) {
            this.currentNode_ = (MPICallGraphNode)n;
            if (this.currentNode_.marked && this.currentNode_.barrierRelated()) {
                this.init();
                IASTFunctionDefinition func = this.currentNode_.getFuncDef();
                func.accept((ASTVisitor)this);
                Enumeration<String> e = this.stacks_.keys();
                while (e.hasMoreElements()) {
                    String comm = e.nextElement();
                    Stack<BarrierExpression> sk = this.stacks_.get(comm);
                    BarrierExpression be = sk.pop();
                    this.currentNode_.setBarrierExpr(comm, be);
                }
            }
            n = n.botNext();
        }
    }

    public int visit(IASTStatement stmt) {
        if (stmt instanceof IASTSwitchStatement) {
            Enumeration<Stack<List>> e = this.caseBE.elements();
            while (e.hasMoreElements()) {
                Stack<List> caseBEsk = e.nextElement();
                caseBEsk.push(new ArrayList());
            }
            this.withBreak.push(new Boolean(false));
            ++this.depth;
        }
        return 3;
    }

    public int leave(IASTStatement stmt) {
        block47: {
            BarrierExpression condBE;
            BarrierExpression operand2;
            BarrierExpression operand1;
            BarrierExpression be;
            block56: {
                block55: {
                    block54: {
                        block53: {
                            block52: {
                                block51: {
                                    block50: {
                                        block49: {
                                            block48: {
                                                be = null;
                                                operand1 = null;
                                                operand2 = null;
                                                condBE = null;
                                                if (stmt instanceof IASTAmbiguousStatement) break block47;
                                                if (!(stmt instanceof IASTBreakStatement)) break block48;
                                                IASTBreakStatement bkStmt = (IASTBreakStatement)stmt;
                                                if (this.inCaseStmt(bkStmt)) {
                                                    Enumeration<String> e = this.caseBE.keys();
                                                    while (e.hasMoreElements()) {
                                                        String comm = e.nextElement();
                                                        Stack<List> caseBEsk = this.caseBE.get(comm);
                                                        Stack<BarrierExpression> sk = this.stacks_.get(comm);
                                                        be = new BarrierExpression(1);
                                                        sk.push(be);
                                                        List list = caseBEsk.peek();
                                                        int i = 1;
                                                        while (i < list.size()) {
                                                            CaseBarrierExpr cbe = (CaseBarrierExpr)list.get(i);
                                                            cbe.close();
                                                            i += 2;
                                                        }
                                                    }
                                                } else {
                                                    Enumeration<String> e = this.caseBE.keys();
                                                    while (e.hasMoreElements()) {
                                                        String comm = e.nextElement();
                                                        Stack<BarrierExpression> sk = this.stacks_.get(comm);
                                                        be = new BarrierExpression(1);
                                                        sk.push(be);
                                                    }
                                                }
                                                break block47;
                                            }
                                            if (!(stmt instanceof IASTCaseStatement)) break block49;
                                            IASTCaseStatement caseStmt = (IASTCaseStatement)stmt;
                                            if (!this.caseParent.empty()) {
                                                this.caseParent.pop();
                                            }
                                            this.caseParent.push(caseStmt.getParent());
                                            Enumeration<String> e = this.caseBE.keys();
                                            while (e.hasMoreElements()) {
                                                String comm = e.nextElement();
                                                Stack<List> caseBEsk = this.caseBE.get(comm);
                                                Stack<BarrierExpression> sk = this.stacks_.get(comm);
                                                be = new BarrierExpression(1);
                                                sk.push(be);
                                                List list = caseBEsk.peek();
                                                list.add(caseStmt);
                                                list.add(new CaseBarrierExpr(be, caseStmt.getExpression()));
                                            }
                                            if (!this.withBreak.empty()) {
                                                this.withBreak.pop();
                                            }
                                            this.withBreak.push(new Boolean(false));
                                            break block47;
                                        }
                                        if (!(stmt instanceof IASTCompoundStatement)) break block50;
                                        IASTCompoundStatement cmpStmt = (IASTCompoundStatement)stmt;
                                        IASTStatement[] s = cmpStmt.getStatements();
                                        if (s.length == 0) {
                                            return 3;
                                        }
                                        Enumeration<String> e = this.stacks_.keys();
                                        while (e.hasMoreElements()) {
                                            String comm = e.nextElement();
                                            Stack<BarrierExpression> sk = this.stacks_.get(comm);
                                            int count = 0;
                                            BarrierExpression[] BElist = new BarrierExpression[s.length];
                                            int i = 0;
                                            while (i < s.length) {
                                                if (s[i] != null) {
                                                    BElist[count] = sk.pop();
                                                    ++count;
                                                }
                                                ++i;
                                            }
                                            operand1 = BElist[count - 1];
                                            i = count - 2;
                                            while (i >= 0) {
                                                operand2 = BElist[i];
                                                operand1 = be = BarrierExpression.concatBE(operand1, operand2);
                                                --i;
                                            }
                                            sk.push(operand1);
                                            this.fixSwitch(comm, (IASTStatement)cmpStmt, operand1);
                                        }
                                        break block47;
                                    }
                                    if (!(stmt instanceof IASTContinueStatement)) break block51;
                                    Enumeration<String> e = this.caseBE.keys();
                                    while (e.hasMoreElements()) {
                                        String comm = e.nextElement();
                                        Stack<BarrierExpression> sk = this.stacks_.get(comm);
                                        be = new BarrierExpression(1);
                                        sk.push(be);
                                    }
                                    break block47;
                                }
                                if (!(stmt instanceof IASTDeclarationStatement)) break block52;
                                boolean initialized = false;
                                IASTDeclarationStatement declStmt = (IASTDeclarationStatement)stmt;
                                IASTDeclaration decl = declStmt.getDeclaration();
                                if (decl instanceof IASTSimpleDeclaration) {
                                    IASTSimpleDeclaration simpleDecl = (IASTSimpleDeclaration)decl;
                                    IASTDeclarator[] declarators = simpleDecl.getDeclarators();
                                    int i = 0;
                                    while (i < declarators.length) {
                                        IASTInitializer init = declarators[i].getInitializer();
                                        if (init != null) {
                                            initialized = true;
                                            Enumeration<String> e = this.stacks_.keys();
                                            while (e.hasMoreElements()) {
                                                String comm = e.nextElement();
                                                Stack<BarrierExpression> sk = this.stacks_.get(comm);
                                                be = this.getInitializerBE(sk, init);
                                                sk.push(be);
                                            }
                                        }
                                        ++i;
                                    }
                                }
                                if (initialized) break block47;
                                Enumeration<String> e = this.stacks_.keys();
                                while (e.hasMoreElements()) {
                                    String comm = e.nextElement();
                                    Stack<BarrierExpression> sk = this.stacks_.get(comm);
                                    be = new BarrierExpression(1);
                                    sk.push(be);
                                }
                                break block47;
                            }
                            if (!(stmt instanceof IASTDefaultStatement)) break block53;
                            IASTDefaultStatement dfStmt = (IASTDefaultStatement)stmt;
                            if (!this.caseParent.empty()) {
                                this.caseParent.pop();
                            }
                            this.caseParent.push(dfStmt.getParent());
                            Enumeration<String> e = this.caseBE.keys();
                            while (e.hasMoreElements()) {
                                String comm = e.nextElement();
                                Stack<List> caseBEsk = this.caseBE.get(comm);
                                this.stacks_.get(comm);
                                be = new BarrierExpression(1);
                                List list = caseBEsk.peek();
                                list.add(dfStmt);
                                list.add(new CaseBarrierExpr(be, null));
                            }
                            break block47;
                        }
                        if (!(stmt instanceof IASTDoStatement)) break block54;
                        IASTDoStatement doStmt = (IASTDoStatement)stmt;
                        Enumeration<String> e = this.stacks_.keys();
                        while (e.hasMoreElements()) {
                            String comm = e.nextElement();
                            Stack<BarrierExpression> sk = this.stacks_.get(comm);
                            condBE = doStmt.getCondition() != null ? sk.pop() : new BarrierExpression(1);
                            operand1 = doStmt.getBody() != null ? sk.pop() : new BarrierExpression(1);
                            be = BarrierExpression.concatBE(operand1, condBE, BarrierExpression.repeatBE(BarrierExpression.concatBE(operand1, condBE), doStmt.getCondition(), stmt));
                            sk.push(be);
                            this.fixSwitch(comm, stmt, be);
                        }
                        break block47;
                    }
                    if (!(stmt instanceof IASTExpressionStatement)) break block55;
                    Enumeration<String> e = this.stacks_.keys();
                    while (e.hasMoreElements()) {
                        String comm = e.nextElement();
                        Stack<BarrierExpression> sk = this.stacks_.get(comm);
                        be = sk.pop();
                        sk.push(be);
                        this.fixSwitch(comm, stmt, be);
                    }
                    break block47;
                }
                if (!(stmt instanceof IASTForStatement)) break block56;
                IASTForStatement forStmt = (IASTForStatement)stmt;
                BarrierExpression initBE = null;
                BarrierExpression iterBE = null;
                Enumeration<String> e = this.stacks_.keys();
                while (e.hasMoreElements()) {
                    String comm = e.nextElement();
                    Stack<BarrierExpression> sk = this.stacks_.get(comm);
                    operand1 = forStmt.getBody() != null ? sk.pop() : new BarrierExpression(1);
                    iterBE = forStmt.getIterationExpression() != null ? sk.pop() : new BarrierExpression(1);
                    condBE = forStmt.getConditionExpression() != null ? sk.pop() : new BarrierExpression(1);
                    initBE = forStmt.getInitializerStatement() != null ? sk.pop() : new BarrierExpression(1);
                    be = BarrierExpression.concatBE(initBE, condBE, BarrierExpression.repeatBE(BarrierExpression.concatBE(operand1, iterBE, condBE), forStmt.getConditionExpression(), stmt));
                    sk.push(be);
                    this.fixSwitch(comm, stmt, be);
                }
                break block47;
            }
            if (stmt instanceof IASTGotoStatement) break block47;
            if (stmt instanceof IASTIfStatement) {
                IASTIfStatement ifStmt = (IASTIfStatement)stmt;
                Enumeration<String> e = this.stacks_.keys();
                while (e.hasMoreElements()) {
                    String comm = e.nextElement();
                    Stack<BarrierExpression> sk = this.stacks_.get(comm);
                    operand2 = ifStmt.getElseClause() != null ? sk.pop() : new BarrierExpression(1);
                    operand1 = ifStmt.getThenClause() != null ? sk.pop() : new BarrierExpression(1);
                    condBE = ifStmt.getConditionExpression() != null ? sk.pop() : new BarrierExpression(1);
                    be = BarrierExpression.concatBE(condBE, BarrierExpression.branchBE(operand1, operand2, ifStmt.getConditionExpression(), stmt));
                    sk.push(be);
                    this.fixSwitch(comm, stmt, be);
                }
            } else if (!(stmt instanceof IASTLabelStatement)) {
                if (stmt instanceof IASTNullStatement) {
                    Enumeration<Stack<BarrierExpression>> e = this.stacks_.elements();
                    while (e.hasMoreElements()) {
                        Stack<BarrierExpression> sk = e.nextElement();
                        be = new BarrierExpression(1);
                        sk.push(be);
                    }
                } else if (stmt instanceof IASTProblemStatement) {
                    Enumeration<Stack<BarrierExpression>> e = this.stacks_.elements();
                    while (e.hasMoreElements()) {
                        Stack<BarrierExpression> sk = e.nextElement();
                        be = new BarrierExpression(1);
                        sk.push(be);
                    }
                } else if (stmt instanceof IASTReturnStatement) {
                    IASTReturnStatement rStmt = (IASTReturnStatement)stmt;
                    if (rStmt.getReturnValue() == null) {
                        Enumeration<Stack<BarrierExpression>> e = this.stacks_.elements();
                        while (e.hasMoreElements()) {
                            Stack<BarrierExpression> sk = e.nextElement();
                            be = new BarrierExpression(1);
                            sk.push(be);
                        }
                    } else {
                        Enumeration<String> e = this.caseBE.keys();
                        while (e.hasMoreElements()) {
                            String comm = e.nextElement();
                            Stack<BarrierExpression> sk = this.stacks_.get(comm);
                            be = sk.pop();
                            sk.push(be);
                            if (!this.withBreak.empty()) {
                                this.withBreak.pop();
                                this.withBreak.push(new Boolean(true));
                            }
                            this.fixSwitch(comm, (IASTStatement)rStmt, be);
                        }
                    }
                } else if (stmt instanceof IASTSwitchStatement) {
                    IASTSwitchStatement swStmt = (IASTSwitchStatement)stmt;
                    Enumeration<String> e = this.caseBE.keys();
                    while (e.hasMoreElements()) {
                        String comm = e.nextElement();
                        Stack<List> caseBEsk = this.caseBE.get(comm);
                        List list = caseBEsk.pop();
                        CaseBarrierExpr cbe = (CaseBarrierExpr)list.get(1);
                        operand1 = cbe.getBE();
                        int i = 3;
                        while (i < list.size()) {
                            cbe = (CaseBarrierExpr)list.get(i);
                            operand2 = cbe.getBE();
                            operand1 = be = BarrierExpression.branchBE(operand1, operand2, swStmt.getControllerExpression(), stmt);
                            i += 2;
                        }
                        Stack<BarrierExpression> sk = this.stacks_.get(comm);
                        sk.pop();
                        sk.push(operand1);
                    }
                    this.withBreak.pop();
                    this.caseParent.pop();
                    --this.depth;
                } else if (stmt instanceof IASTWhileStatement) {
                    IASTWhileStatement whStmt = (IASTWhileStatement)stmt;
                    Enumeration<String> e = this.stacks_.keys();
                    while (e.hasMoreElements()) {
                        String comm = e.nextElement();
                        Stack<BarrierExpression> sk = this.stacks_.get(comm);
                        operand1 = whStmt.getBody() != null ? sk.pop() : new BarrierExpression(1);
                        condBE = whStmt.getCondition() != null ? sk.pop() : new BarrierExpression(1);
                        be = BarrierExpression.concatBE(condBE, BarrierExpression.repeatBE(BarrierExpression.concatBE(operand1, condBE), whStmt.getCondition(), stmt));
                        sk.push(be);
                        this.fixSwitch(comm, stmt, be);
                    }
                }
            }
        }
        return 3;
    }

    private void fixSwitch(String key, IASTStatement stmt, BarrierExpression BE) {
        if (this.depth <= 0) {
            return;
        }
        if (stmt.getParent() == this.caseParent.peek()) {
            Stack<List> caseBEsk = this.caseBE.get(key);
            List list = caseBEsk.peek();
            boolean flag = this.withBreak.peek();
            int i = 1;
            while (i < list.size()) {
                CaseBarrierExpr cbe = (CaseBarrierExpr)list.get(i);
                if (flag) {
                    cbe.addFinalBEElement(BE);
                } else {
                    cbe.addBEElement(BE);
                }
                i += 2;
            }
        }
    }

    private boolean inCaseStmt(IASTBreakStatement stmt) {
        IASTNode parent = stmt.getParent();
        while (parent != null) {
            if (parent instanceof IASTForStatement || parent instanceof IASTDoStatement || parent instanceof IASTWhileStatement) {
                return false;
            }
            if (parent instanceof IASTSwitchStatement) {
                return true;
            }
            if (parent instanceof IASTFunctionDefinition) {
                return false;
            }
            parent = parent.getParent();
        }
        return false;
    }

    private BarrierExpression getInitializerBE(Stack sk, IASTInitializer init) {
        BarrierExpression BE = null;
        if (init instanceof IASTInitializerExpression) {
            BE = (BarrierExpression)sk.pop();
        } else if (init instanceof IASTInitializerList) {
            IASTInitializerList list = (IASTInitializerList)init;
            IASTInitializer[] inits = list.getInitializers();
            int j = 0;
            while (j < inits.length) {
                BE = BE == null ? this.getInitializerBE(sk, inits[j]) : BarrierExpression.concatBE(BE, this.getInitializerBE(sk, inits[j]));
                ++j;
            }
        }
        return BE;
    }

    public int leave(IASTExpression expr) {
        BarrierExpression be = null;
        BarrierExpression operand1 = null;
        BarrierExpression operand2 = null;
        BarrierExpression operand3 = null;
        if (!(expr instanceof IASTAmbiguousExpression)) {
            if (expr instanceof IASTArraySubscriptExpression) {
                Enumeration<Stack<BarrierExpression>> e = this.stacks_.elements();
                while (e.hasMoreElements()) {
                    Stack<BarrierExpression> sk = e.nextElement();
                    operand2 = sk.pop();
                    operand1 = sk.pop();
                    be = BarrierExpression.concatBE(operand1, operand2);
                    sk.push(be);
                }
            } else if (expr instanceof IASTBinaryExpression) {
                Enumeration<Stack<BarrierExpression>> e = this.stacks_.elements();
                while (e.hasMoreElements()) {
                    Stack<BarrierExpression> sk = e.nextElement();
                    operand2 = sk.pop();
                    operand1 = sk.pop();
                    be = BarrierExpression.concatBE(operand1, operand2);
                    sk.push(be);
                }
            } else if (!(expr instanceof IASTCastExpression)) {
                if (expr instanceof IASTConditionalExpression) {
                    IASTConditionalExpression cExpr = (IASTConditionalExpression)expr;
                    IASTNode parent = expr.getParent();
                    while (!(parent instanceof IASTStatement)) {
                        parent = parent.getParent();
                    }
                    Enumeration<Stack<BarrierExpression>> e = this.stacks_.elements();
                    while (e.hasMoreElements()) {
                        Stack<BarrierExpression> sk = e.nextElement();
                        operand2 = sk.pop();
                        operand1 = sk.pop();
                        operand3 = sk.pop();
                        be = BarrierExpression.concatBE(operand3, BarrierExpression.branchBE(operand1, operand2, cExpr.getLogicalConditionExpression(), (IASTStatement)parent));
                        sk.push(be);
                    }
                } else if (expr instanceof IASTExpressionList) {
                    IASTExpressionList exprList = (IASTExpressionList)expr;
                    IASTExpression[] exps = exprList.getExpressions();
                    if (exps.length == 0) {
                        return 3;
                    }
                    Enumeration<Stack<BarrierExpression>> e = this.stacks_.elements();
                    while (e.hasMoreElements()) {
                        Stack<BarrierExpression> sk = e.nextElement();
                        int count = 0;
                        BarrierExpression[] BElist = new BarrierExpression[exps.length];
                        int i = 0;
                        while (i < exps.length) {
                            if (exps[i] != null) {
                                BElist[count] = sk.pop();
                                ++count;
                            }
                            ++i;
                        }
                        operand1 = BElist[count - 1];
                        i = count - 2;
                        while (i >= 0) {
                            operand2 = BElist[i];
                            operand1 = be = BarrierExpression.concatBE(operand1, operand2);
                            --i;
                        }
                        sk.push(operand1);
                    }
                } else if (!(expr instanceof IASTFieldReference)) {
                    if (expr instanceof IASTFunctionCallExpression) {
                        IASTFunctionCallExpression fExpr = (IASTFunctionCallExpression)expr;
                        IASTExpression funcname = fExpr.getFunctionNameExpression();
                        IASTExpression parameter = fExpr.getParameterExpression();
                        String signature = funcname.getRawSignature();
                        int id = this.bTable_.isBarrier(fExpr);
                        if (id != -1) {
                            be = new BarrierExpression(id);
                            String comm = this.bTable_.getComm(id);
                            Enumeration<String> e = this.stacks_.keys();
                            while (e.hasMoreElements()) {
                                String commkey = e.nextElement();
                                Stack<BarrierExpression> sk = this.stacks_.get(commkey);
                                if (parameter != null) {
                                    sk.pop();
                                }
                                sk.pop();
                                if (commkey.equals(comm)) {
                                    sk.push(be);
                                    continue;
                                }
                                sk.push(new BarrierExpression(1));
                            }
                        } else {
                            MPICallGraphNode node = (MPICallGraphNode)this.cg_.getNode(this.currentNode_.getFileName(), signature);
                            if (node != null && node.barrierRelated()) {
                                Enumeration<String> e = this.stacks_.keys();
                                while (e.hasMoreElements()) {
                                    String comm = e.nextElement();
                                    Stack<BarrierExpression> sk = this.stacks_.get(comm);
                                    BarrierExpression funcBE = node.getBarrierExpr().get(comm);
                                    if (parameter != null) {
                                        sk.pop();
                                    }
                                    sk.pop();
                                    be = node == this.currentNode_ ? new BarrierExpression(node.getFuncName()) : (funcBE.isBot() ? new BarrierExpression(1) : new BarrierExpression(signature));
                                    sk.push(be);
                                }
                            } else {
                                be = new BarrierExpression(1);
                                Enumeration<Stack<BarrierExpression>> e = this.stacks_.elements();
                                while (e.hasMoreElements()) {
                                    Stack<BarrierExpression> sk = e.nextElement();
                                    if (parameter != null) {
                                        sk.pop();
                                    }
                                    sk.pop();
                                    sk.push(be);
                                }
                            }
                        }
                    } else if (expr instanceof IASTIdExpression) {
                        Enumeration<Stack<BarrierExpression>> e = this.stacks_.elements();
                        while (e.hasMoreElements()) {
                            Stack<BarrierExpression> sk = e.nextElement();
                            be = new BarrierExpression(1);
                            sk.push(be);
                        }
                    } else if (expr instanceof IASTLiteralExpression) {
                        Enumeration<Stack<BarrierExpression>> e = this.stacks_.elements();
                        while (e.hasMoreElements()) {
                            Stack<BarrierExpression> sk = e.nextElement();
                            be = new BarrierExpression(1);
                            sk.push(be);
                        }
                    } else if (expr instanceof IASTTypeIdExpression) {
                        Enumeration<Stack<BarrierExpression>> e = this.stacks_.elements();
                        while (e.hasMoreElements()) {
                            Stack<BarrierExpression> sk = e.nextElement();
                            be = new BarrierExpression(1);
                            sk.push(be);
                        }
                    } else {
                        boolean cfr_ignored_0 = expr instanceof IASTUnaryExpression;
                    }
                }
            }
        }
        return 3;
    }

    protected void checkBarrierRecursion() {
        for (List cycle : this.cg_.getCycles()) {
            boolean barrierRelated = false;
            for (MPICallGraphNode node : cycle) {
                if (!node.barrierRelated) continue;
                barrierRelated = true;
                break;
            }
            if (!barrierRelated) continue;
            if (cycle.size() > 1) {
                System.out.println("Multi-Function barrier related cycles");
                return;
            }
            this.currentNode_ = (MPICallGraphNode)((Object)cycle.get(0));
            Enumeration<String> e = this.currentNode_.getBarrierExpr().keys();
            while (e.hasMoreElements()) {
                String comm = e.nextElement();
                BarrierExpression BE = this.currentNode_.getBarrierExpr().get(comm);
                if (this.recursion(BE) != 1) continue;
                System.out.println("Recursion Error in " + comm);
            }
        }
    }

    protected int recursion(BarrierExpression BE) {
        System.out.println(BE.prettyPrinter());
        BarrierExpression.BarrierExpressionOP OP = BE.getOP();
        if (OP == null) {
            if (BE.isFunc()) {
                String funcName = BE.getFuncName();
                MPICallGraphNode fnode = (MPICallGraphNode)this.cg_.getNode(this.currentNode_.getFileName(), funcName);
                if (fnode == this.currentNode_) {
                    return 0;
                }
                return 2;
            }
            return 2;
        }
        if (OP.getOperator() == 1) {
            int v1 = this.recursion(BE.getOP1());
            int v2 = this.recursion(BE.getOP2());
            if (v1 == 1 || v2 == 1) {
                return 1;
            }
            if (v1 == 0 || v2 == 0) {
                return 0;
            }
            return 2;
        }
        if (OP.getOperator() == 3) {
            int v1 = this.recursion(BE.getOP1());
            int v2 = this.recursion(BE.getOP2());
            if (v1 == 2 && v2 == 2) {
                return 2;
            }
            return 1;
        }
        return this.recursion(BE.getOP1());
    }

    class CaseBarrierExpr {
        protected BarrierExpression BE;
        protected boolean closed;
        protected IASTExpression cond;

        CaseBarrierExpr(BarrierExpression be, IASTExpression cond) {
            this.BE = be;
            this.closed = false;
            this.cond = cond;
        }

        public void close() {
            this.closed = true;
        }

        public BarrierExpression getBE() {
            return this.BE;
        }

        public IASTExpression getCond() {
            return this.cond;
        }

        public void addBEElement(BarrierExpression be) {
            if (this.closed) {
                return;
            }
            this.BE = this.BE == null ? be : BarrierExpression.concatBE(this.BE, be);
        }

        public void addFinalBEElement(BarrierExpression be) {
            this.addBEElement(be);
            this.close();
        }
    }
}

