/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.IASTInternalScope;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.parser.ParserMessages;
import org.eclipse.core.runtime.PlatformObject;

public class ProblemBinding
extends PlatformObject
implements IProblemBinding,
IASTInternalScope {
    public static ProblemBinding NOT_INITIALIZED = new ProblemBinding(null, 0);
    protected final int id;
    protected char[] arg;
    protected IASTNode node;
    private final String message;
    private IBinding[] candidateBindings;

    public ProblemBinding(IASTName name, int id) {
        this(name, id, null, null);
    }

    public ProblemBinding(IASTName name, int id, IBinding[] candidateBindings) {
        this(name, id, null, candidateBindings);
    }

    public ProblemBinding(IASTNode node, int id, char[] arg) {
        this(node, id, arg, null);
    }

    public ProblemBinding(IASTNode node, int id, char[] arg, IBinding[] candidateBindings) {
        this.message = null;
        this.id = id;
        this.arg = arg;
        this.node = node;
        this.candidateBindings = candidateBindings;
    }

    public EScopeKind getKind() {
        return EScopeKind.eLocal;
    }

    public IASTNode getASTNode() {
        return this.node;
    }

    public IBinding[] getCandidateBindings() {
        return this.candidateBindings != null ? this.candidateBindings : IBinding.EMPTY_BINDING_ARRAY;
    }

    public void setCandidateBindings(IBinding[] foundBindings) {
        this.candidateBindings = foundBindings;
    }

    public int getID() {
        return this.id;
    }

    public String getMessage() {
        if (this.message != null) {
            return this.message;
        }
        String msg = ParserMessages.getProblemPattern(this);
        if (msg == null) {
            return "";
        }
        if (this.arg == null && this.node instanceof IASTName) {
            this.arg = ((IASTName)this.node).toCharArray();
        }
        if (this.arg != null) {
            msg = MessageFormat.format((String)msg, (Object[])new Object[]{new String(this.arg)});
        }
        return msg;
    }

    public String getName() {
        return this.node instanceof IASTName ? new String(((IASTName)this.node).getSimpleID()) : "";
    }

    public char[] getNameCharArray() {
        return this.node instanceof IASTName ? ((IASTName)this.node).getSimpleID() : CharArrayUtils.EMPTY;
    }

    public IScope getScope() throws DOMException {
        throw new DOMException(this);
    }

    public IASTNode getPhysicalNode() {
        return this.getASTNode();
    }

    public Object clone() {
        return this;
    }

    public IScope getParent() throws DOMException {
        throw new DOMException(this);
    }

    public IBinding[] find(String name) {
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    public IName getScopeName() {
        return null;
    }

    public void addName(IASTName name) {
    }

    public IBinding getBinding(IASTName name, boolean resolve) {
        return null;
    }

    public final IBinding[] getBindings(IASTName name, boolean resolve, boolean prefix) {
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    public IBinding getBinding(IASTName name, boolean resolve, IIndexFileSet fileSet) {
        return null;
    }

    public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup, IIndexFileSet fileSet) {
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    public boolean isSameType(IType type) {
        return type == this;
    }

    public String getFileName() {
        if (this.node != null) {
            return this.node.getContainingFilename();
        }
        return "";
    }

    public int getLineNumber() {
        IASTFileLocation fileLoc;
        if (this.node != null && (fileLoc = this.node.getFileLocation()) != null) {
            return fileLoc.getStartingLineNumber();
        }
        return -1;
    }

    public void addBinding(IBinding binding) {
    }

    public ILinkage getLinkage() {
        return Linkage.NO_LINKAGE;
    }

    public String toString() {
        return this.getMessage();
    }

    public IBinding getOwner() {
        IASTTranslationUnit tu;
        if (this.node instanceof IASTName && (tu = this.node.getTranslationUnit()) instanceof ICPPASTTranslationUnit) {
            return CPPVisitor.findNameOwner((IASTName)this.node, true);
        }
        return null;
    }

    public void setASTNode(IASTName name) {
        if (name != null) {
            this.node = name;
            this.arg = null;
        }
    }

    public void populateCache() {
    }

    public IType getType() {
        return new ProblemType(this.getID());
    }

    public boolean isStatic() {
        return false;
    }

    public String[] getQualifiedName() throws DOMException {
        throw new DOMException(this);
    }

    public char[][] getQualifiedNameCharArray() throws DOMException {
        throw new DOMException(this);
    }

    public boolean isGloballyQualified() throws DOMException {
        throw new DOMException(this);
    }

    public boolean isMutable() {
        return false;
    }

    public boolean isExtern() {
        return false;
    }

    public boolean isExternC() {
        return false;
    }

    public boolean isAuto() {
        return false;
    }

    public boolean isRegister() {
        return false;
    }

    public IValue getInitialValue() {
        return null;
    }

    public boolean isAnonymous() {
        return false;
    }

    public boolean isDeleted() {
        return false;
    }

    public boolean isInline() {
        return false;
    }

    public boolean takesVarArgs() {
        return false;
    }

    public IType[] getExceptionSpecification() {
        return null;
    }

    public boolean hasParameterPack() {
        return false;
    }

    public boolean isVirtual() {
        return false;
    }

    public boolean isPureVirtual() {
        return false;
    }

    public boolean isImplicit() {
        return false;
    }

    public boolean isExplicit() {
        return false;
    }

    public boolean hasDefaultValue() {
        return false;
    }

    public boolean isParameterPack() {
        return false;
    }
}

