/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui.views.array;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.ptp.debug.core.model.IPVariable;
import org.eclipse.ptp.debug.internal.ui.actions.AddVariableAction;
import org.eclipse.ptp.debug.internal.ui.views.AbstractPDebugViewEventHandler;
import org.eclipse.ptp.debug.internal.ui.views.PTabFolder;
import org.eclipse.ptp.debug.internal.ui.views.PTabItem;
import org.eclipse.ptp.debug.internal.ui.views.array.ArrayTabItem;
import org.eclipse.ptp.debug.internal.ui.views.array.ArrayViewEventHandler;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.debug.ui.messages.Messages;
import org.eclipse.swt.widgets.Composite;

public class ArrayView
extends PTabFolder {
    protected AbstractPDebugViewEventHandler fEventHandler = null;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.setEventHandler(new ArrayViewEventHandler(this));
    }

    protected void setEventHandler(AbstractPDebugViewEventHandler eventHandler) {
        this.fEventHandler = eventHandler;
    }

    protected AbstractPDebugViewEventHandler getEventHandler() {
        return this.fEventHandler;
    }

    public void dispose() {
        if (this.getEventHandler() != null) {
            this.getEventHandler().dispose();
        }
        super.dispose();
    }

    public void repaint(boolean all) {
        PTabItem[] pTabItemArray = this.getItems();
        int n = pTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            PTabItem item = pTabItemArray[n2];
            ((ArrayTabItem)item).clearContext();
            ((ArrayTabItem)item).setReloadVariable(all);
            ++n2;
        }
    }

    protected void configureToolBar(IToolBarManager toolBarMgr) {
        toolBarMgr.appendToGroup("variablegroup", (IAction)new AddVariableAction(this));
    }

    public void createTabItem(String tabName, Object selection) throws DebugException {
        if (selection instanceof IPVariable) {
            if (this.items.containsKey(tabName)) {
                throw new DebugException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, Messages.ArrayView_0, null));
            }
            ArrayTabItem item = new ArrayTabItem(this, tabName, (IPVariable)selection);
            item.init((IPVariable)selection);
            item.displayTab();
            this.folder.setSelection(item.getTabItem());
            this.items.put(tabName, item);
        }
    }
}

