/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.internal.rulesengine;

import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.launch.internal.rulesengine.DownloadBackRule;
import org.eclipse.ptp.launch.rulesengine.ILaunchProcessCallback;
import org.eclipse.ptp.launch.rulesengine.IRuleAction;
import org.eclipse.ptp.remote.core.IRemoteFileManager;

public class DownloadBackAction
implements IRuleAction {
    private final ILaunchProcessCallback fProcess;
    private final DownloadBackRule fRule;
    private final ILaunchConfiguration fConfiguration;
    private final IProgressMonitor fMonitor;

    public DownloadBackAction(ILaunchProcessCallback process, ILaunchConfiguration configuration, DownloadBackRule downloadBackRule, IProgressMonitor monitor) {
        this.fProcess = process;
        this.fRule = downloadBackRule;
        this.fConfiguration = configuration;
        this.fMonitor = monitor;
    }

    public void run() throws CoreException {
        Assert.isNotNull((Object)this.fProcess);
        Assert.isNotNull((Object)this.fRule);
        Assert.isNotNull((Object)this.fConfiguration);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)this.fMonitor, (int)10);
        IRemoteFileManager remoteFileManager = this.fProcess.getRemoteFileManager(this.fConfiguration, (IProgressMonitor)progress.newChild(2));
        IRemoteFileManager localFileManager = this.fProcess.getLocalFileManager(this.fConfiguration);
        int i = 0;
        while (i < this.fRule.count()) {
            IFileStore remoteFileStore = null;
            IFileStore localFileStore = null;
            remoteFileStore = remoteFileManager.getResource(this.fRule.getRemoteFile(i).toString());
            localFileStore = localFileManager.getResource(this.fRule.getLocalFile(i).getAbsolutePath());
            this.doDownload(remoteFileStore, localFileStore, (IProgressMonitor)progress.newChild(8));
            ++i;
        }
    }

    private void doDownload(IFileStore remoteFileStore, IFileStore localFileStore, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            IFileInfo remoteFileInfo = remoteFileStore.fetchInfo(0, (IProgressMonitor)progress.newChild(5));
            if (!remoteFileInfo.exists()) {
                return;
            }
            remoteFileStore.copy(localFileStore, 2, (IProgressMonitor)progress.newChild(5));
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }
}

