/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.ui;

import java.util.EnumSet;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.rdt.sync.core.PathResourceMatcher;
import org.eclipse.ptp.rdt.sync.core.ResourceMatcher;
import org.eclipse.ptp.rdt.sync.core.SyncFileFilter;
import org.eclipse.ptp.rdt.sync.core.SyncFlag;
import org.eclipse.ptp.rdt.sync.core.SyncManager;
import org.eclipse.ptp.rdt.sync.ui.RDTSyncUIPlugin;
import org.eclipse.ptp.rdt.sync.ui.SyncFileFilterPage;
import org.eclipse.ptp.rdt.sync.ui.messages.Messages;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;

public class SyncMenuOperation
extends AbstractHandler
implements IElementUpdater {
    private static final String SYNC_COMMAND_PARAMETER_ID = "org.eclipse.ptp.rdt.sync.ui.syncCommand.syncModeParameter";
    private static final String syncActiveCommand = "sync_active";
    private static final String syncAllCommand = "sync_all";
    private static final String setNoneCommand = "set_none";
    private static final String setActiveCommand = "set_active";
    private static final String setAllCommand = "set_all";
    private static final String syncAutoCommand = "sync_auto";
    private static final String syncFileList = "sync_file_list";
    private static final String syncDefaultFileList = "sync_default_file_list";
    private static final String syncExcludeCommand = "sync_exclude";
    private static final String syncIncludeCommand = "sync_include";

    /*
     * Unable to fully structure code
     */
    public Object execute(ExecutionEvent event) {
        block21: {
            command = event.getParameter("org.eclipse.ptp.rdt.sync.ui.syncCommand.syncModeParameter");
            project = this.getProject();
            if (project == null) {
                RDTSyncUIPlugin.getDefault().logErrorMessage(Messages.SyncMenuOperation_0);
                return null;
            }
            try {
                block22: {
                    if (command.equals("sync_active")) {
                        SyncManager.sync(null, (IProject)project, (EnumSet)SyncFlag.FORCE, null);
                        break block21;
                    }
                    if (command.equals("sync_all")) {
                        SyncManager.syncAll(null, (IProject)project, (EnumSet)SyncFlag.FORCE, null);
                        break block21;
                    }
                    if (command.equals("set_active")) {
                        SyncManager.setSyncMode((IProject)project, (SyncManager.SYNC_MODE)SyncManager.SYNC_MODE.ACTIVE);
                        SyncManager.sync(null, (IProject)project, (EnumSet)SyncFlag.FORCE, null);
                        break block21;
                    }
                    if (command.equals("set_all")) {
                        SyncManager.setSyncMode((IProject)project, (SyncManager.SYNC_MODE)SyncManager.SYNC_MODE.ALL);
                        SyncManager.syncAll(null, (IProject)project, (EnumSet)SyncFlag.FORCE, null);
                        break block21;
                    }
                    if (command.equals("set_none")) {
                        SyncManager.setSyncMode((IProject)project, (SyncManager.SYNC_MODE)SyncManager.SYNC_MODE.NONE);
                        break block21;
                    }
                    if (command.equals("sync_auto")) {
                        SyncManager.setSyncAuto((boolean)(SyncManager.getSyncAuto() == false));
                        if (SyncManager.getSyncAuto()) {
                            syncMode = SyncManager.getSyncMode((IProject)project);
                            if (syncMode == SyncManager.SYNC_MODE.ACTIVE) {
                                SyncManager.sync(null, (IProject)project, (EnumSet)SyncFlag.FORCE, null);
                            } else if (syncMode == SyncManager.SYNC_MODE.ALL) {
                                SyncManager.syncAll(null, (IProject)project, (EnumSet)SyncFlag.FORCE, null);
                            }
                        }
                        break block21;
                    }
                    if (!command.equals("sync_exclude") && !command.equals("sync_include")) break block22;
                    sff = SyncManager.getFileFilter((IProject)project);
                    sel = this.getSelectedElements();
                    type = SyncFileFilter.PatternType.EXCLUDE;
                    if (command.equals("sync_include")) {
                        type = SyncFileFilter.PatternType.INCLUDE;
                    }
                    var10_7 = sel.toArray();
                    var9_8 = var10_7.length;
                    var8_9 = 0;
                    while (var8_9 < var9_8) {
                        block23: {
                            element = var10_7[var8_9];
                            if (!(element instanceof IResource)) break block23;
                            selection = (IResource)element;
                            ** GOTO lbl59
                        }
                        if (!(element instanceof IAdaptable)) {
                            RDTSyncUIPlugin.getDefault().logErrorMessage(Messages.SyncMenuOperation_6);
                        } else {
                            selection = (IResource)((IAdaptable)element).getAdapter(IResource.class);
lbl59:
                            // 2 sources

                            path = selection.getProjectRelativePath();
                            sff.addPattern((ResourceMatcher)new PathResourceMatcher(path), type);
                        }
                        ++var8_9;
                    }
                    SyncManager.saveFileFilter((IProject)project, (SyncFileFilter)sff);
                    break block21;
                }
                if (command.equals("sync_file_list")) {
                    SyncFileFilterPage.open(project, null);
                } else if (command.equals("sync_default_file_list")) {
                    SyncFileFilterPage.open(null, null);
                }
            }
            catch (CoreException v0) {
                RDTSyncUIPlugin.getDefault().logErrorMessage(Messages.SyncMenuOperation_1);
            }
        }
        window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        if (window != null) {
            service = (ICommandService)window.getService(ICommandService.class);
            service.refreshElements(event.getCommand().getId(), null);
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        String command = (String)parameters.get(SYNC_COMMAND_PARAMETER_ID);
        if (command == null) {
            RDTSyncUIPlugin.getDefault().logErrorMessage(Messages.SyncMenuOperation_2);
            return;
        }
        IProject project = this.getProject();
        if (project == null) {
            return;
        }
        SyncManager.SYNC_MODE syncMode = SyncManager.getSyncMode((IProject)project);
        if (command.equals(setActiveCommand) && syncMode == SyncManager.SYNC_MODE.ACTIVE || command.equals(setAllCommand) && syncMode == SyncManager.SYNC_MODE.ALL || command.equals(setNoneCommand) && syncMode == SyncManager.SYNC_MODE.NONE || command.equals(syncAutoCommand) && SyncManager.getSyncAuto()) {
            element.setChecked(true);
        } else {
            element.setChecked(false);
        }
    }

    private IProject getProject() {
        IStructuredSelection selection = this.getSelectedElements();
        if (selection == null) {
            return null;
        }
        Object firstElement = selection.getFirstElement();
        if (!(firstElement instanceof IAdaptable)) {
            return null;
        }
        Object o = ((IAdaptable)firstElement).getAdapter(IResource.class);
        if (o == null) {
            return null;
        }
        IResource resource = (IResource)o;
        return resource.getProject();
    }

    private IStructuredSelection getSelectedElements() {
        IWorkbenchWindow wnd = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage pg = wnd.getActivePage();
        ISelection sel = pg.getSelection();
        if (!(sel instanceof IStructuredSelection)) {
            return null;
        }
        return (IStructuredSelection)sel;
    }
}

