/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.c.ICASTArrayModifier;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;

public class CASTArrayModifier
extends ASTNode
implements ICASTArrayModifier,
IASTAmbiguityParent {
    private IASTExpression exp;
    private boolean isVolatile;
    private boolean isRestrict;
    private boolean isStatic;
    private boolean isConst;
    private boolean isVarSized;

    public CASTArrayModifier() {
    }

    public CASTArrayModifier(IASTExpression exp) {
        this.setConstantExpression(exp);
    }

    public CASTArrayModifier copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    public CASTArrayModifier copy(IASTNode.CopyStyle style) {
        CASTArrayModifier copy = new CASTArrayModifier(this.exp == null ? null : this.exp.copy(style));
        copy.setOffsetAndLength(this);
        copy.isVolatile = this.isVolatile;
        copy.isRestrict = this.isRestrict;
        copy.isStatic = this.isStatic;
        copy.isConst = this.isConst;
        copy.isVarSized = this.isVarSized;
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    public IASTExpression getConstantExpression() {
        return this.exp;
    }

    public void setConstantExpression(IASTExpression expression) {
        this.assertNotFrozen();
        this.exp = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(CONSTANT_EXPRESSION);
        }
    }

    public boolean isConst() {
        return this.isConst;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isRestrict() {
        return this.isRestrict;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public void setConst(boolean value) {
        this.assertNotFrozen();
        this.isConst = value;
    }

    public void setVolatile(boolean value) {
        this.assertNotFrozen();
        this.isVolatile = value;
    }

    public void setRestrict(boolean value) {
        this.assertNotFrozen();
        this.isRestrict = value;
    }

    public void setStatic(boolean value) {
        this.assertNotFrozen();
        this.isStatic = value;
    }

    public boolean isVariableSized() {
        return this.isVarSized;
    }

    public void setVariableSized(boolean value) {
        this.assertNotFrozen();
        this.isVarSized = value;
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitArrayModifiers) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.exp != null && !this.exp.accept(action)) {
            return false;
        }
        return !action.shouldVisitArrayModifiers || action.leave(this) != 2;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.exp) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.exp = (IASTExpression)other;
        }
    }
}

