/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.search;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariable;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.browser.ASTTypeInfo;
import org.eclipse.cdt.internal.core.dom.parser.c.CVariableReadWriteFlags;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVariableReadWriteFlags;
import org.eclipse.cdt.internal.core.index.CIndex;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.index.IWritableIndexFragment;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.internal.rdt.core.index.DummyFile;
import org.eclipse.ptp.internal.rdt.core.index.DummyName;
import org.eclipse.ptp.internal.rdt.core.index.IndexQueries;
import org.eclipse.ptp.internal.rdt.core.model.ICProjectFactory;
import org.eclipse.ptp.internal.rdt.core.model.RemoteCProjectFactory;
import org.eclipse.ptp.internal.rdt.core.search.RemoteLineSearchElement;
import org.eclipse.ptp.internal.rdt.core.search.RemoteSearchMatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemoteSearchQuery
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int FIND_DECLARATIONS = 1;
    public static final int FIND_DEFINITIONS = 2;
    public static final int FIND_REFERENCES = 4;
    public static final int FIND_DECLARATIONS_DEFINITIONS = 3;
    public static final int FIND_ALL_OCCURRENCES = 7;
    public static final long M_PARAMETER_TYPES = 1L;
    protected int flags;
    protected ICElement[] scope;
    protected ICProject[] projects;
    private Set<String> fullPathFilter;
    protected List<RemoteSearchMatch> fMatches;
    protected Map<IIndexFile, RemoteLineSearchElement[]> remoteLineSearchElements;
    protected Map<IIndexFile, Set<RemoteLineSearchElement.RemoteLineSearchElementMatch>> remoteLineSearchElementMatches;
    protected Map<IIndexFileLocation, RemoteLineSearchElement[]> localLineSearchElements;
    protected Map<IIndexFileLocation, Set<RemoteLineSearchElement.RemoteLineSearchElementMatch>> localLineSearchElementMatches;
    protected IIndexLocationConverter fConverter;
    protected ICElement cElement;

    protected RemoteSearchQuery(ICElement[] scope, int flags) {
        this.flags = flags;
        this.scope = scope;
        if (scope != null) {
            HashMap<String, ICProject> projectMap = new HashMap<String, ICProject>();
            HashSet<String> pathFilter = new HashSet<String>();
            boolean needFilter = false;
            int i = 0;
            while (i < scope.length) {
                ICProject project = scope[i].getCProject();
                if (project != null && project.getProject().isOpen()) {
                    IResource res = scope[i].getResource();
                    if (res != null) {
                        pathFilter.add(res.getFullPath().toString());
                        needFilter = needFilter || !(res instanceof IProject);
                    }
                    projectMap.put(project.getElementName(), project);
                }
                this.projects = projectMap.values().toArray(new ICProject[projectMap.size()]);
                if (needFilter) {
                    this.fullPathFilter = pathFilter;
                }
                ++i;
            }
        }
        this.fMatches = new LinkedList<RemoteSearchMatch>();
        this.remoteLineSearchElementMatches = new HashMap<IIndexFile, Set<RemoteLineSearchElement.RemoteLineSearchElementMatch>>();
        this.localLineSearchElementMatches = new HashMap<IIndexFileLocation, Set<RemoteLineSearchElement.RemoteLineSearchElementMatch>>();
        this.remoteLineSearchElements = new HashMap<IIndexFile, RemoteLineSearchElement[]>();
        this.localLineSearchElements = new HashMap<IIndexFileLocation, RemoteLineSearchElement[]>();
    }

    protected ICElement CElementForBinding(IIndex index, IBinding binding) throws CoreException {
        IIndexName[] names = index.findNames(binding, 3);
        if (names.length > 0) {
            return IndexQueries.getCElementForName(null, index, names[0], this.fConverter, (ICProjectFactory)new RemoteCProjectFactory());
        }
        return null;
    }

    public void cleanupResult() {
        if (this.fMatches != null) {
            this.fMatches.clear();
        }
        if (this.remoteLineSearchElementMatches != null) {
            this.remoteLineSearchElementMatches.clear();
        }
        if (this.localLineSearchElementMatches != null) {
            this.localLineSearchElementMatches.clear();
        }
        if (this.remoteLineSearchElements != null) {
            this.remoteLineSearchElements.clear();
        }
        if (this.localLineSearchElements != null) {
            this.localLineSearchElements.clear();
        }
    }

    public ICElement getcElement() {
        return this.cElement;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    protected boolean filterName(IIndexName name) {
        return false;
    }

    private void createMatchesFromNames(IIndex index, Map<IIndexFile, Set<RemoteLineSearchElement.RemoteLineSearchElementMatch>> fileMatches, Collection<IIndexName> names, boolean isPolymorphicOnly) throws CoreException {
        if (names == null) {
            return;
        }
        ICProject preferred = this.getPreferredProject();
        for (IIndexName name : names) {
            if (this.filterName(name) || isPolymorphicOnly && !name.couldBePolymorphicMethodCall()) continue;
            IASTFileLocation loc = name.getFileLocation();
            IIndexFile file = name.getFile();
            Set<RemoteLineSearchElement.RemoteLineSearchElementMatch> matches = fileMatches.get(file);
            if (matches == null) {
                matches = new HashSet<RemoteLineSearchElement.RemoteLineSearchElementMatch>();
                fileMatches.put(file, matches);
            }
            int nodeOffset = loc.getNodeOffset();
            int nodeLength = loc.getNodeLength();
            ICElement enclosingElement = null;
            IIndexName enclosingDefinition = name.getEnclosingDefinition();
            if (enclosingDefinition != null) {
                enclosingElement = IndexQueries.getCElementForName(preferred, index, enclosingDefinition, this.fConverter, (ICProjectFactory)new RemoteCProjectFactory());
            }
            boolean isWriteAccess = name.isWriteAccess();
            matches.add(new RemoteLineSearchElement.RemoteLineSearchElementMatch(nodeOffset, nodeLength, isPolymorphicOnly, enclosingElement, isWriteAccess));
        }
    }

    private void collectNames(IIndex index, Collection<IIndexName> names, Collection<IIndexName> polymorphicNames) throws CoreException {
        HashMap<IIndexFile, Set<RemoteLineSearchElement.RemoteLineSearchElementMatch>> thisRemoteLineSearchElementMatches = new HashMap<IIndexFile, Set<RemoteLineSearchElement.RemoteLineSearchElementMatch>>();
        this.createMatchesFromNames(index, thisRemoteLineSearchElementMatches, names, false);
        this.createMatchesFromNames(index, thisRemoteLineSearchElementMatches, polymorphicNames, true);
        for (Map.Entry entry : thisRemoteLineSearchElementMatches.entrySet()) {
            IIndexFile file = (IIndexFile)entry.getKey();
            Set matches = (Set)entry.getValue();
            RemoteLineSearchElement[] lineElements = new RemoteLineSearchElement[]{};
            IndexLocationFactory.getAbsolutePath((IIndexFileLocation)file.getLocation());
            RemoteLineSearchElement.RemoteLineSearchElementMatch[] matchesArray = matches.toArray(new RemoteLineSearchElement.RemoteLineSearchElementMatch[matches.size()]);
            lineElements = RemoteLineSearchElement.createElements(file.getLocation(), matchesArray);
            IIndexFileLocation remoteIndexLocation = this.fConverter.fromInternalFormat(file.getLocation().getURI().getPath());
            DummyFile indexDumFile = new DummyFile(remoteIndexLocation, file.getTimestamp());
            this.remoteLineSearchElementMatches.put(indexDumFile, matches);
            RemoteLineSearchElement[] remoteLineSearchElementArray = lineElements;
            int n = lineElements.length;
            int n2 = 0;
            while (n2 < n) {
                RemoteLineSearchElement searchElement = remoteLineSearchElementArray[n2];
                searchElement.setLocation(remoteIndexLocation);
                ++n2;
            }
            this.remoteLineSearchElements.put(indexDumFile, lineElements);
        }
    }

    private void collectNames(IIndex index, IIndexName[] names) throws CoreException {
        int i = 0;
        while (i < names.length) {
            IIndexName name = names[i];
            if (!this.filterName(name)) {
                IASTFileLocation loc = name.getFileLocation();
                IIndexBinding binding = index.findBinding((IName)name);
                IIndexFileLocation indexLocation = this.fConverter.fromInternalFormat(loc.getFileName());
                this.fMatches.add(new RemoteSearchMatch(index, binding, new DummyName(name, loc, indexLocation), loc.getNodeOffset(), loc.getNodeLength()));
            }
            ++i;
        }
    }

    protected void createMatches(IIndex index, IBinding binding) throws CoreException {
        this.createMatches(index, new IBinding[]{binding});
    }

    protected void createMatches(IIndex index, IBinding[] bindings) throws CoreException {
        IBinding binding;
        if (bindings == null) {
            return;
        }
        ArrayList<IIndexName> names = new ArrayList<IIndexName>();
        ArrayList<IIndexName> polymorphicNames = null;
        HashSet<Object> handled = new HashSet<Object>();
        IBinding[] iBindingArray = bindings;
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            binding = iBindingArray[n2];
            if (binding != null && handled.add(binding)) {
                this.createMatches1(index, binding, names);
            }
            ++n2;
        }
        if ((this.flags & 4) != 0) {
            iBindingArray = bindings;
            n = bindings.length;
            n2 = 0;
            while (n2 < n) {
                binding = iBindingArray[n2];
                if (binding != null) {
                    ICPPMethod iCPPMethod;
                    ICPPMethod[] msInBases;
                    List<? extends IBinding> specializations = IndexQueries.findSpecializations(binding);
                    for (IBinding iBinding : specializations) {
                        if (iBinding == null || !handled.add(iBinding)) continue;
                        this.createMatches1(index, iBinding, names);
                    }
                    if (binding instanceof ICPPMethod && (msInBases = ClassTypeHelper.findOverridden((ICPPMethod)(iCPPMethod = (ICPPMethod)binding))).length > 0) {
                        if (polymorphicNames == null) {
                            polymorphicNames = new ArrayList<IIndexName>();
                        }
                        ICPPMethod[] iCPPMethodArray = msInBases;
                        int n3 = msInBases.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            ICPPMethod mInBase = iCPPMethodArray[n4];
                            if (mInBase != null && handled.add(mInBase)) {
                                this.createMatches1(index, (IBinding)mInBase, polymorphicNames);
                            }
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
        }
        if (!names.isEmpty()) {
            this.collectNames(index, names, polymorphicNames);
        }
    }

    private void createMatches1(IIndex index, IBinding binding, List<IIndexName> names) throws CoreException {
        IIndexName[] bindingNames = index.findNames(binding, this.flags);
        if (this.fullPathFilter == null) {
            names.addAll(Arrays.asList(bindingNames));
        } else {
            IIndexName[] iIndexNameArray = bindingNames;
            int n = bindingNames.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexName name = iIndexNameArray[n2];
                String fullPath = name.getFile().getLocation().getFullPath();
                if (this.accept(fullPath)) {
                    names.add(name);
                }
                ++n2;
            }
        }
    }

    private boolean accept(String fullPath) {
        while (!this.fullPathFilter.contains(fullPath)) {
            int idx = fullPath.lastIndexOf(47);
            if (idx < 0) {
                return false;
            }
            fullPath = fullPath.substring(0, idx);
        }
        return true;
    }

    public boolean isWriteOccurrence(IASTName node, IBinding binding) {
        boolean isWrite = binding instanceof ICPPVariable ? (CPPVariableReadWriteFlags.getReadWriteFlags((IASTName)node) & 0x40) != 0 : (CVariableReadWriteFlags.getReadWriteFlags((IASTName)node) & 0x40) != 0;
        return isWrite;
    }

    protected void createLocalMatches(IASTTranslationUnit ast, IBinding binding) throws CoreException {
        if (binding != null) {
            HashSet<IASTName> names = new HashSet<IASTName>();
            names.addAll(Arrays.asList(ast.getDeclarationsInAST(binding)));
            names.addAll(Arrays.asList(ast.getDefinitionsInAST(binding)));
            names.addAll(Arrays.asList(ast.getReferences(binding)));
            IIndexFileLocation indexFileLocation = null;
            HashSet<RemoteLineSearchElement.RemoteLineSearchElementMatch> localMatches = new HashSet<RemoteLineSearchElement.RemoteLineSearchElementMatch>();
            for (IASTName name : names) {
                ASTTypeInfo typeInfo;
                if (!((this.flags & 1) != 0 && name.isDeclaration() || (this.flags & 2) != 0 && name.isDefinition()) && ((this.flags & 4) == 0 || !name.isReference()) || (typeInfo = ASTTypeInfo.create((IASTName)name)) == null) continue;
                ITypeReference ref = typeInfo.getResolvedReference();
                indexFileLocation = typeInfo.getIFL();
                if (ref == null) continue;
                ICElement element = null;
                IASTName node = name;
                while (node != null && !(node instanceof IASTFunctionDefinition)) {
                    node = node.getParent();
                }
                if (node != null) {
                    IASTFunctionDefinition definition = (IASTFunctionDefinition)node;
                    element = IndexQueries.getCElementForName(this.getPreferredProject(), ast.getIndex(), definition.getDeclarator().getName(), this.fConverter, (ICProjectFactory)new RemoteCProjectFactory());
                }
                boolean isWrite = this.isWriteOccurrence(name, binding);
                localMatches.add(new RemoteLineSearchElement.RemoteLineSearchElementMatch(ref.getOffset(), ref.getLength(), false, element, isWrite));
            }
            RemoteLineSearchElement.RemoteLineSearchElementMatch[] matchesArray = localMatches.toArray(new RemoteLineSearchElement.RemoteLineSearchElementMatch[localMatches.size()]);
            RemoteLineSearchElement[] lineElements = RemoteLineSearchElement.createElements(indexFileLocation, matchesArray);
            IIndexFileLocation remoteIndexLocation = this.fConverter.fromInternalFormat(indexFileLocation.getURI().getPath());
            this.localLineSearchElementMatches.put(remoteIndexLocation, localMatches);
            this.localLineSearchElements.put(remoteIndexLocation, lineElements);
        }
    }

    private ICProject getPreferredProject() {
        ICProject preferred = null;
        if (this.projects != null && this.projects.length == 1) {
            preferred = this.projects[0];
        }
        return preferred;
    }

    public int getFlags() {
        return this.flags;
    }

    public abstract void runWithIndex(IIndex var1, IIndex var2, IIndexLocationConverter var3, IProgressMonitor var4) throws OperationCanceledException, CoreException, DOMException, InterruptedException;

    public IStatus runWithIndex(IWritableIndex[] indexList, IIndexLocationConverter converter, IProgressMonitor monitor) {
        int n;
        IStatus status = null;
        IWritableIndex searchScopeIndex = null;
        if (indexList.length == 1) {
            searchScopeIndex = indexList[0];
        } else if (indexList.length > 1) {
            HashSet<IWritableIndexFragment> fragments = new HashSet<IWritableIndexFragment>();
            IWritableIndex[] iWritableIndexArray = indexList;
            int n2 = indexList.length;
            n = 0;
            while (n < n2) {
                IWritableIndex projectIndex = iWritableIndexArray[n];
                if (projectIndex != null) {
                    IWritableIndexFragment fragment = projectIndex.getWritableFragment();
                    fragments.add(fragment);
                }
                ++n;
            }
            if (!fragments.isEmpty()) {
                searchScopeIndex = new CIndex(fragments.toArray(new IIndexFragment[fragments.size()]), fragments.size());
            }
        }
        if (searchScopeIndex != null) {
            IWritableIndex[] iWritableIndexArray = indexList;
            n = indexList.length;
            int n3 = 0;
            while (n3 < n) {
                IWritableIndex projectIndex = iWritableIndexArray[n3];
                try {
                    if (projectIndex != null) {
                        this.runWithIndex((IIndex)projectIndex, (IIndex)searchScopeIndex, converter, monitor);
                    }
                }
                catch (InterruptedException e1) {
                    status = status != null ? CCorePlugin.createStatus((String)(String.valueOf(status.getMessage()) + "::" + e1.getMessage())) : CCorePlugin.createStatus((String)e1.getMessage());
                }
                catch (CoreException e2) {
                    status = status != null ? CCorePlugin.createStatus((String)(String.valueOf(status.getMessage()) + "::" + e2.getMessage())) : CCorePlugin.createStatus((String)e2.getMessage());
                }
                catch (DOMException e3) {
                    status = status != null ? CCorePlugin.createStatus((String)(String.valueOf(status.getMessage()) + "::" + e3.getMessage())) : CCorePlugin.createStatus((String)e3.getMessage());
                }
                ++n3;
            }
        }
        if (status != null) {
            return status;
        }
        return Status.OK_STATUS;
    }

    public List<RemoteSearchMatch> getMatches() {
        return this.fMatches;
    }

    public void setMatches(List<RemoteSearchMatch> matches) {
        this.fMatches = matches;
    }

    public Map<IIndexFile, Set<RemoteLineSearchElement.RemoteLineSearchElementMatch>> getRemoteLineSearchElementMatchs() {
        return this.remoteLineSearchElementMatches;
    }

    public Map<IIndexFileLocation, Set<RemoteLineSearchElement.RemoteLineSearchElementMatch>> getLocalLineSearchElementMatches() {
        return this.localLineSearchElementMatches;
    }

    public Map<IIndexFileLocation, RemoteLineSearchElement[]> getLocalLineSearchElements() {
        return this.localLineSearchElements;
    }

    public Map<IIndexFile, RemoteLineSearchElement[]> getRemoteLineSearchElements() {
        return this.remoteLineSearchElements;
    }

    public ICProject[] getProjects() {
        return this.projects;
    }

    public String getScopeDescription() {
        StringBuilder buf = new StringBuilder();
        if (this.scope == null) {
            return "";
        }
        switch (this.scope.length) {
            case 0: {
                break;
            }
            case 1: {
                buf.append(this.scope[0].getElementName());
                break;
            }
            case 2: {
                buf.append(this.scope[0].getElementName());
                buf.append(", ");
                buf.append(this.scope[1].getElementName());
                break;
            }
            default: {
                buf.append(this.scope[0].getElementName());
                buf.append(", ");
                buf.append(this.scope[1].getElementName());
                buf.append(", ...");
            }
        }
        return buf.toString();
    }

    public void setfConverter(IIndexLocationConverter fConverter) {
        this.fConverter = fConverter;
    }
}

