/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdInitializerExpression;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;

public abstract class ASTTypeIdInitializerExpression
extends ASTNode
implements IASTTypeIdInitializerExpression {
    private IASTTypeId typeId;
    private IASTInitializer initializer;

    public ASTTypeIdInitializerExpression() {
    }

    public ASTTypeIdInitializerExpression(IASTTypeId t, IASTInitializer i) {
        this.setTypeId(t);
        this.setInitializer(i);
    }

    protected void initializeCopy(ASTTypeIdInitializerExpression copy, IASTNode.CopyStyle style) {
        copy.setTypeId(this.typeId == null ? null : this.typeId.copy(style));
        copy.setInitializer(this.initializer == null ? null : this.initializer.copy(style));
        copy.setOffsetAndLength(this);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
    }

    public IASTTypeId getTypeId() {
        return this.typeId;
    }

    public void setTypeId(IASTTypeId typeId) {
        this.assertNotFrozen();
        this.typeId = typeId;
        if (typeId != null) {
            typeId.setParent(this);
            typeId.setPropertyInParent(TYPE_ID);
        }
    }

    public IASTInitializer getInitializer() {
        return this.initializer;
    }

    public void setInitializer(IASTInitializer initializer) {
        this.assertNotFrozen();
        this.initializer = initializer;
        if (initializer != null) {
            initializer.setParent(this);
            initializer.setPropertyInParent(INITIALIZER);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.typeId != null && !this.typeId.accept(action)) {
            return false;
        }
        if (this.initializer != null && !this.initializer.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public final boolean isLValue() {
        return false;
    }

    public final IASTExpression.ValueCategory getValueCategory() {
        return IASTExpression.ValueCategory.PRVALUE;
    }
}

