/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.tau.papitest;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ptp.etfw.IBuildLaunchUtils;
import org.eclipse.ptp.etfw.internal.BuildLaunchUtils;
import org.eclipse.ptp.etfw.tau.Activator;
import org.eclipse.ptp.etfw.tau.messages.Messages;
import org.eclipse.ptp.etfw.tau.papiselect.PapiListSelectionDialog;
import org.eclipse.ptp.etfw.tau.papiselect.papic.EventTreeDialog;
import org.eclipse.ptp.etfw.tau.papitest.PAPISplash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.Workbench;

public class TestPAPI {
    private IWorkbenchWindow window = Workbench.getInstance().getActiveWorkbenchWindow();
    protected static final String papiLocationSelectionVar = "ID.of.PAPI.bin.directory.location";
    protected static final String papiCounterTypeVar = "ID.of.PAPI.counter.type.selected";

    public void run() {
        LabelProvider papilab = new LabelProvider();
        ArrayContentProvider paprov = new ArrayContentProvider();
        PAPISplash splash = new PAPISplash(this.window.getShell());
        splash.open();
        int papiCountType = Activator.getDefault().getPreferenceStore().getInt(papiCounterTypeVar);
        String papiLoc = Activator.getDefault().getPreferenceStore().getString(papiLocationSelectionVar);
        BuildLaunchUtils blt = new BuildLaunchUtils();
        IFileStore pdir = blt.getFile(papiLoc);
        if (!pdir.fetchInfo().exists() || !pdir.fetchInfo().isDirectory()) {
            return;
        }
        IFileStore pcxi = pdir.getChild("papi_xml_event_info");
        if (pcxi.fetchInfo().exists()) {
            EventTreeDialog treeD = new EventTreeDialog(this.window.getShell(), pdir, (IBuildLaunchUtils)blt);
            if (treeD.open() == 0) {
                this.showCounters(treeD.getCommands().toArray());
            }
            return;
        }
        PapiListSelectionDialog papidialog = new PapiListSelectionDialog(this.window.getShell(), pdir, (IBuildLaunchUtils)blt, (IStructuredContentProvider)paprov, (ILabelProvider)papilab, Messages.TestPAPI_SelectPapiCounters, papiCountType);
        papidialog.setTitle(Messages.TestPAPI_PapiCounters);
        papidialog.setHelpAvailable(false);
        if (papidialog.open() == 0) {
            Object[] selected = papidialog.getResult();
            this.showCounters(selected);
        }
    }

    private void showCounters(Object[] selected) {
        if (selected != null && selected.length > 0) {
            String counters = "";
            int i = 0;
            while (i < selected.length) {
                counters = String.valueOf(counters) + selected[i] + "\n";
                ++i;
            }
            MessageDialog.openInformation((Shell)this.window.getShell(), (String)Messages.TestPAPI_SelectedPapiCounters, (String)counters);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }
}

