/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.lexer.Terminal;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTEntityDeclNode;
import org.eclipse.photran.internal.core.parser.ASTListNode;
import org.eclipse.photran.internal.core.parser.ASTModuleNode;
import org.eclipse.photran.internal.core.parser.ASTSeparatedListNode;
import org.eclipse.photran.internal.core.parser.ASTUseStmtNode;
import org.eclipse.photran.internal.core.parser.GenericASTVisitor;
import org.eclipse.photran.internal.core.refactoring.Messages;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranEditorRefactoring;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranResourceRefactoring;
import org.eclipse.photran.internal.core.reindenter.Reindenter;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.vpg.IVPGNode;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGRefactoring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddOnlyToUseStmtRefactoring
extends FortranEditorRefactoring {
    private String moduleName = null;
    private IProject projectInEditor = null;
    private int numEntitiesInList = 0;
    private ASTUseStmtNode useNode = null;
    private List<IFile> filesContainingModule = null;
    private ArrayList<String> entitiesInProgram = new ArrayList();
    private List<Definition> moduleEntities = new ArrayList<Definition>();
    private ArrayList<String> entitiesInModule = new ArrayList();
    private List<Definition> existingOnlyList = new ArrayList<Definition>();
    private List<Definition> defsToAdd = new ArrayList<Definition>();
    private HashMap<Integer, String> entitiesToAdd = new HashMap();
    private Set<PhotranTokenRef> allReferences = null;

    public AddOnlyToUseStmtRefactoring() {
    }

    public AddOnlyToUseStmtRefactoring(IFile file, ITextSelection selection) {
        this.initialize(file, selection);
    }

    public ArrayList<String> getModuleEntityList() {
        return this.entitiesInModule;
    }

    public void addToOnlyList(String name) {
        if (!this.entitiesToAdd.containsValue(name)) {
            this.entitiesToAdd.put(this.numEntitiesInList, PhotranVPG.canonicalizeIdentifier(name));
            int i = 0;
            while (i < this.moduleEntities.size()) {
                if (this.entitiesToAdd.get(this.numEntitiesInList).equals(this.moduleEntities.get(i).getCanonicalizedName())) {
                    this.defsToAdd.add(this.moduleEntities.get(i));
                }
                ++i;
            }
            ++this.numEntitiesInList;
        }
    }

    public void removeFromOnlyList(String name) {
        int i = 0;
        while (i < this.entitiesToAdd.size()) {
            if (name.equalsIgnoreCase(this.entitiesToAdd.get(i))) {
                int j = 0;
                while (j < this.moduleEntities.size()) {
                    if (this.entitiesToAdd.get(i).equalsIgnoreCase(this.moduleEntities.get(j).getCanonicalizedName())) {
                        this.defsToAdd.remove(this.moduleEntities.get(j));
                        this.existingOnlyList.remove(this.moduleEntities.get(j));
                    }
                    ++j;
                }
                this.entitiesToAdd.remove(i);
                --this.numEntitiesInList;
                return;
            }
            ++i;
        }
    }

    public HashMap<Integer, String> getNewOnlyList() {
        return this.entitiesToAdd;
    }

    public int getNumEntitiesInModule() {
        return this.moduleEntities.size();
    }

    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        this.moduleName = this.selectedRegionInEditor.getText();
        if (this.moduleName == null || this.moduleName.equals("")) {
            this.fail(Messages.AddOnlyToUseStmtRefactoring_NoModuleNameSelected);
        }
        this.findUseStmtNode();
        this.checkIfModuleExistsInProject();
        this.getModuleDeclaredEntities();
        this.getProgramDeclaredEntities();
        this.readExistingOnlyList();
    }

    private void findUseStmtNode() throws VPGRefactoring.PreconditionFailure {
        Token token = this.findEnclosingToken();
        if (token == null) {
            this.fail(Messages.AddOnlyToUseStmtRefactoring_SelectModuleName);
        }
        this.useNode = token.findNearestAncestor(ASTUseStmtNode.class);
        if (this.useNode == null) {
            this.fail(Messages.AddOnlyToUseStmtRefactoring_SelectModuleName);
        }
    }

    private void checkIfModuleExistsInProject() throws VPGRefactoring.PreconditionFailure {
        this.projectInEditor = this.fileInEditor.getProject();
        this.filesContainingModule = ((PhotranVPG)this.vpg).findFilesThatExportModule(this.moduleName);
        if (this.filesContainingModule.isEmpty() || this.filesContainingModule == null) {
            this.fail(Messages.bind((String)Messages.AddOnlyToUseStmtRefactoring_NoFilesContainModule, (Object)this.moduleName));
        } else if (this.filesContainingModule.size() > 1) {
            this.filterFileList();
        }
        if (this.filesContainingModule.isEmpty() || this.filesContainingModule == null) {
            this.fail(Messages.bind((String)Messages.AddOnlyToUseStmtRefactoring_NoFilesContainModule, (Object)this.moduleName));
        }
        if (this.filesContainingModule.size() > 1) {
            this.fail(Messages.bind((String)Messages.AddOnlyToUseStmtRefactoring_MultipleDefinitionsOfModule, (Object)this.moduleName));
        }
    }

    private void filterFileList() throws VPGRefactoring.PreconditionFailure {
        if (this.projectInEditor == null) {
            this.fail(Messages.AddOnlyToUseStmtRefactoring_ProjectDoesNotExist);
        }
        int i = 0;
        while (i < this.filesContainingModule.size()) {
            if (this.filesContainingModule.get(i) == null || this.filesContainingModule.get(i).getProject() != this.projectInEditor) {
                this.filesContainingModule.remove(i);
                continue;
            }
            ++i;
        }
    }

    private Token findEnclosingToken() throws VPGRefactoring.PreconditionFailure {
        Token selectedToken = AddOnlyToUseStmtRefactoring.findEnclosingToken(this.astOfFileInEditor, this.selectedRegionInEditor);
        if (selectedToken == null) {
            this.fail(Messages.AddOnlyToUseStmtRefactoring_PleaseSelectModuleName);
        }
        return selectedToken;
    }

    private void getProgramDeclaredEntities() throws VPGRefactoring.PreconditionFailure {
        IFortranAST ast = (IFortranAST)((PhotranVPG)this.vpg).acquirePermanentAST(this.fileInEditor);
        if (ast == null) {
            return;
        }
        DeclarationVisitor visitor = new DeclarationVisitor();
        ast.accept(visitor);
    }

    private void getModuleDeclaredEntities() throws VPGRefactoring.PreconditionFailure {
        ASTModuleNode moduleNode;
        Token moduleToken;
        PhotranTokenRef moduleTokenRef = ((PhotranVPG)this.vpg).getModuleTokenRef(this.moduleName);
        if (moduleTokenRef == null) {
            this.fail(Messages.bind((String)Messages.AddOnlyToUseStmtRefactoring_NoModuleNamed, (Object)this.moduleName));
        }
        if ((moduleToken = moduleTokenRef.findTokenOrReturnNull()) == null) {
            this.fail(Messages.AddOnlyToUseStmtRefactoring_ModuleTokenNotFound);
        }
        if ((moduleNode = moduleToken.findNearestAncestor(ASTModuleNode.class)) == null) {
            this.fail(Messages.AddOnlyToUseStmtRefactoring_ModuleNodeNodeFound);
        }
        this.moduleEntities = moduleNode.getAllPublicDefinitions();
        if (this.moduleEntities.isEmpty()) {
            this.fail(Messages.AddOnlyToUseStmtRefactoring_NoDeclarationsInModule);
        } else {
            int i = 0;
            while (i < this.moduleEntities.size()) {
                this.entitiesInModule.add(this.moduleEntities.get(i).getCanonicalizedName());
                ++i;
            }
        }
    }

    private void readExistingOnlyList() {
        IFortranAST ast;
        ASTSeparatedListNode existingOnlys = (ASTSeparatedListNode)this.useNode.getOnlyList();
        if (existingOnlys != null) {
            int i = 0;
            while (i < existingOnlys.size()) {
                this.entitiesToAdd.put(i, PhotranVPG.canonicalizeIdentifier(existingOnlys.get(i).toString().trim()));
                ++i;
            }
            this.numEntitiesInList = this.entitiesToAdd.size();
            i = 0;
            while (i < this.moduleEntities.size()) {
                if (this.entitiesToAdd.containsValue(this.moduleEntities.get(i).getCanonicalizedName())) {
                    this.existingOnlyList.add(this.moduleEntities.get(i));
                }
                ++i;
            }
        }
        if ((ast = (IFortranAST)((PhotranVPG)this.vpg).acquirePermanentAST(this.fileInEditor)) == null) {
            return;
        }
        TokenVisitor visitor = new TokenVisitor();
        ast.accept(visitor);
    }

    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
    }

    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        pm.beginTask(Messages.AddOnlyToUseStmtRefactoring_Analyzing, -1);
        if (this.useNode == null) {
            this.fail(Messages.AddOnlyToUseStmtRefactoring_ModuleNameInUseStmtNotSelected);
        }
        pm.subTask(String.valueOf(Messages.AddOnlyToUseStmtRefactoring_Parsing) + this.fileInEditor.getName());
        IFortranAST ast = (IFortranAST)((PhotranVPG)this.vpg).acquirePermanentAST(this.fileInEditor);
        if (ast == null) {
            return;
        }
        pm.subTask(Messages.AddOnlyToUseStmtRefactoring_CheckingForConflicts);
        this.checkConflictingBindings(ast, pm, status);
        pm.subTask(Messages.AddOnlyToUseStmtRefactoring_InsertingUseStmt);
        this.createAndInsertUseStmt(ast);
        pm.subTask(Messages.AddOnlyToUseStmtRefactoring_CreatingChangeObject);
        this.addChangeFromModifiedAST(this.fileInEditor, pm);
        ((PhotranVPG)this.vpg).releaseAST(this.fileInEditor);
        pm.done();
    }

    private void checkConflictingBindings(IFortranAST ast, IProgressMonitor pm, RefactoringStatus status) {
        pm.subTask(Messages.AddOnlyToUseStmtRefactoring_FindingReferences);
        this.allReferences = this.findModuleEntityRefs(ast);
        for (Definition def : this.defsToAdd) {
            AddOnlyToUseStmtRefactoring.checkForConflictingBindings(pm, (FortranResourceRefactoring.IConflictingBindingCallback)new ConflictingBindingErrorHandler(status), def, this.allReferences, def.getCanonicalizedName());
        }
    }

    private Set<PhotranTokenRef> findModuleEntityRefs(IFortranAST ast) {
        final HashSet<PhotranTokenRef> result = new HashSet<PhotranTokenRef>();
        final Collection<String> defNames = this.entitiesToAdd.values();
        ast.accept(new GenericASTVisitor(){

            public void visitToken(Token token) {
                if (token.getTerminal() == Terminal.T_IDENT) {
                    for (Definition def : token.resolveBinding()) {
                        if (!defNames.contains(def.getCanonicalizedName())) continue;
                        result.addAll(def.findAllReferences(true));
                    }
                }
            }
        });
        return result;
    }

    private void removeOriginalModuleRefs() {
        if (this.allReferences != null && this.allReferences.size() > 0) {
            HashSet<PhotranTokenRef> referencesToRemove = new HashSet<PhotranTokenRef>();
            for (PhotranTokenRef ref : this.allReferences) {
                IFile file = ref.getFile();
                IProject project = file.getProject();
                if (this.projectInEditor.equals((Object)project)) continue;
                referencesToRemove.add(ref);
            }
            this.allReferences.removeAll(referencesToRemove);
        }
    }

    private void createAndInsertUseStmt(IFortranAST ast) {
        String newOnlyAdditions = " ";
        TreeSet<String> varNames = new TreeSet<String>(this.entitiesToAdd.values());
        Iterator iter = varNames.iterator();
        int counter = 0;
        while (iter.hasNext()) {
            newOnlyAdditions = String.valueOf(newOnlyAdditions) + (String)iter.next();
            if (counter < varNames.size() - 1) {
                newOnlyAdditions = String.valueOf(newOnlyAdditions) + ", ";
            }
            ++counter;
        }
        ASTUseStmtNode newStmtNode = this.entitiesToAdd.size() > 0 ? (ASTUseStmtNode)AddOnlyToUseStmtRefactoring.parseLiteralStatement("use " + this.useNode.getName().getText() + ", only:" + newOnlyAdditions + System.getProperty("line.separator")) : (ASTUseStmtNode)AddOnlyToUseStmtRefactoring.parseLiteralStatement("use " + this.useNode.getName().getText() + System.getProperty("line.separator"));
        ASTListNode body = (ASTListNode)this.useNode.getParent();
        body.replaceChild(this.useNode, newStmtNode);
        Reindenter.reindent(newStmtNode, ast);
    }

    public String getName() {
        return Messages.AddOnlyToUseStmtRefactoring_Name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ConflictingBindingErrorHandler
    implements FortranResourceRefactoring.IConflictingBindingCallback {
        private final RefactoringStatus status;

        private ConflictingBindingErrorHandler(RefactoringStatus status) {
            this.status = status;
        }

        @Override
        public void addConflictError(List<FortranResourceRefactoring.Conflict> conflictingDef) {
            for (FortranResourceRefactoring.Conflict conflict : conflictingDef) {
                IFile file = conflict.tokenRef.getFile();
                if (AddOnlyToUseStmtRefactoring.this.filesContainingModule.contains(file) || !file.getProject().equals((Object)AddOnlyToUseStmtRefactoring.this.projectInEditor)) continue;
                String msg = Messages.bind((String)Messages.AddOnlyToUseStmtRefactoring_NameConflicts, (Object)conflict.name, (Object)((PhotranVPG)AddOnlyToUseStmtRefactoring.this.vpg).getDefinitionFor(conflict.tokenRef));
                RefactoringStatusContext context = AddOnlyToUseStmtRefactoring.this.createContext((IVPGNode)conflict.tokenRef);
                this.status.addError(msg, context);
            }
        }

        @Override
        public void addConflictWarning(List<FortranResourceRefactoring.Conflict> conflictingDef) {
            for (FortranResourceRefactoring.Conflict conflict : conflictingDef) {
                IFile file = conflict.tokenRef.getFile();
                if (AddOnlyToUseStmtRefactoring.this.filesContainingModule.contains(file) || !file.getProject().equals((Object)AddOnlyToUseStmtRefactoring.this.projectInEditor)) continue;
                String msg = Messages.bind((String)Messages.AddOnlyToUseStmtRefactoring_NameMightConflict, (Object)conflict.name);
                RefactoringStatusContext context = AddOnlyToUseStmtRefactoring.this.createContext((IVPGNode)conflict.tokenRef);
                this.status.addWarning(msg, context);
            }
        }

        @Override
        public void addReferenceWillChangeError(String newName, Token reference) {
            if (AddOnlyToUseStmtRefactoring.this.entitiesInProgram.contains(newName)) {
                this.status.addError(Messages.bind((String)Messages.AddOnlyToUseStmtRefactoring_AddingWouldChangeMeaningOf, (Object[])new Object[]{newName, reference.getText(), reference.getLine(), reference.getTokenRef().getFilename()}), AddOnlyToUseStmtRefactoring.this.createContext(reference));
            }
        }
    }

    private final class DeclarationVisitor
    extends GenericASTVisitor {
        private DeclarationVisitor() {
        }

        public void visitASTEntityDeclNode(ASTEntityDeclNode node) {
            String name = node.getObjectName().getObjectName().getText();
            if (!AddOnlyToUseStmtRefactoring.this.entitiesInProgram.contains(name)) {
                AddOnlyToUseStmtRefactoring.this.entitiesInProgram.add(name);
            }
        }
    }

    private final class TokenVisitor
    extends GenericASTVisitor {
        private TokenVisitor() {
        }

        public void visitToken(Token node) {
            String name = node.getText();
            if (AddOnlyToUseStmtRefactoring.this.entitiesInModule.contains(name)) {
                AddOnlyToUseStmtRefactoring.this.addToOnlyList(name);
            }
        }
    }
}

