/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.utils.ui.swt;

import java.io.File;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.ptp.utils.ui.swt.DirectoryButtonSelectionListener;
import org.eclipse.ptp.utils.ui.swt.FileAndWorkspaceMold;
import org.eclipse.ptp.utils.ui.swt.FileButtonSelectionListener;
import org.eclipse.ptp.utils.ui.swt.FilesystemToTreeMapper;
import org.eclipse.ptp.utils.ui.swt.GenericControlGroup;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class FileAndWorkspaceGroup
extends GenericControlGroup {
    FileAndWorkspaceMold mold;
    Composite container;
    Button findInWorkspace;
    Text path;
    FilesystemTreeNode pai = new FilesystemTreeNode(new Integer(1));
    FilesystemTreeNode filho1 = new FilesystemTreeNode(new String("filho1"));
    FilesystemTreeNode filho2 = new FilesystemTreeNode(new String("filho2"));

    private FileAndWorkspaceGroup(Composite parent, FileAndWorkspaceMold mold) {
        super(parent, mold);
        this.mold = mold;
        this.findInWorkspace.setText(mold.workspaceLabel);
        this.getButton().setText(mold.buttonLabel);
        this.pai.setChildren(new TreeNode[]{this.filho1, this.filho2});
        this.generateButtonsHandler(mold);
    }

    private void generateButtonsHandler(FileAndWorkspaceMold mold2) {
        SelectionAdapter browseSelectionListener = (this.mold.bitmask & FileAndWorkspaceMold.DIRECTORY_SELECTION) != 0 ? new DirectoryButtonSelectionListener(this.path, this.mold.browseWindowLabel, this.mold.browseWindowMessage) : new FileButtonSelectionListener(this.path, this.mold.browseWindowLabel);
        this.getButton().addSelectionListener((SelectionListener)browseSelectionListener);
        this.findInWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSelectionDialog treeSelect = new ElementTreeSelectionDialog(FileAndWorkspaceGroup.this.getShell(), (ILabelProvider)new LabelProvider(), (ITreeContentProvider)new TreeNodeContentProvider());
                File workspace = new File("/home/richardm/tmp");
                FilesystemToTreeMapper treeMapper = new FilesystemToTreeMapper();
                treeSelect.setInput((Object)new TreeNode[]{treeMapper.filesystemTreeFactory(workspace)});
                treeSelect.open();
                TreeNode selNode = (TreeNode)treeSelect.getFirstResult();
                if (selNode != null) {
                    FileAndWorkspaceGroup.this.path.setText(selNode.getValue().toString());
                }
            }
        });
    }

    protected Control createCustomControl(int bitmask, GridData gridData) {
        this.container = new Composite((Composite)this, 0);
        GridLayout containerLayout = new GridLayout();
        containerLayout.marginHeight = 0;
        containerLayout.marginWidth = 0;
        containerLayout.horizontalSpacing = 5;
        containerLayout.verticalSpacing = 0;
        containerLayout.numColumns = 2;
        this.container.setLayout((Layout)containerLayout);
        gridData.horizontalAlignment = 4;
        GridData pathGD = new GridData(4, 4, true, false, 1, 1);
        GridData workplaceGD = GridDataFactory.copyData((GridData)pathGD);
        workplaceGD.grabExcessHorizontalSpace = false;
        this.path = new Text(this.container, 2052);
        this.path.setLayoutData((Object)pathGD);
        this.findInWorkspace = new Button(this.container, 8);
        this.findInWorkspace.setLayoutData((Object)workplaceGD);
        return this.container;
    }

    public void addModifyListener(ModifyListener listener) {
        this.path.addModifyListener(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.path.removeModifyListener(listener);
    }

    public void setString(String string) {
        this.path.setText(string);
    }

    public String getString() {
        return this.path.getText();
    }

    public Button getWorkspaceButton() {
        return this.findInWorkspace;
    }

    public Button getBrowseButton() {
        return this.getButton();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.path.setEnabled(enabled);
        this.findInWorkspace.setEnabled(enabled);
    }

    public class FilesystemTreeNode
    extends TreeNode {
        public String toString() {
            if (this.value != null) {
                return this.value.toString();
            }
            return "null";
        }

        public FilesystemTreeNode(Object value) {
            super(value);
        }
    }
}

