/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ui.preferences;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ptp.core.Preferences;
import org.eclipse.ptp.rm.ui.messages.Messages;
import org.eclipse.ptp.rm.ui.preferences.AbstractPreferencePage;
import org.eclipse.ptp.rm.ui.preferences.PreferenceDataSource;
import org.eclipse.ptp.rm.ui.preferences.PreferenceWidgetListener;
import org.eclipse.ptp.rm.ui.utils.DataSource;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public abstract class AbstractToolsPreferencePage
extends AbstractPreferencePage
implements IWorkbenchPreferencePage {
    public static final String EMPTY_STRING = "";
    protected Text launchCmdText = null;
    protected Text debugCmdText = null;
    protected Text discoverCmdText = null;
    protected Text continuousMonitorCmdText = null;
    protected Text periodicMonitorCmdText = null;
    protected Spinner periodicMonitorTimeSpinner = null;
    protected Text remoteInstallPathText = null;
    private int fCapabilities = 0;
    private final String fQualifier;

    public AbstractToolsPreferencePage(String qualifier, int capabilities) {
        this.fCapabilities = capabilities;
        this.fQualifier = qualifier;
    }

    public AbstractToolsPreferencePage(String qualifier, int capabilities, String title) {
        super(title);
        this.fCapabilities = capabilities;
        this.fQualifier = qualifier;
    }

    public AbstractToolsPreferencePage(String qualifier, int capabilities, String title, ImageDescriptor image) {
        super(title, image);
        this.fCapabilities = capabilities;
        this.fQualifier = qualifier;
    }

    public void init(IWorkbench workbench) {
    }

    protected PreferenceDataSource createDataSource() {
        return new DataSource(this);
    }

    protected PreferenceWidgetListener createListener() {
        return new WidgetListener();
    }

    protected Composite doCreateContents(Composite parent) {
        Label label;
        Composite contents = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        contents.setLayout((Layout)layout);
        if ((this.fCapabilities & 1) != 0) {
            label = new Label(contents, 0);
            label.setText(Messages.AbstractToolsPreferencePage_Label_LaunchCommand);
            this.launchCmdText = new Text(contents, 2052);
            this.launchCmdText.setLayoutData((Object)new GridData(4, -1, true, false, 3, 1));
            this.launchCmdText.addModifyListener((ModifyListener)this.getListener());
            label = new Label(contents, 0);
            label.setText(Messages.AbstractToolsPreferencePage_Label_DebugCommand);
            this.debugCmdText = new Text(contents, 2052);
            this.debugCmdText.setLayoutData((Object)new GridData(4, -1, true, false, 3, 1));
            this.debugCmdText.addModifyListener((ModifyListener)this.getListener());
        }
        if ((this.fCapabilities & 2) != 0) {
            label = new Label(contents, 0);
            label.setText(Messages.AbstractToolsPreferencePage_Label_DiscoverCommand);
            this.discoverCmdText = new Text(contents, 2052);
            this.discoverCmdText.setLayoutData((Object)new GridData(4, -1, true, false, 3, 1));
            this.discoverCmdText.addModifyListener((ModifyListener)this.getListener());
        }
        if ((this.fCapabilities & 4) != 0) {
            label = new Label(contents, 0);
            label.setText(Messages.AbstractToolsPreferencePage_Label_PeriodicMonitorCommand);
            this.periodicMonitorCmdText = new Text(contents, 2052);
            this.periodicMonitorCmdText.setLayoutData((Object)new GridData(4, -1, true, false, 1, 1));
            this.periodicMonitorCmdText.addModifyListener((ModifyListener)this.getListener());
            label = new Label(contents, 0);
            label.setText(Messages.AbstractToolsPreferencePage_Label_PeriodicMonitorCommandPeriod);
            this.periodicMonitorTimeSpinner = new Spinner(contents, 2052);
            this.periodicMonitorCmdText.setLayoutData((Object)new GridData(4, -1, false, false, 1, 1));
            this.periodicMonitorTimeSpinner.addModifyListener((ModifyListener)this.getListener());
        }
        if ((this.fCapabilities & 8) != 0) {
            label = new Label(contents, 0);
            label.setText(Messages.AbstractToolsPreferencePage_Label_ContinuosMonitorCommand);
            this.continuousMonitorCmdText = new Text(contents, 2052);
            this.continuousMonitorCmdText.setLayoutData((Object)new GridData(4, -1, true, false, 3, 1));
            this.continuousMonitorCmdText.addModifyListener((ModifyListener)this.getListener());
        }
        if ((this.fCapabilities & 0x10) != 0) {
            label = new Label(contents, 0);
            label.setText(Messages.AbstractToolsPreferencePage_Label_InstallationPath);
            this.remoteInstallPathText = new Text(contents, 2052);
            GridData gd = new GridData(768);
            gd.horizontalSpan = 3;
            gd.widthHint = 60;
            this.remoteInstallPathText.setLayoutData((Object)gd);
            this.remoteInstallPathText.addModifyListener((ModifyListener)this.getListener());
        }
        return contents;
    }

    protected String getQualifier() {
        return this.fQualifier;
    }

    protected void updateControls() {
    }

    class DataSource
    extends PreferenceDataSource {
        String launchCmd;
        String debugCmd;
        String discoverCmd;
        String periodicMonitorCmd;
        int periodicMonitorTime;
        String continuousMonitorCmd;
        String remoteInstallPath;

        DataSource(AbstractPreferencePage page) {
            super(page);
            this.launchCmd = null;
            this.debugCmd = null;
            this.discoverCmd = null;
            this.periodicMonitorCmd = null;
            this.periodicMonitorTime = 0;
            this.continuousMonitorCmd = null;
            this.remoteInstallPath = null;
        }

        protected void copyFromFields() throws DataSource.ValidationException {
            if (AbstractToolsPreferencePage.this.launchCmdText != null) {
                this.launchCmd = this.extractText(AbstractToolsPreferencePage.this.launchCmdText);
            }
            if (AbstractToolsPreferencePage.this.debugCmdText != null) {
                this.debugCmd = this.extractText(AbstractToolsPreferencePage.this.debugCmdText);
            }
            if (AbstractToolsPreferencePage.this.discoverCmdText != null) {
                this.discoverCmd = this.extractText(AbstractToolsPreferencePage.this.discoverCmdText);
            }
            if (AbstractToolsPreferencePage.this.periodicMonitorCmdText != null) {
                this.periodicMonitorCmd = this.extractText(AbstractToolsPreferencePage.this.periodicMonitorCmdText);
            }
            if (AbstractToolsPreferencePage.this.periodicMonitorTimeSpinner != null) {
                this.periodicMonitorTime = AbstractToolsPreferencePage.this.periodicMonitorTimeSpinner.getSelection();
            }
            if (AbstractToolsPreferencePage.this.continuousMonitorCmdText != null) {
                this.continuousMonitorCmd = this.extractText(AbstractToolsPreferencePage.this.continuousMonitorCmdText);
            }
            if (AbstractToolsPreferencePage.this.remoteInstallPathText != null) {
                this.remoteInstallPath = this.extractText(AbstractToolsPreferencePage.this.remoteInstallPathText);
            }
        }

        protected void copyToFields() {
            if (AbstractToolsPreferencePage.this.launchCmdText != null) {
                this.applyText(AbstractToolsPreferencePage.this.launchCmdText, this.launchCmd);
            }
            if (AbstractToolsPreferencePage.this.debugCmdText != null) {
                this.applyText(AbstractToolsPreferencePage.this.debugCmdText, this.debugCmd);
            }
            if (AbstractToolsPreferencePage.this.discoverCmdText != null) {
                this.applyText(AbstractToolsPreferencePage.this.discoverCmdText, this.discoverCmd);
            }
            if (AbstractToolsPreferencePage.this.periodicMonitorCmdText != null) {
                this.applyText(AbstractToolsPreferencePage.this.periodicMonitorCmdText, this.periodicMonitorCmd);
            }
            if (AbstractToolsPreferencePage.this.periodicMonitorTimeSpinner != null) {
                AbstractToolsPreferencePage.this.periodicMonitorTimeSpinner.setSelection(this.periodicMonitorTime);
            }
            if (AbstractToolsPreferencePage.this.continuousMonitorCmdText != null) {
                this.applyText(AbstractToolsPreferencePage.this.continuousMonitorCmdText, this.continuousMonitorCmd);
            }
            if (AbstractToolsPreferencePage.this.remoteInstallPathText != null) {
                this.applyText(AbstractToolsPreferencePage.this.remoteInstallPathText, this.remoteInstallPath);
            }
        }

        protected void copyToStorage() {
            if (AbstractToolsPreferencePage.this.launchCmdText != null) {
                Preferences.setString((String)AbstractToolsPreferencePage.this.getQualifier(), (String)"launchCmd", (String)this.toPreference(this.launchCmd));
            }
            if (AbstractToolsPreferencePage.this.debugCmdText != null) {
                Preferences.setString((String)AbstractToolsPreferencePage.this.getQualifier(), (String)"debugCmd", (String)this.toPreference(this.debugCmd));
            }
            if (AbstractToolsPreferencePage.this.discoverCmdText != null) {
                Preferences.setString((String)AbstractToolsPreferencePage.this.getQualifier(), (String)"discoverCmd", (String)this.toPreference(this.discoverCmd));
            }
            if (AbstractToolsPreferencePage.this.periodicMonitorCmdText != null) {
                Preferences.setString((String)AbstractToolsPreferencePage.this.getQualifier(), (String)"periodicMonitorCmd", (String)this.toPreference(this.periodicMonitorCmd));
            }
            if (AbstractToolsPreferencePage.this.periodicMonitorTimeSpinner != null) {
                Preferences.setInt((String)AbstractToolsPreferencePage.this.getQualifier(), (String)"periodicMonitorTime", (int)this.periodicMonitorTime);
            }
            if (AbstractToolsPreferencePage.this.continuousMonitorCmdText != null) {
                Preferences.setString((String)AbstractToolsPreferencePage.this.getQualifier(), (String)"continuousMonitorCmd", (String)this.toPreference(this.continuousMonitorCmd));
            }
            if (AbstractToolsPreferencePage.this.remoteInstallPathText != null) {
                Preferences.setString((String)AbstractToolsPreferencePage.this.getQualifier(), (String)"remoteInstallPath", (String)this.toPreference(this.remoteInstallPath));
            }
            AbstractToolsPreferencePage.this.savePreferences();
        }

        protected void loadDefault() {
            if (AbstractToolsPreferencePage.this.launchCmdText != null) {
                this.launchCmd = this.fromPreference(Preferences.getDefaultString((String)AbstractToolsPreferencePage.this.getQualifier(), (String)"launchCmd", (String)AbstractToolsPreferencePage.EMPTY_STRING));
            }
            if (AbstractToolsPreferencePage.this.debugCmdText != null) {
                this.debugCmd = this.fromPreference(Preferences.getDefaultString((String)AbstractToolsPreferencePage.this.getQualifier(), (String)"debugCmd", (String)AbstractToolsPreferencePage.EMPTY_STRING));
            }
            if (AbstractToolsPreferencePage.this.discoverCmdText != null) {
                this.discoverCmd = this.fromPreference(Preferences.getDefaultString((String)AbstractToolsPreferencePage.this.getQualifier(), (String)"discoverCmd", (String)AbstractToolsPreferencePage.EMPTY_STRING));
            }
            if (AbstractToolsPreferencePage.this.periodicMonitorCmdText != null) {
                this.periodicMonitorCmd = this.fromPreference(Preferences.getDefaultString((String)AbstractToolsPreferencePage.this.getQualifier(), (String)"periodicMonitorCmd", (String)AbstractToolsPreferencePage.EMPTY_STRING));
            }
            if (AbstractToolsPreferencePage.this.periodicMonitorTimeSpinner != null) {
                this.periodicMonitorTime = Preferences.getDefaultInt((String)AbstractToolsPreferencePage.this.getQualifier(), (String)"periodicMonitorTime", (int)0);
            }
            if (AbstractToolsPreferencePage.this.continuousMonitorCmdText != null) {
                this.continuousMonitorCmd = this.fromPreference(Preferences.getDefaultString((String)AbstractToolsPreferencePage.this.getQualifier(), (String)"continuousMonitorCmd", (String)AbstractToolsPreferencePage.EMPTY_STRING));
            }
            if (AbstractToolsPreferencePage.this.remoteInstallPathText != null) {
                this.remoteInstallPath = this.fromPreference(Preferences.getDefaultString((String)AbstractToolsPreferencePage.this.getQualifier(), (String)"remoteInstallPath", (String)AbstractToolsPreferencePage.EMPTY_STRING));
            }
        }

        protected void loadFromStorage() {
            if (AbstractToolsPreferencePage.this.launchCmdText != null) {
                this.launchCmd = this.fromPreference(Preferences.getString((String)AbstractToolsPreferencePage.this.getQualifier(), (String)"launchCmd"));
            }
            if (AbstractToolsPreferencePage.this.debugCmdText != null) {
                this.debugCmd = this.fromPreference(Preferences.getString((String)AbstractToolsPreferencePage.this.getQualifier(), (String)"debugCmd"));
            }
            if (AbstractToolsPreferencePage.this.discoverCmdText != null) {
                this.discoverCmd = this.fromPreference(Preferences.getString((String)AbstractToolsPreferencePage.this.getQualifier(), (String)"discoverCmd"));
            }
            if (AbstractToolsPreferencePage.this.periodicMonitorCmdText != null) {
                this.periodicMonitorCmd = this.fromPreference(Preferences.getString((String)AbstractToolsPreferencePage.this.getQualifier(), (String)"periodicMonitorCmd"));
            }
            if (AbstractToolsPreferencePage.this.periodicMonitorTimeSpinner != null) {
                this.periodicMonitorTime = Preferences.getInt((String)AbstractToolsPreferencePage.this.getQualifier(), (String)"periodicMonitorTime");
            }
            if (AbstractToolsPreferencePage.this.continuousMonitorCmdText != null) {
                this.continuousMonitorCmd = this.fromPreference(Preferences.getString((String)AbstractToolsPreferencePage.this.getQualifier(), (String)"continuousMonitorCmd"));
            }
            if (AbstractToolsPreferencePage.this.remoteInstallPathText != null) {
                this.remoteInstallPath = this.fromPreference(Preferences.getString((String)AbstractToolsPreferencePage.this.getQualifier(), (String)"remoteInstallPath"));
            }
        }

        protected void validateLocal() throws DataSource.ValidationException {
            if (AbstractToolsPreferencePage.this.launchCmdText != null && this.launchCmd == null) {
                throw new DataSource.ValidationException(Messages.AbstractToolsPreferencePage_Validation_MissingLaunchCommand);
            }
            if (AbstractToolsPreferencePage.this.debugCmdText != null && this.debugCmd == null) {
                throw new DataSource.ValidationException(Messages.AbstractToolsPreferencePage_Validation_MissingMissingDebugCommand);
            }
            if (AbstractToolsPreferencePage.this.discoverCmdText != null && this.discoverCmd == null) {
                throw new DataSource.ValidationException(Messages.AbstractToolsPreferencePage_Validation_MissingDiscoverCommand);
            }
            if (AbstractToolsPreferencePage.this.periodicMonitorCmdText != null && AbstractToolsPreferencePage.this.periodicMonitorTimeSpinner != null && this.periodicMonitorTime < 1) {
                throw new DataSource.ValidationException(Messages.AbstractToolsPreferencePage_Validation_InvalidPeriodicMonitorCommandTimeRange);
            }
        }
    }

    class WidgetListener
    extends PreferenceWidgetListener
    implements ModifyListener {
        WidgetListener() {
        }

        public void doModifyText(ModifyEvent evt) {
            Object source = evt.getSource();
            if (source == AbstractToolsPreferencePage.this.launchCmdText || source == AbstractToolsPreferencePage.this.debugCmdText || source == AbstractToolsPreferencePage.this.discoverCmdText || source == AbstractToolsPreferencePage.this.periodicMonitorCmdText || source == AbstractToolsPreferencePage.this.continuousMonitorCmdText || source == AbstractToolsPreferencePage.this.periodicMonitorTimeSpinner || source == AbstractToolsPreferencePage.this.remoteInstallPathText) {
                AbstractToolsPreferencePage.this.resetErrorMessages();
                AbstractToolsPreferencePage.this.getDataSource().justValidate();
            } else assert (false);
        }
    }
}

