/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.tau.papiselect;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Vector;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.ptp.etfw.IBuildLaunchUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapiSelect {
    public static final int PRESET = 0;
    public static final int NATIVE = 1;
    private LinkedHashSet<String> avCounters = null;
    private Vector<String> counterNames = new Vector(256);
    private Vector<String> counterDefs = new Vector(256);
    private IFileStore location = null;
    private int countType = 0;
    private IBuildLaunchUtils blt = null;

    public PapiSelect(IFileStore papiLocation, IBuildLaunchUtils blt, int papiCountType) {
        this.location = papiLocation;
        this.blt = blt;
        if (papiCountType == 0) {
            this.findPresetAvail();
        } else {
            this.findNativeAvail();
            this.countType = 1;
        }
    }

    public LinkedHashSet<Object> getGrey(Object[] checked, Object[] greyed) {
        LinkedHashSet<Object> active = new LinkedHashSet<Object>();
        LinkedHashSet<Object> greyset = new LinkedHashSet<Object>();
        LinkedHashSet<String> notgrey = new LinkedHashSet<String>(this.avCounters);
        if (checked.length > 0) {
            active.addAll(Arrays.asList(checked));
        }
        if (greyed != null && greyed.length > 0) {
            active.removeAll(Arrays.asList(greyed));
        }
        notgrey.removeAll(active);
        if (greyed != null && greyed.length > 0) {
            notgrey.removeAll(Arrays.asList(greyed));
        }
        greyset.addAll(this.getRejects(active));
        if (greyed != null && greyed.length > 0) {
            greyset.add(Arrays.asList(greyed));
        }
        return greyset;
    }

    public LinkedHashSet<String> getAvail() {
        return this.avCounters;
    }

    public Vector<String> getCounterDefs() {
        return this.counterDefs;
    }

    public Vector<String> getCounterNames() {
        return this.counterNames;
    }

    private void findPresetAvail() {
        IFileStore papi_avail = this.location.getChild("papi_avail");
        String s = null;
        LinkedHashSet<String> avail = new LinkedHashSet<String>();
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(papi_avail.toURI().getPath());
        String holdcounter = null;
        try {
            byte[] xbytes = this.blt.runToolGetOutput(commands, null, null);
            if (xbytes == null) {
                return;
            }
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(xbytes)));
            while ((s = stdInput.readLine()) != null) {
                if (s.indexOf("PAPI_") != 0 || s.indexOf("\tYes\t") <= 0) continue;
                holdcounter = s.substring(0, s.indexOf("\t"));
                avail.add(holdcounter);
                this.counterNames.add(holdcounter);
                String defCounter = s.substring(s.lastIndexOf("\t") + 1);
                int lendex = 55;
                int freespace = 0;
                while (lendex < defCounter.length()) {
                    freespace = defCounter.lastIndexOf(32, lendex - 1);
                    defCounter = String.valueOf(defCounter.substring(0, freespace + 1)) + '\n' + defCounter.substring(freespace + 1);
                    lendex += 55;
                }
                this.counterDefs.add(defCounter);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        this.avCounters = avail;
    }

    private void findNativeAvail() {
        IFileStore papi_avail = this.location.getChild("papi_native_avail");
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(papi_avail.toURI().getPath());
        String s = null;
        LinkedHashSet<String> avail = new LinkedHashSet<String>();
        String holdcounter = null;
        try {
            byte[] xbytes = this.blt.runToolGetOutput(commands, null, null);
            if (xbytes == null) {
                return;
            }
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(xbytes)));
            while ((s = stdInput.readLine()) != null) {
                if (s.indexOf("   0x") <= 0) continue;
                holdcounter = s.substring(0, s.indexOf(" "));
                avail.add(holdcounter);
                this.counterNames.add(holdcounter);
                String defCounter = s.substring(s.lastIndexOf("   ") + 3);
                int lendex = 55;
                int freespace = 0;
                while (lendex < defCounter.length()) {
                    freespace = defCounter.lastIndexOf(32, lendex - 1);
                    defCounter = String.valueOf(defCounter.substring(0, freespace + 1)) + '\n' + defCounter.substring(freespace + 1);
                    lendex += 55;
                }
                this.counterDefs.add(defCounter);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        this.avCounters = avail;
    }

    private LinkedHashSet<String> getRejects(LinkedHashSet<Object> selected) {
        int entryIndex = 14;
        int entryLines = 1;
        if (this.countType == 1) {
            entryIndex = 13;
            entryLines = 5;
        }
        String counterString = "PRESET";
        if (this.countType != 0) {
            counterString = "NATIVE";
        }
        IFileStore papi_event_chooser = this.location.getChild("papi_event_chooser");
        ArrayList<String> pec_command = new ArrayList<String>();
        pec_command.add(papi_event_chooser.toURI().getPath());
        pec_command.add(counterString);
        if (selected != null && selected.size() > 0) {
            Iterator itsel = selected.iterator();
            while (itsel.hasNext()) {
                pec_command.add((String)itsel.next());
            }
        } else {
            return new LinkedHashSet<String>(1);
        }
        String s = null;
        LinkedHashSet<String> result = new LinkedHashSet<String>(this.avCounters);
        result.removeAll(selected);
        byte[] xbytes = this.blt.runToolGetOutput(pec_command, null, null);
        if (xbytes == null) {
            return null;
        }
        try {
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(xbytes)));
            int countLines = 0;
            int tabDex = 0;
            while ((s = stdInput.readLine()) != null) {
                if (++countLines < entryIndex || (countLines - entryIndex) % entryLines != 0) continue;
                tabDex = s.indexOf("\t");
                if (tabDex == -1) {
                    countLines = 0;
                    continue;
                }
                result.remove(s.substring(0, tabDex));
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return result;
    }
}

