/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.mpich2.core.launch;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.rm.mpi.mpich2.core.MPICH2Plugin;
import org.eclipse.ptp.rm.mpi.mpich2.core.launch.MPICH2LaunchConfigurationDefaults;

public class MPICH2LaunchConfiguration {
    public static final String ATTR_BASE = String.valueOf(MPICH2Plugin.getUniqueIdentifier()) + ".launchAttributes";
    public static final String ATTR_NUMPROCS = String.valueOf(ATTR_BASE) + ".numProcs";
    public static final String ATTR_NOLOCAL = String.valueOf(ATTR_BASE) + ".noLocal";
    public static final String ATTR_PREFIX = String.valueOf(ATTR_BASE) + ".prefix";
    public static final String ATTR_USEPREFIX = String.valueOf(ATTR_BASE) + ".usePrefix";
    public static final String ATTR_HOSTFILE = String.valueOf(ATTR_BASE) + ".hostFile";
    public static final String ATTR_USEHOSTFILE = String.valueOf(ATTR_BASE) + ".useHostFile";
    public static final String ATTR_HOSTLIST = String.valueOf(ATTR_BASE) + ".hostList";
    public static final String ATTR_USEHOSTLIST = String.valueOf(ATTR_BASE) + ".useHostList";
    public static final String ATTR_ARGUMENTS = String.valueOf(ATTR_BASE) + ".arguments";
    public static final String ATTR_USEDEFAULTARGUMENTS = String.valueOf(ATTR_BASE) + ".useDefaultArguments";
    public static final String ATTR_PARAMETERS = String.valueOf(ATTR_BASE) + ".parameters";
    public static final String ATTR_USEDEFAULTPARAMETERS = String.valueOf(ATTR_BASE) + ".useDefaultParameters";

    public static String calculateArguments(ILaunchConfiguration configuration) throws CoreException {
        if (configuration.getAttribute(ATTR_USEDEFAULTARGUMENTS, MPICH2LaunchConfigurationDefaults.ATTR_USEDEFAULTARGUMENTS)) {
            String launchArgs = "-np " + Integer.toString(configuration.getAttribute(ATTR_NUMPROCS, MPICH2LaunchConfigurationDefaults.ATTR_NUMPROCS));
            if (configuration.getAttribute(ATTR_NOLOCAL, MPICH2LaunchConfigurationDefaults.ATTR_NOLOCAL)) {
                launchArgs = String.valueOf(launchArgs) + " -nolocal";
            }
            if (configuration.getAttribute(ATTR_USEPREFIX, MPICH2LaunchConfigurationDefaults.ATTR_USEPREFIX)) {
                launchArgs = String.valueOf(launchArgs) + " --prefix " + MPICH2LaunchConfiguration.fixString(configuration.getAttribute(ATTR_PREFIX, MPICH2LaunchConfigurationDefaults.ATTR_PREFIX));
            }
            if (configuration.getAttribute(ATTR_USEHOSTFILE, MPICH2LaunchConfigurationDefaults.ATTR_USEHOSTFILE)) {
                launchArgs = String.valueOf(launchArgs) + " -hostfile " + MPICH2LaunchConfiguration.fixString(configuration.getAttribute(ATTR_HOSTFILE, MPICH2LaunchConfigurationDefaults.ATTR_HOSTFILE));
            }
            if (configuration.getAttribute(ATTR_USEHOSTLIST, MPICH2LaunchConfigurationDefaults.ATTR_USEHOSTLIST)) {
                launchArgs = String.valueOf(launchArgs) + " -host " + MPICH2LaunchConfiguration.textToHostList(MPICH2LaunchConfiguration.fixString(configuration.getAttribute(ATTR_HOSTLIST, MPICH2LaunchConfigurationDefaults.ATTR_HOSTLIST)));
            }
            if (!configuration.getAttribute(ATTR_USEDEFAULTPARAMETERS, MPICH2LaunchConfigurationDefaults.ATTR_USEDEFAULTPARAMETERS)) {
                Map params = configuration.getAttribute(ATTR_PARAMETERS, MPICH2LaunchConfigurationDefaults.ATTR_PARAMETERS);
                for (Map.Entry param : params.entrySet()) {
                    launchArgs = String.valueOf(launchArgs) + " -mca " + (String)param.getKey() + " " + MPICH2LaunchConfiguration.fixString((String)param.getValue());
                }
            }
            return launchArgs;
        }
        return configuration.getAttribute(ATTR_ARGUMENTS, MPICH2LaunchConfigurationDefaults.ATTR_ARGUMENTS);
    }

    private static String fixString(String s) {
        if (s == null) {
            return "\"\"";
        }
        return "\"" + s + "\"";
    }

    private static String textToHostList(String text) {
        if (text == null) {
            return "";
        }
        String result = "";
        String[] values = text.split("\n");
        int i = 0;
        while (i < values.length) {
            if (!values[i].equals("")) {
                if (i > 0) {
                    result = String.valueOf(result) + ",";
                }
                result = String.valueOf(result) + values[i];
            }
            ++i;
        }
        return result;
    }
}

