/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.data;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.ArgType;
import org.eclipse.ptp.utils.core.ArgumentParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgImpl {
    private final String uuid;
    private final ArgType arg;
    private final IVariableMap map;

    public static String[] getArgs(String uuid, List<ArgType> args, IVariableMap map) {
        ArrayList resolved = new ArrayList();
        for (ArgType a : args) {
            ArgumentParser arg = new ArgumentParser(ArgImpl.getResolved(uuid, a, map));
            resolved.addAll(arg.getTokenList());
        }
        return resolved.toArray(new String[0]);
    }

    public static String toString(String uuid, List<ArgType> args, IVariableMap map) {
        if (args.isEmpty()) {
            return "";
        }
        StringBuffer b = new StringBuffer();
        String resolved = ArgImpl.getResolved(uuid, args.get(0), map);
        if (!"".equals(resolved)) {
            b.append(resolved);
        }
        int i = 1;
        while (i < args.size()) {
            resolved = ArgImpl.getResolved(uuid, args.get(i), map);
            if (!"".equals(resolved)) {
                b.append(" ").append(resolved);
            }
            ++i;
        }
        return b.toString();
    }

    private static String getResolved(String uuid, ArgType arg, IVariableMap map) {
        if (arg == null) {
            return "";
        }
        if (!arg.isResolve()) {
            return arg.getContent();
        }
        String dereferenced = map.getString(uuid, arg.getContent());
        String undefined = arg.getIsUndefinedIfMatches();
        if (undefined != null && dereferenced != null) {
            String dtrim = dereferenced.trim();
            String utrim = undefined.trim();
            if (dtrim.matches(utrim = map.getString(uuid, utrim))) {
                return "";
            }
        }
        return dereferenced;
    }

    public ArgImpl(String uuid, ArgType arg, IVariableMap map) {
        this.uuid = uuid;
        this.arg = arg;
        this.map = map;
    }

    public String getResolved() {
        return ArgImpl.getResolved(this.uuid, this.arg, this.map);
    }
}

