/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.mpi.core.analysis;

import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ptp.pldt.common.CommonPlugin;
import org.eclipse.ptp.pldt.common.ScanReturn;
import org.eclipse.ptp.pldt.common.analysis.PldtAstVisitor;
import org.eclipse.ptp.pldt.mpi.core.MpiPlugin;
import org.eclipse.ptp.pldt.mpi.core.messages.Messages;
import org.eclipse.ptp.pldt.mpi.internal.core.MpiIDs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MpiCASTVisitor
extends PldtAstVisitor {
    private static final String PREFIX = "MPI_";
    private static boolean traceOn = false;

    public MpiCASTVisitor(List<String> mpiIncludes, String fileName, boolean allowPrefixOnlyMatch, ScanReturn msr) {
        super(mpiIncludes, fileName, allowPrefixOnlyMatch, msr);
        this.shouldVisitExpressions = true;
        this.shouldVisitStatements = true;
        this.shouldVisitDeclarations = true;
        this.shouldVisitTranslationUnit = true;
        ARTIFACT_CALL = Messages.MpiCASTVisitor_mpiCall;
        ARTIFACT_CONSTANT = Messages.MpiCASTVisitor_mpiConstant;
        ARTIFACT_NAME = "MPI";
        traceOn = CommonPlugin.getTraceOn();
        if (traceOn) {
            System.out.println("MpiCASTVisitor.ctor: traceOn=" + traceOn);
        }
    }

    public boolean allowIncludePathAdd() {
        boolean canAsk = this.getPreferenceStore().getBoolean("mpiPromptForOtherIncludes");
        return canAsk;
    }

    protected String getIncludesPrefID() {
        return MpiIDs.MPI_INCLUDES;
    }

    protected IPreferenceStore getPreferenceStore() {
        return MpiPlugin.getDefault().getPreferenceStore();
    }

    protected String getTypeName() {
        return ARTIFACT_NAME;
    }

    public boolean matchesPrefix(String name) {
        return name.startsWith(PREFIX);
    }
}

