/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.services.ui;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.ProjectNotConfiguredException;
import org.eclipse.ptp.services.core.ServiceModelManager;
import org.eclipse.ptp.services.ui.ServicesUIPlugin;
import org.eclipse.ptp.services.ui.dialogs.ServiceConfigurationSelectionDialog;
import org.eclipse.ptp.services.ui.messages.Messages;
import org.eclipse.ptp.services.ui.widgets.ServiceProviderConfigurationWidget;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;

public class ServiceConfigurationPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private static int BUTTON_WIDTH = 85;
    private Button addButton;
    private IServiceConfiguration currentConfig;
    private Vector<IServiceConfiguration> deletedServiceConfigurations;
    private final EventHandler eventHandler = new EventHandler();
    private Composite propertiesPane;
    private Button removeButton;
    private ServiceConfigurationComparator serviceConfigurationComparator = new ServiceConfigurationComparator();
    private Table serviceConfigurationList;
    private ServiceScrolledComposite serviceModelPane;
    private ServiceProviderConfigurationWidget serviceModelWidget;

    public boolean performOk() {
        this.deleteServiceConfigurations();
        this.serviceModelWidget.applyChangesToConfiguration();
        try {
            ServiceModelManager.getInstance().saveModelConfiguration();
        }
        catch (IOException e) {
            ServicesUIPlugin.getDefault().log(e);
        }
        return super.performOk();
    }

    private void addServiceConfiguration() {
        IServiceConfiguration config;
        HashSet<IServiceConfiguration> configs;
        try {
            configs = ServiceModelManager.getInstance().getConfigurations(this.getProject());
        }
        catch (ProjectNotConfiguredException projectNotConfiguredException) {
            configs = new HashSet<IServiceConfiguration>();
        }
        ServiceConfigurationSelectionDialog dialog = new ServiceConfigurationSelectionDialog(this.getShell(), configs);
        int status = dialog.open();
        if (status == 0 && (config = dialog.getSelectedConfiguration()) != null) {
            TableItem item = new TableItem(this.serviceConfigurationList, 0);
            item.setData((Object)config);
            item.setText(config.getName());
            ServiceModelManager.getInstance().addConfiguration(this.getProject(), config);
        }
    }

    private void deleteServiceConfigurations() {
        if (this.deletedServiceConfigurations != null) {
            for (IServiceConfiguration config : this.deletedServiceConfigurations) {
                ServiceModelManager.getInstance().removeConfiguration(this.getProject(), config);
            }
            this.deletedServiceConfigurations.clear();
        }
    }

    private IProject getProject() {
        IAdaptable element = this.getElement();
        IProject project = null;
        if (element instanceof IProject) {
            project = (IProject)element;
        } else if (element instanceof IAdaptable) {
            project = (IProject)element.getAdapter(IProject.class);
        }
        return project;
    }

    private void getProjectConfigurations() {
        try {
            IServiceConfiguration[] serviceConfigurations = ServiceModelManager.getInstance().getConfigurations(this.getProject()).toArray(new IServiceConfiguration[0]);
            Arrays.sort(serviceConfigurations, this.serviceConfigurationComparator);
            IServiceConfiguration[] iServiceConfigurationArray = serviceConfigurations;
            int n = serviceConfigurations.length;
            int n2 = 0;
            while (n2 < n) {
                IServiceConfiguration config = iServiceConfigurationArray[n2];
                TableItem item = new TableItem(this.serviceConfigurationList, 0);
                item.setData((Object)config);
                item.setText(0, config.getName());
                ++n2;
            }
        }
        catch (ProjectNotConfiguredException projectNotConfiguredException) {}
    }

    private void removeServiceConfiguration() {
        TableItem[] selection = this.serviceConfigurationList.getSelection();
        if (selection.length > 0) {
            IServiceConfiguration selectedConfig = (IServiceConfiguration)selection[0].getData();
            if (this.deletedServiceConfigurations == null) {
                this.deletedServiceConfigurations = new Vector();
            }
            this.deletedServiceConfigurations.add(selectedConfig);
            this.serviceConfigurationList.remove(this.serviceConfigurationList.getSelectionIndex());
            this.serviceModelWidget.setServiceConfiguration(null);
        }
    }

    private void showSelectedConfiguration() {
        TableItem[] selection = this.serviceConfigurationList.getSelection();
        if (selection.length > 0) {
            IServiceConfiguration selectedConfig = (IServiceConfiguration)selection[0].getData();
            if (selectedConfig != this.currentConfig) {
                this.currentConfig = selectedConfig;
                Set<String> natures = Collections.emptySet();
                IProject project = (IProject)this.getElement().getAdapter(IProject.class);
                if (project != null) {
                    try {
                        natures = new HashSet<String>(Arrays.asList(project.getDescription().getNatureIds()));
                    }
                    catch (CoreException e) {
                        ServicesUIPlugin.getDefault().log(e);
                    }
                }
                this.serviceModelWidget.setServiceConfiguration(selectedConfig, natures);
                this.serviceModelWidget.setEnabled(true);
                this.serviceModelPane.reflow(true);
            }
        } else {
            this.currentConfig = null;
            this.serviceModelWidget.setServiceConfiguration(null);
            this.serviceModelWidget.setEnabled(false);
        }
    }

    protected Control createContents(Composite parent) {
        this.propertiesPane = new Composite(parent, 0);
        GridLayout propertiesPaneLayout = new GridLayout(1, true);
        propertiesPaneLayout.marginHeight = 0;
        propertiesPaneLayout.marginWidth = 0;
        this.propertiesPane.setLayout((Layout)propertiesPaneLayout);
        Composite serviceConfigurationPane = new Composite(this.propertiesPane, 0);
        GridLayout serviceConfigLayout = new GridLayout(2, false);
        serviceConfigurationPane.setLayout((Layout)serviceConfigLayout);
        serviceConfigurationPane.setLayoutData((Object)new GridData(768));
        Label label = new Label(serviceConfigurationPane, 0);
        label.setText(Messages.ServiceConfigurationPropertyPage_2);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.serviceConfigurationList = new Table(serviceConfigurationPane, 2052);
        this.serviceConfigurationList.setLayoutData((Object)new GridData(1808));
        this.serviceConfigurationList.setLinesVisible(false);
        this.serviceConfigurationList.addSelectionListener((SelectionListener)this.eventHandler);
        Composite buttonPane = new Composite(serviceConfigurationPane, 0);
        buttonPane.setLayout((Layout)new GridLayout(1, true));
        this.addButton = new Button(buttonPane, 8);
        this.addButton.setText(Messages.ServiceConfigurationPropertyPage_0);
        this.addButton.addSelectionListener((SelectionListener)this.eventHandler);
        data = new GridData(4, 0x1000000, false, false, 1, 1);
        data.widthHint = BUTTON_WIDTH;
        this.addButton.setLayoutData((Object)data);
        this.removeButton = new Button(buttonPane, 8);
        this.removeButton.setText(Messages.ServiceConfigurationPropertyPage_1);
        this.removeButton.addSelectionListener((SelectionListener)this.eventHandler);
        data = new GridData(4, 0x1000000, false, false, 1, 1);
        data.widthHint = BUTTON_WIDTH;
        this.removeButton.setLayoutData((Object)data);
        this.serviceModelPane = new ServiceScrolledComposite(this.propertiesPane, 768);
        this.serviceModelPane.setExpandVertical(true);
        this.serviceModelPane.setExpandHorizontal(true);
        this.serviceModelPane.setLayoutData(new GridData(4, 4, true, true));
        Composite serviceComp = new Composite((Composite)this.serviceModelPane, 0);
        serviceComp.setLayout((Layout)new GridLayout(1, true));
        this.serviceModelWidget = new ServiceProviderConfigurationWidget(serviceComp, 0);
        this.serviceModelWidget.addSelectionListener(this.eventHandler);
        this.serviceModelWidget.setLayoutData(new GridData(4, 4, true, true));
        this.serviceModelPane.setContent((Control)serviceComp);
        this.serviceModelPane.setMinSize(serviceComp.computeSize(-1, -1));
        this.getProjectConfigurations();
        return this.propertiesPane;
    }

    private class EventHandler
    implements SelectionListener {
        private EventHandler() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == ServiceConfigurationPropertyPage.this.serviceConfigurationList) {
                ServiceConfigurationPropertyPage.this.showSelectedConfiguration();
            } else if (source == ServiceConfigurationPropertyPage.this.addButton) {
                ServiceConfigurationPropertyPage.this.addServiceConfiguration();
            } else if (source == ServiceConfigurationPropertyPage.this.removeButton) {
                ServiceConfigurationPropertyPage.this.removeServiceConfiguration();
            } else if (source == ServiceConfigurationPropertyPage.this.serviceModelWidget) {
                ServiceConfigurationPropertyPage.this.serviceModelPane.reflow(true);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ServiceConfigurationComparator
    implements Comparator<IServiceConfiguration> {
        private ServiceConfigurationComparator() {
        }

        @Override
        public int compare(IServiceConfiguration o1, IServiceConfiguration o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    private class ServiceScrolledComposite
    extends SharedScrolledComposite {
        public ServiceScrolledComposite(Composite parent, int style) {
            super(parent, style);
        }
    }
}

