/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.services.ui.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceModelManager;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.ServiceModelManager;
import org.eclipse.ptp.services.ui.messages.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceConfigurationSelectionWidget
extends Composite
implements ISelectionProvider {
    private static final int TABLE_WIDTH = 400;
    private static final int TABLE_HEIGHT = 250;
    private static final int BUTTON_WIDTH = 110;
    private final ListenerList fSelectionListeners = new ListenerList();
    private final IServiceModelManager fManager = ServiceModelManager.getInstance();
    private TableViewer fTableViewer;
    private Table fTable;
    private TableColumnLayout fTableLayout;
    private Button fAddButton;
    private Button fRemoveButton;
    private Button fRenameButton;
    private Button fSelectAllButton;
    private Button fDeselectAllButton;
    private ISelection fSelection;
    private boolean fEnabled = true;
    private boolean fButtonsVisible = true;
    private boolean fUseCheckboxes = false;
    private Set<IService> fServices = null;
    private Set<IServiceConfiguration> fExcludedConfigs = null;
    private IServiceConfiguration[] fDisplayConfigs = null;
    private IServiceConfiguration fSelectedConfig = null;

    public ServiceConfigurationSelectionWidget(Composite parent, int style) {
        this(parent, style, null, null, true);
    }

    public ServiceConfigurationSelectionWidget(Composite parent, int style, Set<IServiceConfiguration> excluded, Set<IService> services, boolean enableButtons) {
        super(parent, style);
        Composite buttonsComp;
        this.fServices = services;
        this.fUseCheckboxes = (style & 0x20) == 32;
        GridLayout bodyLayout = enableButtons && !this.fUseCheckboxes ? new GridLayout(2, false) : new GridLayout(1, false);
        bodyLayout.marginHeight = 0;
        bodyLayout.marginWidth = 0;
        this.setLayout((Layout)bodyLayout);
        this.setLayoutData(new GridData(1808));
        Composite tableComposite = new Composite((Composite)this, 0);
        this.fTableLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)this.fTableLayout);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        if (this.fUseCheckboxes) {
            this.fTable = new Table(tableComposite, 2848);
            this.fTableViewer = new CheckboxTableViewer(this.fTable);
            ((CheckboxTableViewer)this.fTableViewer).addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    ServiceConfigurationSelectionWidget.this.updateControls();
                }
            });
        } else {
            this.fTableViewer = new TableViewer(tableComposite, 68354);
            this.fTable = this.fTableViewer.getTable();
        }
        this.fTable.setLayout((Layout)new TableLayout());
        GridData data = new GridData(1808);
        data.heightHint = 250;
        data.widthHint = 400;
        this.fTable.setLayoutData((Object)data);
        if (this.fServices != null) {
            this.fTable.setHeaderVisible(true);
        }
        this.fTableViewer.setContentProvider((IContentProvider)new ServiceConfigurationContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.fTableViewer.setComparator((ViewerComparator)new ServiceConfigurationComparator());
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ServiceConfigurationSelectionWidget.this.notifySelection(ServiceConfigurationSelectionWidget.this.fTableViewer.getSelection());
                ServiceConfigurationSelectionWidget.this.updateControls();
            }
        });
        this.createColumns();
        this.fTableViewer.setInput((Object)this);
        if (enableButtons && !this.fUseCheckboxes) {
            buttonsComp = new Composite((Composite)this, 0);
            buttonsComp.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
            buttonsComp.setLayout((Layout)new GridLayout(1, false));
            this.fAddButton = new Button(buttonsComp, 8);
            data = new GridData(4, 0x1000000, false, false, 1, 1);
            data.widthHint = 110;
            this.fAddButton.setLayoutData((Object)data);
            this.fAddButton.setText(Messages.ServiceConfigurationSelectionWidget_1);
            this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    InputDialog dialog = new InputDialog(ServiceConfigurationSelectionWidget.this.fAddButton.getShell(), Messages.ServiceConfigurationSelectionWidget_2, Messages.ServiceConfigurationSelectionWidget_3, null, null);
                    if (dialog.open() == 0) {
                        IServiceConfiguration config = ServiceConfigurationSelectionWidget.this.fManager.newServiceConfiguration(dialog.getValue());
                        ServiceConfigurationSelectionWidget.this.fManager.addConfiguration(config);
                        ServiceConfigurationSelectionWidget.this.fTableViewer.refresh();
                    }
                }
            });
            this.fRemoveButton = new Button(buttonsComp, 8);
            this.fRemoveButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            this.fRemoveButton.setText(Messages.ServiceConfigurationSelectionWidget_4);
            this.fRemoveButton.setEnabled(false);
            this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    IStructuredSelection selection = (IStructuredSelection)ServiceConfigurationSelectionWidget.this.fTableViewer.getSelection();
                    if (!selection.isEmpty()) {
                        Object[] configs = selection.toArray();
                        String names = "";
                        int i = 0;
                        while (i < configs.length) {
                            if (i > 0) {
                                names = String.valueOf(names) + ", ";
                            }
                            names = String.valueOf(names) + "\"" + ((IServiceConfiguration)configs[i]).getName() + "\"";
                            ++i;
                        }
                        boolean doRemove = MessageDialog.openConfirm((Shell)ServiceConfigurationSelectionWidget.this.fRemoveButton.getShell(), (String)Messages.ServiceConfigurationSelectionWidget_9, (String)NLS.bind((String)Messages.ServiceConfigurationSelectionWidget_10, (Object)names));
                        if (doRemove) {
                            Object[] objectArray = configs;
                            int n = configs.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object config = objectArray[n2];
                                ServiceConfigurationSelectionWidget.this.fManager.remove((IServiceConfiguration)config);
                                ++n2;
                            }
                            ServiceConfigurationSelectionWidget.this.fTableViewer.refresh();
                        }
                    }
                }
            });
            this.fRenameButton = new Button(buttonsComp, 8);
            this.fRenameButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            this.fRenameButton.setText(Messages.ServiceConfigurationSelectionWidget_11);
            this.fRenameButton.setEnabled(false);
            this.fRenameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    InputDialog dialog;
                    IStructuredSelection selection = (IStructuredSelection)ServiceConfigurationSelectionWidget.this.fTableViewer.getSelection();
                    if (!selection.isEmpty() && (dialog = new InputDialog(ServiceConfigurationSelectionWidget.this.fAddButton.getShell(), Messages.ServiceConfigurationSelectionWidget_12, Messages.ServiceConfigurationSelectionWidget_13, null, null)).open() == 0) {
                        IServiceConfiguration config = (IServiceConfiguration)selection.getFirstElement();
                        config.setName(dialog.getValue());
                        ServiceConfigurationSelectionWidget.this.fTableViewer.update((Object)config, null);
                    }
                }
            });
        }
        if (enableButtons && this.fUseCheckboxes) {
            buttonsComp = new Composite((Composite)this, 0);
            buttonsComp.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
            buttonsComp.setLayout((Layout)new GridLayout(2, false));
            this.fSelectAllButton = new Button(buttonsComp, 8);
            data = new GridData(4, 0x1000000, false, false, 1, 1);
            this.fSelectAllButton.setLayoutData((Object)data);
            this.fSelectAllButton.setText(Messages.ServiceConfigurationSelectionWidget_5);
            this.fSelectAllButton.setEnabled(false);
            this.fSelectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    ServiceConfigurationSelectionWidget.this.setAllChecked(true);
                }
            });
            this.fDeselectAllButton = new Button(buttonsComp, 8);
            data = new GridData(4, 0x1000000, false, false, 1, 1);
            this.fDeselectAllButton.setLayoutData((Object)data);
            this.fDeselectAllButton.setText(Messages.ServiceConfigurationSelectionWidget_6);
            this.fDeselectAllButton.setEnabled(false);
            this.fDeselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    ServiceConfigurationSelectionWidget.this.setAllChecked(false);
                }
            });
        }
        this.fExcludedConfigs = excluded;
        this.fButtonsVisible = enableButtons;
        this.updateControls();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.add((Object)listener);
    }

    public IServiceConfiguration[] getCheckedServiceConfigurations() {
        if (this.fUseCheckboxes) {
            Object[] elements = ((CheckboxTableViewer)this.fTableViewer).getCheckedElements();
            return Arrays.asList(elements).toArray(new IServiceConfiguration[0]);
        }
        return new IServiceConfiguration[0];
    }

    public boolean getEnabled() {
        return this.fEnabled;
    }

    public IServiceConfiguration getSelectedConfiguration() {
        return this.fSelectedConfig;
    }

    public ISelection getSelection() {
        return this.fSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.remove((Object)listener);
    }

    public void setAllChecked(boolean state) {
        if (this.fUseCheckboxes) {
            ((CheckboxTableViewer)this.fTableViewer).setAllChecked(state);
            this.notifySelection(this.fTableViewer.getSelection());
        }
    }

    public void setConfigurations(IServiceConfiguration[] configurations) {
        this.fDisplayConfigs = configurations;
        this.fTableViewer.refresh();
    }

    public void setEnabled(boolean enabled) {
        this.fEnabled = enabled;
        this.updateControls();
    }

    public void setSelection(ISelection selection) {
        this.fSelection = selection;
    }

    private TableViewerColumn addColumn(String colName) {
        TableViewerColumn column = new TableViewerColumn(this.fTableViewer, 0);
        column.getColumn().setResizable(true);
        column.getColumn().setMoveable(true);
        column.getColumn().setText(colName);
        PixelConverter converter = new PixelConverter(this.fTableViewer.getControl());
        int colWidth = converter.convertWidthInCharsToPixels(colName.length() + 1);
        this.fTableLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(10, colWidth));
        return column;
    }

    private void createColumns() {
        TableViewerColumn firstColumn = this.addColumn(Messages.ServiceConfigurationSelectionWidget_7);
        firstColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IServiceConfiguration)element).getName();
            }
        });
        if (this.fServices != null) {
            TreeSet<IService> services = new TreeSet<IService>(new Comparator<IService>(){

                @Override
                public int compare(IService o1, IService o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (IService service : this.fServices) {
                services.add(service);
            }
            for (IService service : services) {
                String name = String.valueOf(service.getName()) + Messages.ServiceConfigurationSelectionWidget_8;
                final TableViewerColumn column = this.addColumn(name);
                column.getColumn().setData((Object)service);
                column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                    public String getText(Object element) {
                        IServiceConfiguration config = (IServiceConfiguration)element;
                        IService service = (IService)column.getColumn().getData();
                        IServiceProvider provider = config.getServiceProvider(service);
                        if (provider == null || provider.equals(service.getNullProvider())) {
                            return Messages.ServiceConfigurationSelectionWidget_14;
                        }
                        return provider.getName();
                    }
                });
            }
        }
    }

    private void notifySelection(ISelection selection) {
        if (!selection.isEmpty()) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            this.fSelectedConfig = (IServiceConfiguration)structuredSelection.getFirstElement();
        } else {
            this.fSelectedConfig = null;
        }
        this.setSelection(selection);
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        Object[] objectArray = this.fSelectionListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ISelectionChangedListener)listener).selectionChanged(event);
            ++n2;
        }
    }

    private void updateControls() {
        this.fTable.setEnabled(this.fEnabled);
        if (!this.fUseCheckboxes && this.fButtonsVisible) {
            this.fAddButton.setEnabled(this.fEnabled);
            boolean enabled = this.fEnabled && this.getSelectedConfiguration() != null;
            this.fRemoveButton.setEnabled(enabled);
            this.fRenameButton.setEnabled(enabled);
        } else if (this.fButtonsVisible) {
            this.fSelectAllButton.setEnabled(this.fEnabled);
            this.fDeselectAllButton.setEnabled(this.fEnabled);
        }
    }

    private class ServiceConfigurationComparator
    extends ViewerComparator {
        private ServiceConfigurationComparator() {
        }

        public int compare(Viewer viewer, Object o1, Object o2) {
            if (o1 instanceof IServiceConfiguration && o2 instanceof IServiceConfiguration) {
                return ((IServiceConfiguration)o1).getName().compareToIgnoreCase(((IServiceConfiguration)o2).getName());
            }
            return super.compare(viewer, o1, o2);
        }
    }

    private class ServiceConfigurationContentProvider
    extends WorkbenchContentProvider {
        private ServiceConfigurationContentProvider() {
        }

        public Object[] getChildren(Object element) {
            ArrayList<IServiceConfiguration> children = new ArrayList<IServiceConfiguration>();
            if (ServiceConfigurationSelectionWidget.this.fDisplayConfigs == null) {
                children.addAll(ServiceModelManager.getInstance().getConfigurations());
            } else {
                children.addAll(Arrays.asList(ServiceConfigurationSelectionWidget.this.fDisplayConfigs));
            }
            if (ServiceConfigurationSelectionWidget.this.fExcludedConfigs != null) {
                children.removeAll(ServiceConfigurationSelectionWidget.this.fExcludedConfigs);
            }
            return children.toArray();
        }
    }
}

