/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.lexer.Terminal;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTAccessStmtNode;
import org.eclipse.photran.internal.core.parser.ASTAssignmentStmtNode;
import org.eclipse.photran.internal.core.parser.ASTAttrSpecSeqNode;
import org.eclipse.photran.internal.core.parser.ASTCallStmtNode;
import org.eclipse.photran.internal.core.parser.ASTContainsStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEntityDeclNode;
import org.eclipse.photran.internal.core.parser.ASTFunctionSubprogramNode;
import org.eclipse.photran.internal.core.parser.ASTGenericNameNode;
import org.eclipse.photran.internal.core.parser.ASTModuleNode;
import org.eclipse.photran.internal.core.parser.ASTSeparatedListNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineArgNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineSubprogramNode;
import org.eclipse.photran.internal.core.parser.ASTTypeDeclarationStmtNode;
import org.eclipse.photran.internal.core.parser.ASTTypeSpecNode;
import org.eclipse.photran.internal.core.parser.ASTVarOrFnRefNode;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.parser.IAccessId;
import org.eclipse.photran.internal.core.parser.IExpr;
import org.eclipse.photran.internal.core.refactoring.Messages;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranEditorRefactoring;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranResourceRefactoring;
import org.eclipse.photran.internal.core.reindenter.Reindenter;
import org.eclipse.photran.internal.core.sourceform.SourceForm;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.refactorings.UserInputBoolean;
import org.eclipse.rephraserengine.core.refactorings.UserInputString;
import org.eclipse.rephraserengine.core.vpg.IVPGNode;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGRefactoring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncapsulateVariableRefactoring
extends FortranEditorRefactoring {
    private PhotranTokenRef selectedReference = null;
    private Definition selectedTokenDef = null;
    private boolean isUsedAsArgument = false;
    private Set<PhotranTokenRef> allRefs = null;
    private String getterName = null;
    private String setterName = null;
    private boolean wereMethodsCreated = false;
    private boolean replaceAccessesInDeclaringModule = false;
    public static final String AMBIGUOUS_DEF = Messages.EncapsulateVariableRefactoring_NoUniqueDefinition;

    public String getDefaultGetterName() {
        String capitalizedIdentName = this.getCapitalizedIdentName();
        return "get" + capitalizedIdentName;
    }

    public String getDefaultSetterName() {
        String capitalizedIdentName = this.getCapitalizedIdentName();
        return "set" + capitalizedIdentName;
    }

    @UserInputString(label="Getter method name ", defaultValueMethod="getDefaultGetterName")
    public void setGetterName(String gName) {
        String parens = gName.length() < 2 ? "" : gName.substring(gName.length() - 2, gName.length());
        this.getterName = parens.equalsIgnoreCase("()") ? gName.substring(0, gName.length() - 2) : gName;
    }

    @UserInputString(label="Setter method name ", defaultValueMethod="getDefaultSetterName")
    public void setSetterName(String sName) {
        String parens = sName.length() < 2 ? "" : sName.substring(sName.length() - 2, sName.length());
        this.setterName = parens.equalsIgnoreCase("()") ? sName.substring(0, sName.length() - 2) : sName;
    }

    public String getGetterName() {
        return this.getterName == null ? this.getDefaultGetterName() : this.getterName;
    }

    public String getSetterName() {
        return this.setterName == null ? this.getDefaultSetterName() : this.setterName;
    }

    @UserInputBoolean(label="Replace accesses in declaring module", defaultValue=false)
    public void replaceAccessesInDeclaringModule(boolean replaceAccessesInDeclaringModule) {
        this.replaceAccessesInDeclaringModule = replaceAccessesInDeclaringModule;
    }

    public boolean isArgument() {
        return this.isUsedAsArgument;
    }

    public String getName() {
        return Messages.EncapsulateVariableRefactoring_Name;
    }

    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        Token t = EncapsulateVariableRefactoring.findEnclosingToken(this.astOfFileInEditor, this.selectedRegionInEditor);
        if (t == null) {
            this.fail(Messages.EncapsulateVariableRefactoring_CouldNotFindToken);
        }
        this.selectedReference = t.getTokenRef();
        Terminal term = t.getTerminal();
        if (term == null || term != Terminal.T_IDENT) {
            this.fail(Messages.EncapsulateVariableRefactoring_PleaseSelectAnIdentifier);
        }
        this.selectedTokenDef = EncapsulateVariableRefactoring.findUnambiguousDeclaration(t);
        if (this.selectedTokenDef == null) {
            this.fail(AMBIGUOUS_DEF);
        }
        this.checkCanBeEncapsulated(this.selectedTokenDef);
        this.allRefs = this.selectedTokenDef.findAllReferences(true);
        this.checkForFixedFormReferences(this.allRefs);
    }

    protected void checkCanBeEncapsulated(Definition def) throws VPGRefactoring.PreconditionFailure {
        if (!this.isDefinedInModule(def) || !def.getClassification().equals((Object)Definition.Classification.VARIABLE_DECLARATION)) {
            this.fail(Messages.EncapsulateVariableRefactoring_VariableNotSelected);
        }
        if (def.isParameter()) {
            this.fail(Messages.EncapsulateVariableRefactoring_CannotEncapsulatePARAMETER);
        }
        if (def.isArray()) {
            this.fail(Messages.EncapsulateVariableRefactoring_CannotEncapsulateArrays);
        }
        if (def.isPointer()) {
            this.fail(Messages.EncapsulateVariableRefactoring_CannotEncapsulatePointers);
        }
        if (def.isTarget()) {
            this.fail(Messages.EncapsulateVariableRefactoring_CannotEncapsulateTARGET);
        }
    }

    protected boolean isDefinedInModule(Definition def) {
        Token t = def.getTokenRef().findTokenOrReturnNull();
        if (t == null) {
            return false;
        }
        ASTModuleNode modNode = t.findNearestAncestor(ASTModuleNode.class);
        return modNode != null;
    }

    protected void checkForFixedFormReferences(Set<PhotranTokenRef> refs) throws VPGRefactoring.PreconditionFailure {
        for (PhotranTokenRef ref : refs) {
            this.checkForFixedForm(ref.getFile());
        }
    }

    protected void checkForFixedForm(IFile file) throws VPGRefactoring.PreconditionFailure {
        if (SourceForm.isFixedForm((IFile)file) && !FIXED_FORM_REFACTORING_ENABLED) {
            this.fail(Messages.bind((String)Messages.EncapsulateVariableRefactoring_CannotRefactorFixedFormFile, (Object)file.getName()));
        }
    }

    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        EncapsulateVariableRefactoring.checkForConflictingBindings(pm, (FortranResourceRefactoring.IConflictingBindingCallback)new ConflictingBindingErrorHandler(status), this.selectedTokenDef, this.allRefs, this.getGetterName(), this.getSetterName());
        try {
            Token varDefTok = this.declarationToken();
            ASTModuleNode declaringModule = varDefTok.findNearestAncestor(ASTModuleNode.class);
            if (declaringModule == null) {
                throw new IllegalStateException();
            }
            IFile defFile = varDefTok.getLogicalFile();
            ((PhotranVPG)this.vpg).acquirePermanentAST(defFile);
            for (IFile file : this.filesIn(this.allRefs)) {
                for (PhotranTokenRef ref : this.allRefs) {
                    if (!ref.getFile().equals((Object)file)) continue;
                    Token t = ref.findTokenOrReturnNull();
                    if (t == null) {
                        this.fail(Messages.EncapsulateVariableRefactoring_CouldNotFindTokenForVarRef);
                    }
                    if (!this.isUsedAsArgument) {
                        this.detectIfUsedAsArgument(t, status);
                    }
                    if (!this.replaceAccessesInDeclaringModule && this.isInModule(t, declaringModule)) continue;
                    this.replaceWithGetOrSet(t, status);
                }
                if (file.equals((Object)defFile)) continue;
                this.addChangeFromModifiedAST(file, pm);
            }
            this.addChangeFromModifiedAST(defFile, pm);
            ((PhotranVPG)this.vpg).releaseAST(defFile);
        }
        finally {
            ((PhotranVPG)this.vpg).releaseAllASTs();
        }
    }

    private Set<IFile> filesIn(Set<PhotranTokenRef> refs) {
        HashSet<IFile> result = new HashSet<IFile>(64);
        for (PhotranTokenRef r : refs) {
            result.add(r.getFile());
        }
        return result;
    }

    private boolean isInModule(Token t, ASTModuleNode m) {
        return t.findNearestAncestor(ASTModuleNode.class) == m;
    }

    private Token declarationToken() throws VPGRefactoring.PreconditionFailure {
        Token varDefTok = this.selectedTokenDef.getTokenRef().findTokenOrReturnNull();
        if (varDefTok == null) {
            this.fail(Messages.EncapsulateVariableRefactoring_CouldNotFindTokenForVarDef);
        }
        return varDefTok;
    }

    protected void detectIfUsedAsArgument(Token t, RefactoringStatus status) throws VPGRefactoring.PreconditionFailure {
        ASTSubroutineArgNode subNode = t.findNearestAncestor(ASTSubroutineArgNode.class);
        if (subNode != null && !this.isUsedAsArgument) {
            String message = Messages.bind((String)Messages.EncapsulateVariableRefactoring_WarningFunctionArgument, (Object)t.getPhysicalFile(), (Object)t.getLine());
            RefactoringStatusContext context = this.createContext((IVPGNode)t.getTokenRef());
            status.addWarning(message, context);
            this.isUsedAsArgument = true;
        }
    }

    protected void replaceWithGetOrSet(Token t, RefactoringStatus status) throws VPGRefactoring.PreconditionFailure {
        if (this.isTokenRead(t)) {
            this.replaceWithGetter(t);
            if (!this.wereMethodsCreated) {
                this.setGetterAndSetter();
                this.wereMethodsCreated = true;
            }
        } else if (this.isTokenWrittenTo(t)) {
            this.replaceWithSetter(t);
            if (!this.wereMethodsCreated) {
                this.setGetterAndSetter();
                this.wereMethodsCreated = true;
            }
        } else {
            String message = Messages.bind((String)Messages.EncapsulateVariableRefactoring_WarningWillNotChangeReference, (Object)t.getPhysicalFile(), (Object)t.getLine());
            RefactoringStatusContext context = this.createContext((IVPGNode)t.getTokenRef());
            status.addWarning(message, context);
        }
    }

    protected boolean isTokenRead(Token t) {
        ASTVarOrFnRefNode expressionNode = t.findNearestAncestor(ASTVarOrFnRefNode.class);
        return expressionNode != null;
    }

    protected void replaceWithGetter(Token t) throws VPGRefactoring.PreconditionFailure {
        this.checkIfCanEncapsulateWithGetter(t);
        IExpr newExpr = EncapsulateVariableRefactoring.parseLiteralExpression(String.valueOf(this.getGetterName()) + "()");
        newExpr.findFirstToken().setWhiteBefore("");
        IExpr oldExpr = t.findNearestAncestor(IExpr.class);
        oldExpr.replaceWith(newExpr);
    }

    protected void checkIfCanEncapsulateWithGetter(Token t) throws VPGRefactoring.PreconditionFailure {
        IExpr expr = t.findNearestAncestor(IExpr.class);
        if (expr == null) {
            this.fail(Messages.bind((String)Messages.EncapsulateVariableRefactoring_NotAnExpression, (Object)t.getPhysicalFile(), (Object)t.getLine()));
        }
    }

    protected void setGetterAndSetter() throws VPGRefactoring.PreconditionFailure {
        Token varDefTok = this.declarationToken();
        ASTModuleNode mod = varDefTok.findNearestAncestor(ASTModuleNode.class);
        IASTListNode<? extends IASTNode> lst = mod.getBody();
        this.addPrivateStatement(varDefTok, lst);
        this.addGetterFunction(this.selectedTokenDef, lst);
        this.addSetterFunction(this.selectedTokenDef, lst);
    }

    protected void addPrivateStatement(Token varDefTok, IASTListNode lst) throws VPGRefactoring.PreconditionFailure {
        ASTTypeDeclarationStmtNode typeDec = varDefTok.findNearestAncestor(ASTTypeDeclarationStmtNode.class);
        int i = 0;
        while (i < lst.size()) {
            ASTTypeDeclarationStmtNode possibleTypeDec;
            IASTNode node = (IASTNode)lst.get(i);
            if (node instanceof ASTTypeDeclarationStmtNode && (possibleTypeDec = (ASTTypeDeclarationStmtNode)node) != null && possibleTypeDec == typeDec) {
                ASTTypeDeclarationStmtNode newDeclNode = this.removePublicDeclarationIfNeeded(varDefTok, possibleTypeDec, lst);
                ASTAccessStmtNode newAccessNode = (ASTAccessStmtNode)EncapsulateVariableRefactoring.parseLiteralStatement("private :: " + varDefTok.getText() + EOL);
                newAccessNode.setParent(lst);
                if (newDeclNode != null) {
                    lst.insertAfter(newDeclNode, newAccessNode);
                    Reindenter.reindent(newDeclNode, (IFortranAST)((PhotranVPG)this.vpg).acquireTransientAST(varDefTok.getLogicalFile()), Reindenter.Strategy.REINDENT_EACH_LINE);
                } else {
                    lst.insertAfter(possibleTypeDec, newAccessNode);
                }
                Reindenter.reindent(newAccessNode, (IFortranAST)((PhotranVPG)this.vpg).acquireTransientAST(varDefTok.getLogicalFile()), Reindenter.Strategy.REINDENT_EACH_LINE);
                break;
            }
            ++i;
        }
    }

    protected ASTTypeDeclarationStmtNode removePublicDeclarationIfNeeded(Token varDefTok, ASTTypeDeclarationStmtNode declNode, IASTListNode lst) {
        if (declNode.getAttrSpecSeq() != null && this.containsPublicInDecl(declNode.getAttrSpecSeq())) {
            return this.redeclareVariable(varDefTok, declNode);
        }
        boolean wasRemoved = false;
        int i = 0;
        while (i < lst.size() && !wasRemoved) {
            ASTAccessStmtNode accessNode;
            if (lst.get(i) instanceof ASTAccessStmtNode && (wasRemoved = this.removeTokenFromPublicVarDecl(accessNode = (ASTAccessStmtNode)lst.get(i), varDefTok)) && accessNode.getAccessIdList().size() <= 0) {
                lst.remove(accessNode);
                break;
            }
            ++i;
        }
        return null;
    }

    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
    }

    protected boolean isTokenWrittenTo(Token t) {
        ASTAssignmentStmtNode assign = t.findNearestAncestor(ASTAssignmentStmtNode.class);
        return assign != null;
    }

    protected void replaceWithSetter(Token t) {
        String whiteBeforeOld = t.getWhiteBefore();
        ASTAssignmentStmtNode oldAssignNode = t.findNearestAncestor(ASTAssignmentStmtNode.class);
        String setterString = "call " + this.getSetterName() + "()";
        ASTCallStmtNode newCallNode = (ASTCallStmtNode)EncapsulateVariableRefactoring.parseLiteralStatement(setterString);
        newCallNode.findFirstToken().setWhiteBefore(whiteBeforeOld);
        IASTListNode<ASTSubroutineArgNode> argList = this.convertToArguments(oldAssignNode);
        argList.setParent(newCallNode);
        newCallNode.setArgList(argList);
        oldAssignNode.replaceWith(newCallNode);
    }

    protected IASTListNode<ASTSubroutineArgNode> convertToArguments(ASTAssignmentStmtNode oldAssignNode) {
        ASTSubroutineArgNode args = new ASTSubroutineArgNode();
        Token tok = oldAssignNode.getRhs().findFirstToken();
        tok.setWhiteBefore("");
        args.setExpr(oldAssignNode.getRhs());
        oldAssignNode.getRhs().setParent(args);
        ArrayList<ASTSubroutineArgNode> argList = new ArrayList<ASTSubroutineArgNode>();
        argList.add(args);
        ASTSeparatedListNode<ASTSubroutineArgNode> sepList = new ASTSeparatedListNode<ASTSubroutineArgNode>(null, argList, true);
        args.setParent(sepList);
        return sepList;
    }

    protected int findOrCreateContainsIndex(IASTListNode lst) {
        boolean isFound = false;
        int i = 0;
        while (i < lst.size()) {
            IASTNode node = (IASTNode)lst.get(i);
            if (node instanceof ASTContainsStmtNode) {
                isFound = true;
                break;
            }
            ++i;
        }
        if (!isFound) {
            ASTContainsStmtNode containsStmt = EncapsulateVariableRefactoring.createContainsStmt();
            lst.add(containsStmt);
            i = lst.size() - 1;
        }
        return i;
    }

    protected void addGetterFunction(Definition def, IASTListNode lst) {
        int index = this.findOrCreateContainsIndex(lst);
        ASTFunctionSubprogramNode funNode = this.createGetterFunction(def);
        funNode.setParent(lst);
        lst.insertAfter(lst.get(index), funNode);
        Reindenter.reindent(funNode, (IFortranAST)((PhotranVPG)this.vpg).acquireTransientAST(def.getTokenRef().getFile()), Reindenter.Strategy.SHIFT_ENTIRE_BLOCK);
    }

    protected void addSetterFunction(Definition def, IASTListNode lst) {
        int index = this.findOrCreateContainsIndex(lst);
        ASTSubroutineSubprogramNode funNode = this.createSetterFunction(def);
        funNode.setParent(lst);
        lst.insertAfter(lst.get(index), funNode);
        Reindenter.reindent(funNode, (IFortranAST)((PhotranVPG)this.vpg).acquireTransientAST(def.getTokenRef().getFile()), Reindenter.Strategy.SHIFT_ENTIRE_BLOCK);
    }

    protected ASTFunctionSubprogramNode createGetterFunction(Definition def) {
        String type = def.getType().toString();
        String getterFunction = String.valueOf(type) + " function " + this.getGetterName() + "()" + EOL + Reindenter.defaultIndentation() + "implicit none" + EOL + Reindenter.defaultIndentation() + this.getGetterName() + " = " + def.getTokenRef().getText() + EOL + "end function" + EOL;
        ASTFunctionSubprogramNode newFunNode = (ASTFunctionSubprogramNode)EncapsulateVariableRefactoring.parseLiteralProgramUnit(getterFunction);
        return newFunNode;
    }

    protected ASTSubroutineSubprogramNode createSetterFunction(Definition def) {
        String type = def.getType().toString();
        String valueName = "value";
        String setterFunction = "subroutine " + this.getSetterName() + "(" + valueName + ")" + EOL + Reindenter.defaultIndentation() + "implicit none" + EOL + Reindenter.defaultIndentation() + type + ", intent(in) :: " + valueName + EOL + Reindenter.defaultIndentation() + def.getTokenRef().getText() + " = " + valueName + EOL + "end subroutine" + EOL;
        ASTSubroutineSubprogramNode newSubNode = (ASTSubroutineSubprogramNode)EncapsulateVariableRefactoring.parseLiteralProgramUnit(setterFunction);
        return newSubNode;
    }

    protected boolean containsPublicInDecl(IASTListNode lst) {
        int i = 0;
        while (i < lst.size()) {
            ASTAttrSpecSeqNode secNode;
            if (lst.get(i) instanceof ASTAttrSpecSeqNode && (secNode = (ASTAttrSpecSeqNode)lst.get(i)).getAttrSpec().getAccessSpec().isPublic()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected ASTTypeDeclarationStmtNode createNewDeclaration(Token varDefTok, ASTTypeSpecNode typeSpec) {
        String newDecl = String.valueOf(EncapsulateVariableRefactoring.findUnambiguousDeclaration(varDefTok).getType().toString()) + " :: " + varDefTok.getText();
        ASTTypeDeclarationStmtNode declNode = (ASTTypeDeclarationStmtNode)EncapsulateVariableRefactoring.parseLiteralStatement(newDecl);
        return declNode;
    }

    protected ASTTypeDeclarationStmtNode removeAllAndRedeclare(Token varDefTok, ASTTypeDeclarationStmtNode oldDeclNode) {
        ASTTypeDeclarationStmtNode newDeclNode = this.createNewDeclaration(varDefTok, oldDeclNode.getTypeSpec());
        oldDeclNode.replaceWith(newDeclNode);
        return newDeclNode;
    }

    protected ASTTypeDeclarationStmtNode removeAndRedeclare(Token varDefTok, ASTTypeDeclarationStmtNode oldDeclNode) {
        ASTTypeDeclarationStmtNode newDeclNode = this.createNewDeclaration(varDefTok, oldDeclNode.getTypeSpec());
        IASTListNode<ASTEntityDeclNode> lst = oldDeclNode.getEntityDeclList();
        for (ASTEntityDeclNode declNode : lst) {
            if (declNode.findFirstToken() != varDefTok) continue;
            lst.remove(declNode);
            break;
        }
        newDeclNode.setParent(oldDeclNode.getParent());
        IASTListNode parent = (IASTListNode)oldDeclNode.getParent();
        parent.insertAfter(oldDeclNode, newDeclNode);
        return newDeclNode;
    }

    protected ASTTypeDeclarationStmtNode redeclareVariable(Token varDefTok, ASTTypeDeclarationStmtNode declNode) {
        IASTListNode<ASTEntityDeclNode> declList = declNode.getEntityDeclList();
        if (declList.size() == 1) {
            return this.removeAllAndRedeclare(varDefTok, declNode);
        }
        return this.removeAndRedeclare(varDefTok, declNode);
    }

    protected boolean removeTokenFromPublicVarDecl(ASTAccessStmtNode accessNode, Token varDefTok) {
        if (accessNode.getAccessSpec().isPublic()) {
            IASTListNode<IAccessId> varList = accessNode.getAccessIdList();
            for (IAccessId id : varList) {
                ASTGenericNameNode name;
                String nameLabel;
                if (!(id instanceof ASTGenericNameNode) || !(nameLabel = (name = (ASTGenericNameNode)id).findFirstToken().getText()).equalsIgnoreCase(varDefTok.getText())) continue;
                varList.remove(id);
                return true;
            }
        }
        return false;
    }

    private String getCapitalizedIdentName() {
        String identName = this.selectedReference.getText();
        String fstLetter = identName.substring(0, 1);
        String upCase = fstLetter.toUpperCase();
        String capitalizedIdentName = upCase.concat(identName.substring(1));
        return capitalizedIdentName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ConflictingBindingErrorHandler
    implements FortranResourceRefactoring.IConflictingBindingCallback {
        private final RefactoringStatus status;

        private ConflictingBindingErrorHandler(RefactoringStatus status) {
            this.status = status;
        }

        @Override
        public void addConflictError(List<FortranResourceRefactoring.Conflict> conflictingDef) {
            for (FortranResourceRefactoring.Conflict conflict : conflictingDef) {
                String msg = Messages.bind((String)Messages.EncapsulateVariableRefactoring_NameConflicts, (Object)conflict.name, (Object)((PhotranVPG)EncapsulateVariableRefactoring.this.vpg).getDefinitionFor(conflict.tokenRef));
                RefactoringStatusContext context = EncapsulateVariableRefactoring.this.createContext((IVPGNode)conflict.tokenRef);
                this.status.addError(msg, context);
            }
        }

        @Override
        public void addConflictWarning(List<FortranResourceRefactoring.Conflict> conflictingDef) {
            for (FortranResourceRefactoring.Conflict conflict : conflictingDef) {
                String msg = Messages.bind((String)Messages.EncapsulateVariableRefactoring_NameMightConflict, (Object)conflict.name);
                RefactoringStatusContext context = EncapsulateVariableRefactoring.this.createContext((IVPGNode)conflict.tokenRef);
                this.status.addWarning(msg, context);
            }
        }

        @Override
        public void addReferenceWillChangeError(String newName, Token reference) {
        }
    }
}

