/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.regex.Pattern;
import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.IASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTInternalNameOwner;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPTwoPhaseBinding;
import org.eclipse.core.runtime.Assert;

public abstract class CPPASTNameBase
extends ASTNode
implements IASTName {
    protected static final Pattern WHITESPACE_SEQ = Pattern.compile("\\s+");
    public static boolean sAllowRecursionBindings = true;
    public static boolean sAllowNameComputation = true;
    private static final byte MAX_RESOLUTION_DEPTH = 6;
    private IBinding fBinding = null;
    private byte fResolutionDepth = 0;
    private boolean fIsFinal = false;

    public final void incResolutionDepth() {
        if (this.fBinding == null && (this.fResolutionDepth = (byte)(this.fResolutionDepth + 1)) > 6) {
            this.setBinding(new RecursionResolvingBinding(this));
        }
    }

    protected abstract IBinding createIntermediateBinding();

    public IBinding resolvePreBinding() {
        if (this.fBinding == null) {
            this.fResolutionDepth = (byte)(this.fResolutionDepth + 1);
            if (this.fResolutionDepth > 6) {
                this.setBinding(new RecursionResolvingBinding(this));
            } else {
                this.setBinding(this.createIntermediateBinding());
            }
        }
        return this.fBinding;
    }

    public IBinding resolveBinding() {
        if (this.fBinding == null) {
            this.fResolutionDepth = (byte)(this.fResolutionDepth + 1);
            if (this.fResolutionDepth > 6) {
                this.setBinding(new RecursionResolvingBinding(this));
            } else {
                ProblemBinding pb;
                IASTNode node;
                this.fIsFinal = false;
                IBinding b = this.createIntermediateBinding();
                if (b instanceof ProblemBinding && ((node = (pb = (ProblemBinding)b).getASTNode()) == null || node.getParent() == null)) {
                    pb.setASTNode(this);
                }
                this.setBinding(b);
            }
        }
        if (!this.fIsFinal) {
            this.resolveFinalBinding(this);
        }
        return this.fBinding;
    }

    public IBinding getPreBinding() {
        return this.fBinding;
    }

    public IBinding getBinding() {
        IBinding cand = this.fBinding;
        if (cand == null) {
            return null;
        }
        if (!this.fIsFinal) {
            this.resolveFinalBinding(this);
        }
        return this.fBinding;
    }

    private void resolveFinalBinding(CPPASTNameBase astName) {
        if (this.fBinding instanceof ICPPTwoPhaseBinding) {
            ICPPTwoPhaseBinding intermediateBinding = (ICPPTwoPhaseBinding)this.fBinding;
            this.fResolutionDepth = (byte)(this.fResolutionDepth + 1);
            if (this.fResolutionDepth > 6) {
                this.setBinding(new RecursionResolvingBinding(this));
            } else {
                this.setBinding(intermediateBinding.resolveFinalBinding(astName));
            }
        }
        this.fIsFinal = true;
    }

    public void setBinding(IBinding binding) {
        this.fBinding = binding;
        this.fResolutionDepth = 0;
    }

    public IASTName getLastName() {
        return this;
    }

    public final String toString() {
        return new String(this.toCharArray());
    }

    public IASTCompletionContext getCompletionContext() {
        IASTNode node = this.getParent();
        while (node != null) {
            if (node instanceof IASTCompletionContext) {
                return (IASTCompletionContext)((Object)node);
            }
            node = node.getParent();
        }
        return null;
    }

    public int getRoleOfName(boolean allowResolution) {
        IASTNode parent = this.getParent();
        if (parent instanceof IASTInternalNameOwner) {
            return ((IASTInternalNameOwner)((Object)parent)).getRoleForName(this, allowResolution);
        }
        if (parent instanceof IASTNameOwner) {
            return ((IASTNameOwner)((Object)parent)).getRoleForName(this);
        }
        return 3;
    }

    public boolean isDeclaration() {
        IASTNode parent = this.getParent();
        if (parent instanceof IASTNameOwner) {
            int role = ((IASTNameOwner)((Object)parent)).getRoleForName(this);
            switch (role) {
                case 1: 
                case 3: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean isReference() {
        IASTNode parent = this.getParent();
        if (parent instanceof IASTNameOwner) {
            int role = ((IASTNameOwner)((Object)parent)).getRoleForName(this);
            return role == 1;
        }
        return false;
    }

    public boolean isDefinition() {
        IASTNode parent = this.getParent();
        if (parent instanceof IASTNameOwner) {
            int role = ((IASTNameOwner)((Object)parent)).getRoleForName(this);
            return role == 2;
        }
        return false;
    }

    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    protected static final class RecursionResolvingBinding
    extends ProblemBinding {
        public RecursionResolvingBinding(IASTName node) {
            super(node, 14);
            Assert.isTrue((boolean)sAllowRecursionBindings, (String)this.getMessage());
        }
    }
}

