/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.preprocessor.c;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroExpansion;
import org.eclipse.photran.internal.core.preprocessor.c.ASTFileLocation;
import org.eclipse.photran.internal.core.preprocessor.c.ASTInclusionStatement;
import org.eclipse.photran.internal.core.preprocessor.c.LocationCtx;
import org.eclipse.photran.internal.core.preprocessor.c.LocationCtxContainer;
import org.eclipse.photran.internal.core.preprocessor.c.LocationCtxMacroExpansion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LocationCtxFile
extends LocationCtxContainer {
    private final String fFilename;
    private final ASTInclusionStatement fASTInclude;

    public LocationCtxFile(LocationCtxContainer parent, String filename, char[] source, int parentOffset, int parentEndOffset, int sequenceNumber, ASTInclusionStatement inclusionStatement) {
        super(parent, source, parentOffset, parentEndOffset, sequenceNumber);
        this.fFilename = new String(filename);
        this.fASTInclude = inclusionStatement;
    }

    @Override
    public final void addChildSequenceLength(int childLength) {
        super.addChildSequenceLength(childLength);
    }

    @Override
    public final String getFilePath() {
        return this.fFilename;
    }

    @Override
    public ASTFileLocation findMappedFileLocation(int sequenceNumber, int length) {
        int childSequenceEnd;
        LocationCtx child2;
        int testEnd = length > 1 ? sequenceNumber + length - 1 : sequenceNumber;
        int sequenceEnd = sequenceNumber + length;
        LocationCtx child1 = this.findChildLessOrEqualThan(sequenceNumber, false);
        LocationCtx locationCtx = child2 = testEnd == sequenceNumber ? child1 : this.findChildLessOrEqualThan(testEnd, false);
        if (child1 == child2 && child1 != null && child1.fSequenceNumber + child1.getSequenceLength() > testEnd) {
            return child1.findMappedFileLocation(sequenceNumber, length);
        }
        int startOffset = child1 == null ? sequenceNumber - this.fSequenceNumber : (sequenceNumber < (childSequenceEnd = child1.fSequenceNumber + child1.getSequenceLength()) ? child1.fOffsetInParent : child1.fEndOffsetInParent + sequenceNumber - childSequenceEnd);
        int endOffset = child2 == null ? sequenceEnd - this.fSequenceNumber : ((childSequenceEnd = child2.fSequenceNumber + child2.getSequenceLength()) < sequenceEnd ? child2.fEndOffsetInParent + sequenceEnd - childSequenceEnd : child2.fEndOffsetInParent);
        return new ASTFileLocation(this, startOffset, endOffset - startOffset);
    }

    @Override
    public ASTFileLocation createMappedFileLocation(int offset, int length) {
        return new ASTFileLocation(this, offset, length);
    }

    @Override
    public ASTInclusionStatement getInclusionStatement() {
        return this.fASTInclude;
    }

    @Override
    ASTFileLocation createFileLocation(int start, int length) {
        return new ASTFileLocation(this, start, length);
    }

    public boolean isThisFile(int sequenceNumber) {
        LocationCtx child = this.findChildLessOrEqualThan(sequenceNumber, false);
        if (!(child instanceof LocationCtxFile)) {
            return true;
        }
        return sequenceNumber >= child.fSequenceNumber + child.getSequenceLength();
    }

    public void collectMacroExpansions(int offset, int length, ArrayList<IASTPreprocessorMacroExpansion> list) {
        Collection<LocationCtx> children = this.getChildren();
        for (LocationCtx ctx : children) {
            if (ctx.fOffsetInParent >= offset + length) break;
            if (!(ctx instanceof LocationCtxMacroExpansion) || ctx.fEndOffsetInParent <= offset) continue;
            list.add((IASTPreprocessorMacroExpansion)((LocationCtxMacroExpansion)ctx).getMacroReference().getParent());
        }
    }
}

