/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.internal.core.parser.ASTIfConstructNode;
import org.eclipse.photran.internal.core.parser.ASTIfStmtNode;
import org.eclipse.photran.internal.core.parser.ASTNode;
import org.eclipse.photran.internal.core.parser.IExecutionPartConstruct;
import org.eclipse.photran.internal.core.refactoring.Messages;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranEditorRefactoring;
import org.eclipse.photran.internal.core.reindenter.Reindenter;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGRefactoring;

public class IfConstructStatementConversionRefactoring
extends FortranEditorRefactoring {
    private ASTNode selectedNode = null;
    private boolean shouldAddEmptyElseBlock = false;

    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        if (!this.fileInEditor.exists()) {
            this.fail(Messages.FortranEditorRefactoring_CantPerformRefactoringOnFileThatDoesNotExist);
        }
        if (this.fileInEditor.isReadOnly()) {
            this.fail(Messages.FortranEditorRefactoring_CantPerformRefactoringOnReadOnlyFile);
        }
        ASTIfStmtNode ifStmtNode = IfConstructStatementConversionRefactoring.getNode(this.astOfFileInEditor, this.selectedRegionInEditor, ASTIfStmtNode.class);
        ASTIfConstructNode ifConstructNode = IfConstructStatementConversionRefactoring.getNode(this.astOfFileInEditor, this.selectedRegionInEditor, ASTIfConstructNode.class);
        if (ifStmtNode != null) {
            this.selectedNode = ifStmtNode;
        } else if (ifConstructNode != null) {
            this.checkRefactorableConstruct(ifConstructNode);
            this.selectedNode = ifConstructNode;
        } else {
            this.fail(Messages.IfConstructStatementConversionRefactoring_SelectAValidIfStatement);
        }
    }

    private void checkRefactorableConstruct(ASTIfConstructNode ifConstructNode) throws VPGRefactoring.PreconditionFailure {
        if (ifConstructNode.getIfThenStmt().getName() != null) {
            this.fail(Messages.IfConstructStatementConversionRefactoring_InvalidNamedConstruct);
        }
        if (ifConstructNode.getConditionalBody().size() > 1 || ifConstructNode.getElseIfConstruct() != null || ifConstructNode.getElseConstruct() != null) {
            this.fail(Messages.IfConstructStatementConversionRefactoring_TooManyStatements);
        }
    }

    public boolean isStmtNode() {
        return this.selectedNode != null && this.selectedNode instanceof ASTIfStmtNode;
    }

    public void setAddEmptyElseBlock() {
        this.shouldAddEmptyElseBlock = true;
    }

    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
    }

    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.selectedNode instanceof ASTIfStmtNode) {
            this.selectedNode = this.refactorIfStmt();
        } else if (this.selectedNode instanceof ASTIfConstructNode) {
            this.selectedNode = this.refactorIfConstruct();
        } else {
            throw new IllegalStateException();
        }
        Reindenter.reindent(this.selectedNode, this.astOfFileInEditor, Reindenter.Strategy.REINDENT_EACH_LINE);
        this.addChangeFromModifiedAST(this.fileInEditor, pm);
    }

    protected ASTIfConstructNode refactorIfStmt() {
        ASTIfStmtNode ifStmtNode = (ASTIfStmtNode)this.selectedNode;
        ASTIfConstructNode ifConstruct = this.createNewIfConstruct(ifStmtNode);
        ifStmtNode.replaceWith(ifConstruct);
        return ifConstruct;
    }

    protected ASTIfStmtNode refactorIfConstruct() {
        ASTIfConstructNode ifConstructNode = (ASTIfConstructNode)this.selectedNode;
        ASTIfStmtNode ifStmt = this.createNewIfStmt(ifConstructNode);
        ifConstructNode.replaceWith(ifStmt);
        return ifStmt;
    }

    private ASTIfStmtNode createNewIfStmt(ASTIfConstructNode ifConstructNode) {
        StringBuilder sb = new StringBuilder();
        sb.append("    if (");
        sb.append(ifConstructNode.getIfThenStmt().getGuardingExpression().toString().trim());
        sb.append(") ");
        if (!ifConstructNode.getConditionalBody().isEmpty()) {
            IExecutionPartConstruct stmt = (IExecutionPartConstruct)ifConstructNode.getConditionalBody().get(0);
            String leadingComments = stmt.findFirstToken().getWhiteBefore().trim();
            if (!leadingComments.equals("")) {
                sb.append("&\n");
                sb.append(stmt.toString());
            } else {
                sb.append(String.valueOf(stmt.toString().trim()) + "\n");
            }
        }
        ASTIfStmtNode result = (ASTIfStmtNode)IfConstructStatementConversionRefactoring.parseLiteralStatement(sb.toString());
        String trailingComments = ifConstructNode.getEndIfStmt().findFirstToken().getWhiteBefore();
        if (!trailingComments.trim().equals("")) {
            result.findLastToken().setWhiteAfter(String.valueOf(trailingComments) + "\n");
        }
        return result;
    }

    private ASTIfConstructNode createNewIfConstruct(ASTIfStmtNode ifStmtNode) {
        StringBuilder sb = new StringBuilder();
        sb.append("    if (");
        sb.append(ifStmtNode.getGuardingExpression().toString());
        sb.append(") then");
        sb.append("\n        ");
        String actionStmt = ifStmtNode.getActionStmt().toString().trim();
        if (actionStmt.startsWith("&")) {
            actionStmt = actionStmt.substring(1).trim();
        }
        sb.append(actionStmt);
        sb.append("\n        !can add more statements here");
        if (this.shouldAddEmptyElseBlock) {
            sb.append("\n    else");
            sb.append("\n        !can add more statements here");
        }
        sb.append("\n    end if");
        ASTIfConstructNode newIfConstructNode = (ASTIfConstructNode)IfConstructStatementConversionRefactoring.parseLiteralStatement(sb.toString());
        return newIfConstructNode;
    }

    public String getName() {
        return Messages.IfConstructStatementConversionRefactoring_Name;
    }
}

