/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.internal.core;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.IRemoteServicesDescriptor;
import org.eclipse.ptp.remote.core.IRemoteServicesFactory;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.core.messages.Messages;

public class RemoteServicesProxy
implements IRemoteServicesDescriptor {
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_SCHEME = "scheme";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_NEWCONNECTIONS = "newConnections";
    private final IConfigurationElement fConfigElement;
    private final String fId;
    private final String fName;
    private final String fScheme;
    private final boolean fNewConnections;
    private IRemoteServicesFactory fFactory;
    private IRemoteServices fDelegate = null;

    private static boolean getAttribute(IConfigurationElement configElement, String name, boolean defaultValue) {
        String attr = configElement.getAttribute(name);
        if (attr != null) {
            return Boolean.parseBoolean(attr);
        }
        return defaultValue;
    }

    private static String getAttribute(IConfigurationElement configElement, String name, String defaultValue) {
        String value = configElement.getAttribute(name);
        if (value != null) {
            return value;
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.RemoteServicesProxy_0, (Object)name));
    }

    public RemoteServicesProxy(IConfigurationElement configElement) {
        this.fConfigElement = configElement;
        this.fId = RemoteServicesProxy.getAttribute(configElement, ATTR_ID, null);
        this.fName = RemoteServicesProxy.getAttribute(configElement, ATTR_NAME, this.fId);
        this.fScheme = RemoteServicesProxy.getAttribute(configElement, ATTR_SCHEME, null);
        this.fNewConnections = RemoteServicesProxy.getAttribute(configElement, ATTR_NEWCONNECTIONS, false);
        RemoteServicesProxy.getAttribute(configElement, ATTR_CLASS, null);
        this.fFactory = null;
    }

    public boolean canCreateConnections() {
        return this.fNewConnections;
    }

    public IRemoteServicesFactory getFactory() {
        if (this.fFactory != null) {
            return this.fFactory;
        }
        try {
            this.fFactory = (IRemoteServicesFactory)this.fConfigElement.createExecutableExtension(ATTR_CLASS);
        }
        catch (Exception exception) {
            PTPRemoteCorePlugin.log(NLS.bind((String)Messages.RemoteServicesProxy_1, (Object[])new Object[]{this.fConfigElement.getAttribute(ATTR_CLASS), this.fId, this.fConfigElement.getDeclaringExtension().getNamespaceIdentifier()}));
        }
        return this.fFactory;
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }

    public String getScheme() {
        return this.fScheme;
    }

    public IRemoteServices getServices() {
        this.loadServices();
        return this.fDelegate;
    }

    private void loadServices() {
        IRemoteServicesFactory factory;
        if (this.fDelegate == null && (factory = this.getFactory()) != null) {
            this.fDelegate = factory.getServices(this);
        }
    }
}

