/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.wizard;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ptp.remotetools.environment.EnvironmentPlugin;
import org.eclipse.ptp.remotetools.environment.core.ITargetElement;
import org.eclipse.ptp.remotetools.environment.core.TargetElement;
import org.eclipse.ptp.remotetools.environment.core.TargetTypeElement;
import org.eclipse.ptp.remotetools.environment.wizard.AbstractEnvironmentDialogPage;
import org.eclipse.ptp.remotetools.environment.wizard.DialogMessages;
import org.eclipse.ptp.remotetools.utils.verification.ControlAttributes;

public class EnvironmentWizard
extends Wizard {
    TargetTypeElement typeElement;
    ITargetElement targetElement;
    String originalKey = "";
    boolean cancel = false;

    public EnvironmentWizard(TargetTypeElement element) {
        this.typeElement = element;
    }

    public EnvironmentWizard(ITargetElement element) {
        this.typeElement = element.getType();
        this.targetElement = element;
    }

    public void addPages() {
        super.addPages();
        this.setWindowTitle(DialogMessages.getString("EnvironmentWizard.0"));
        if (this.targetElement != null) {
            this.originalKey = this.targetElement.getName();
        }
        AbstractEnvironmentDialogPage page = this.targetElement != null ? this.typeElement.getExtension().dialogPageFactory(this.targetElement) : this.typeElement.getExtension().dialogPageFactory();
        this.addPage((IWizardPage)page);
    }

    public boolean performFinish() {
        if (!this.cancel) {
            AbstractEnvironmentDialogPage page = (AbstractEnvironmentDialogPage)this.getStartingPage();
            ControlAttributes attributes = page.getAttributes();
            if (attributes == null) {
                return false;
            }
            if (this.targetElement == null) {
                String id = EnvironmentPlugin.getDefault().getEnvironmentUniqueID();
                this.typeElement.addElement(new TargetElement(this.typeElement, page.getName(), attributes, id));
            } else {
                this.targetElement.setAttributes(attributes);
                this.targetElement.setName(page.getName());
            }
        }
        return true;
    }

    public boolean performCancel() {
        this.cancel = true;
        return true;
    }

    public boolean canFinish() {
        AbstractEnvironmentDialogPage page = (AbstractEnvironmentDialogPage)this.getStartingPage();
        page.setErrorMessage(null);
        if (!page.getName().equals(this.originalKey)) {
            if (page.getName() != null) {
                if (EnvironmentPlugin.getDefault().getTargetsManager().selectControl(page.getName()) != null) {
                    page.setErrorMessage(DialogMessages.getString("EnvironmentWizard.1"));
                    return false;
                }
            } else {
                page.setErrorMessage(DialogMessages.getString("EnvironmentWizard.2"));
                return false;
            }
        }
        return page.canFinish();
    }
}

