/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.reindenter;

import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.FortranAST;
import org.eclipse.photran.internal.core.analysis.loops.ASTVisitorWithLoops;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.lexer.TokenList;
import org.eclipse.photran.internal.core.reindenter.LineColComputer;
import org.eclipse.photran.internal.core.reindenter.StartOfLine;

abstract class ReindentingVisitor
extends ASTVisitorWithLoops {
    protected final IFortranAST ast;
    protected final Token firstTokenInRegion;
    protected final Token lastTokenInRegion;
    private boolean inFormatRegion = false;
    private Token previousToken = null;

    protected ReindentingVisitor(IFortranAST ast, Token firstTokenInRegion, Token lastTokenInRegion) {
        this.ast = this.recomputeLineColInfo(ast);
        this.lastTokenInRegion = lastTokenInRegion;
        this.firstTokenInRegion = firstTokenInRegion;
    }

    private IFortranAST recomputeLineColInfo(IFortranAST ast) {
        ast.accept(new LineColComputer());
        return new FortranAST(ast.getFile(), ast.getRoot(), new TokenList(ast.getRoot()));
    }

    protected StartOfLine getFirstLineToReindent() {
        if (this.isFirstTokenOnLine(this.firstTokenInRegion)) {
            return StartOfLine.createForLineStartingWith(this.firstTokenInRegion);
        }
        return StartOfLine.createForFirstNonemptyLineBelow(this.firstTokenInRegion, this.ast);
    }

    private boolean isFirstTokenOnLine(Token token) {
        return token == this.ast.findFirstTokenOnLine(token.getLine());
    }

    public void visitToken(Token token) {
        if (token == this.firstTokenInRegion) {
            this.inFormatRegion = true;
        } else if (token == this.lastTokenInRegion) {
            this.inFormatRegion = false;
        }
        if (this.inFormatRegion && (this.previousToken == null || token.getLine() > this.previousToken.getLine())) {
            this.updateIndentation(StartOfLine.createForLineStartingWith(token));
        }
        this.previousToken = token;
    }

    protected abstract void updateIndentation(StartOfLine var1);
}

