/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.core.remotemake;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.utils.EFSExtensionManager;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.rdt.core.RDTLog;
import org.eclipse.ptp.rdt.core.remotemake.RemoteRunSIProvider;
import org.eclipse.ptp.rdt.core.serviceproviders.IRemoteExecutionServiceProvider;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.ServiceModelManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteSpecsRunSIProvider
extends RemoteRunSIProvider {
    public static final String SPECS_FILE_PATH_VAR = "${specs_file_path}";
    public static final String SPECS_FOLDER_NAME = ".specs";
    private static final String EMPTY_STRING = "";

    @Override
    protected List<String> getCommand(IProject project, String providerId, IScannerConfigBuilderInfo2 buildInfo) {
        IFileStore specsFilestore;
        String gcc = buildInfo.getProviderRunCommand(providerId);
        try {
            gcc = ManagedBuildManager.getBuildMacroProvider().resolveValue(gcc, EMPTY_STRING, null, 3, (Object)ManagedBuildManager.getBuildInfo((IResource)project).getDefaultConfiguration());
        }
        catch (BuildMacroException e1) {
            RDTLog.logError(e1);
            return null;
        }
        String args = buildInfo.getProviderRunArguments(providerId);
        String specsFileName = RemoteSpecsRunSIProvider.getSpecsFileName(project);
        if (gcc == null || args == null || specsFileName == null) {
            return null;
        }
        try {
            specsFilestore = RemoteSpecsRunSIProvider.createSpecsFile(project, specsFileName, null);
        }
        catch (CoreException e) {
            RDTLog.logError(e);
            return null;
        }
        catch (IOException e) {
            RDTLog.logError(e);
            return null;
        }
        String specsFilePath = EFSExtensionManager.getDefault().getPathFromURI(specsFilestore.toURI());
        args = args.replace(SPECS_FILE_PATH_VAR, specsFilePath);
        ArrayList<String> command = new ArrayList<String>();
        command.add(gcc);
        String[] stringArray = args.split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            command.add(arg);
            ++n2;
        }
        return command;
    }

    protected static IFileStore createSpecsFile(IProject project, String specsFileName, IProgressMonitor monitor) throws CoreException, IOException {
        ServiceModelManager smm = ServiceModelManager.getInstance();
        IServiceConfiguration serviceConfig = smm.getActiveConfiguration(project);
        IService buildService = smm.getService("org.eclipse.ptp.rdt.core.BuildService");
        IServiceProvider provider = serviceConfig.getServiceProvider(buildService);
        IRemoteExecutionServiceProvider executionProvider = null;
        if (provider instanceof IRemoteExecutionServiceProvider) {
            executionProvider = (IRemoteExecutionServiceProvider)provider;
        }
        if (executionProvider != null) {
            IRemoteConnection connection;
            IRemoteServices remoteServices = executionProvider.getRemoteServices();
            if (remoteServices == null) {
                return null;
            }
            if (!remoteServices.isInitialized()) {
                remoteServices.initialize();
            }
            if (!(connection = executionProvider.getConnection()).isOpen()) {
                try {
                    connection.open(null);
                }
                catch (RemoteConnectionException e) {
                    RDTLog.logError(e);
                }
            }
            IRemoteProcessBuilder processBuilder = remoteServices.getProcessBuilder(connection, new String[]{EMPTY_STRING});
            String configPath = executionProvider.getConfigLocation();
            IRemoteFileManager remoteFileManager = remoteServices.getFileManager(connection);
            IFileStore workingDir = remoteFileManager.getResource(configPath);
            processBuilder.directory(workingDir);
            IFileStore specsFile = workingDir.getChild(specsFileName);
            IFileInfo fileInfo = specsFile.fetchInfo();
            if (!fileInfo.exists()) {
                try {
                    if (!workingDir.fetchInfo().exists()) {
                        workingDir.mkdir(0, monitor);
                    }
                    ByteArrayInputStream is = new ByteArrayInputStream("\n".getBytes());
                    OutputStream os = specsFile.openOutputStream(0, null);
                    int data = ((InputStream)is).read();
                    while (data != -1) {
                        os.write(data);
                        data = ((InputStream)is).read();
                    }
                    ((InputStream)is).close();
                    os.close();
                }
                catch (IOException e) {
                    RDTLog.logError(e);
                }
            }
            return specsFile;
        }
        return null;
    }

    protected static String getSpecsFileName(IProject project) {
        block4: {
            try {
                if (!project.hasNature("org.eclipse.cdt.core.ccnature")) break block4;
                return "specs.cpp";
            }
            catch (CoreException coreException) {}
        }
        if (project.hasNature("org.eclipse.cdt.core.cnature")) {
            return "specs.c";
        }
        return null;
    }

    @Override
    protected IPath getWorkingDirectory(IProject project) {
        ServiceModelManager smm = ServiceModelManager.getInstance();
        IServiceConfiguration serviceConfig = smm.getActiveConfiguration(project);
        IService buildService = smm.getService("org.eclipse.ptp.rdt.core.BuildService");
        IServiceProvider provider = serviceConfig.getServiceProvider(buildService);
        IRemoteExecutionServiceProvider executionProvider = null;
        if (provider instanceof IRemoteExecutionServiceProvider) {
            executionProvider = (IRemoteExecutionServiceProvider)provider;
        }
        if (executionProvider != null) {
            IRemoteConnection connection;
            IRemoteServices remoteServices = executionProvider.getRemoteServices();
            if (remoteServices == null) {
                return null;
            }
            if (!remoteServices.isInitialized()) {
                remoteServices.initialize();
            }
            if (!(connection = executionProvider.getConnection()).isOpen()) {
                try {
                    connection.open(null);
                }
                catch (RemoteConnectionException e) {
                    RDTLog.logError(e);
                }
            }
            IRemoteProcessBuilder processBuilder = remoteServices.getProcessBuilder(connection, new String[]{EMPTY_STRING});
            IFileStore workingDir = processBuilder.directory();
            Path path = new Path(EFSExtensionManager.getDefault().getPathFromURI(workingDir.toURI()));
            return path;
        }
        return null;
    }
}

