/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ui.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ptp.rm.core.rmsystem.IRemoteResourceManagerConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VolatileRemoteResourceManagerConfiguration
implements IRemoteResourceManagerConfiguration {
    public static final String EMPTY_STRING = "";
    public static final String CM = ",";
    private final String name;
    private List<String> options = null;
    private String localAddr = "";
    private int opts = 0;
    private String proxyPath = null;
    private String id;
    private boolean useDefault = false;
    private String connectionName = "";

    public VolatileRemoteResourceManagerConfiguration() {
        this.name = EMPTY_STRING;
    }

    public void addInvocationOptions(String optionString) {
        String[] split;
        if (this.options == null) {
            this.options = new ArrayList<String>();
        }
        String[] stringArray = split = optionString.split(CM);
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.options.add(s);
            ++n2;
        }
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public List<String> getInvocationOptions() {
        return this.options;
    }

    public String getInvocationOptionsStr() {
        StringBuffer b = new StringBuffer();
        int len = this.options.size();
        if (!this.options.isEmpty()) {
            b.append(this.options.get(0));
        }
        int i = 1;
        while (i < len) {
            b.append(CM).append(this.options.get(i));
            ++i;
        }
        return b.toString();
    }

    public String getLocalAddress() {
        return this.localAddr;
    }

    public String getName() {
        return this.name;
    }

    public int getOptions() {
        return 0;
    }

    public String getProxyServerPath() {
        return this.proxyPath;
    }

    public String getRemoteServicesId() {
        return this.id;
    }

    public boolean getUseDefault() {
        return this.useDefault;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public void setInvocationOptions(String optionString) {
        if (this.options != null) {
            this.options.clear();
        }
        this.addInvocationOptions(optionString);
    }

    public void setLocalAddress(String localAddr) {
        this.localAddr = localAddr;
    }

    public void setOptions(int options) {
        this.opts = options;
    }

    public void setProxyServerPath(String proxyServerPath) {
        this.proxyPath = proxyServerPath;
    }

    public void setRemoteServicesId(String id) {
        this.id = id;
    }

    public void setUseDefault(boolean flag) {
        this.useDefault = flag;
    }

    public boolean testOption(int option) {
        return (this.opts | option) == option;
    }
}

