/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.elements.IPQueue;
import org.eclipse.ptp.core.elements.IPResourceManager;
import org.eclipse.ptp.core.events.IJobChangedEvent;
import org.eclipse.ptp.core.listeners.IJobListener;
import org.eclipse.ptp.debug.core.IPDebugConfiguration;
import org.eclipse.ptp.debug.core.IPDebugger;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.launch.IPLaunch;
import org.eclipse.ptp.debug.core.launch.PLaunch;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.launch.PTPLaunchPlugin;
import org.eclipse.ptp.launch.messages.Messages;
import org.eclipse.ptp.launch.rulesengine.ILaunchProcessCallback;
import org.eclipse.ptp.launch.rulesengine.IRuleAction;
import org.eclipse.ptp.launch.rulesengine.ISynchronizationRule;
import org.eclipse.ptp.launch.rulesengine.RuleActionFactory;
import org.eclipse.ptp.launch.rulesengine.RuleFactory;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.rmsystem.IResourceManager;
import org.eclipse.ptp.rmsystem.IResourceManagerComponentConfiguration;
import org.eclipse.ptp.utils.core.ArgumentParser;

public abstract class AbstractParallelLaunchConfigurationDelegate
extends LaunchConfigurationDelegate
implements ILaunchProcessCallback {
    private final IJobListener fJobListener = new JobListener();
    protected Map<String, JobSubmission> jobSubmissions = Collections.synchronizedMap(new HashMap());
    private List<ISynchronizationRule> extraSynchronizationRules;

    protected static String getArguments(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.ARGUMENT_ATTR", null);
    }

    protected static String getDebuggerExePath(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_EXECUTABLE_PATH", null);
    }

    protected static String getDebuggerID(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_ID", null);
    }

    protected static boolean getDebuggerStopInMainFlag(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.STOP_IN_MAIN", false);
    }

    protected static String getDebuggerWorkDirectory(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_WORKING_DIR", null);
    }

    protected static String[] getEnvironmentToAppend(ILaunchConfiguration configuration) throws CoreException {
        Map defaultEnv = null;
        Map configEnv = configuration.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, defaultEnv);
        if (configEnv == null) {
            return null;
        }
        if (!configuration.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true)) {
            throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Parallel_launcher_does_not_support));
        }
        ArrayList<String> strings = new ArrayList<String>(configEnv.size());
        for (Map.Entry entry : configEnv.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            strings.add(String.valueOf(key) + "=" + value);
        }
        return strings.toArray(new String[strings.size()]);
    }

    protected static String getProjectName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.PROJECT_ATTR", null);
    }

    protected static String getQueueName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.QUEUE_NAME", null);
    }

    protected static String getResourceManagerUniqueName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.RESOURCE_MANAGER_NAME", null);
    }

    public void addSynchronizationRule(ISynchronizationRule rule) {
        this.extraSynchronizationRules.add(rule);
    }

    public boolean getCopyExecutable(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.ATTR_COPY_EXECUTABLE_FROM_LOCAL", false);
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return new PLaunch(configuration, mode, null);
    }

    public IRemoteFileManager getLocalFileManager(ILaunchConfiguration configuration) throws CoreException {
        IRemoteServices localServices = PTPRemoteCorePlugin.getDefault().getDefaultServices();
        assert (localServices != null);
        IRemoteConnectionManager lconnMgr = localServices.getConnectionManager();
        assert (lconnMgr != null);
        IRemoteConnection lconn = lconnMgr.getConnection("Local");
        assert (lconn != null);
        IRemoteFileManager localFileManager = localServices.getFileManager(lconn);
        assert (localFileManager != null);
        return localFileManager;
    }

    public IRemoteFileManager getRemoteFileManager(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        IResourceManager rm = this.getResourceManager(configuration);
        if (rm != null) {
            IRemoteConnection rconn;
            IRemoteConnectionManager rconnMgr;
            IResourceManagerComponentConfiguration conf = rm.getControlConfiguration();
            IRemoteServices remoteServices = PTPRemoteCorePlugin.getDefault().getRemoteServices(conf.getRemoteServicesId(), monitor);
            if (remoteServices != null && (rconnMgr = remoteServices.getConnectionManager()) != null && (rconn = rconnMgr.getConnection(conf.getConnectionName())) != null && rconn.isOpen()) {
                return remoteServices.getFileManager(rconn);
            }
        }
        return null;
    }

    protected void copyExecutable(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        boolean copyExecutable = this.getCopyExecutable(configuration);
        if (copyExecutable) {
            String remotePath = this.getExecutablePath(configuration);
            String localPath = configuration.getAttribute("org.eclipse.ptp.launch.ATTR_LOCAL_EXECUTABLE_PATH", null);
            if (localPath == null) {
                throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_1));
            }
            this.copyFileToRemoteHost(localPath, remotePath, configuration, monitor);
        }
    }

    protected void copyFileFromRemoteHost(String remotePath, String localPath, ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)15);
        try {
            IRemoteFileManager localFileManager = this.getLocalFileManager(configuration);
            IRemoteFileManager remoteFileManager = this.getRemoteFileManager(configuration, (IProgressMonitor)progress.newChild(5));
            if (progress.isCanceled()) {
                throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Operation_cancelled_by_user, null));
            }
            if (remoteFileManager == null) {
                throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_0));
            }
            IFileStore rres = remoteFileManager.getResource(remotePath);
            if (!rres.fetchInfo(0, (IProgressMonitor)progress.newChild(5)).exists()) {
                throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Remote_resource_does_not_exist));
            }
            IFileStore lres = localFileManager.getResource(localPath);
            rres.copy(lres, 2, (IProgressMonitor)progress.newChild(5));
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected void copyFileToRemoteHost(String localPath, String remotePath, ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)15);
        try {
            IRemoteFileManager localFileManager = this.getLocalFileManager(configuration);
            IRemoteFileManager remoteFileManager = this.getRemoteFileManager(configuration, (IProgressMonitor)progress.newChild(5));
            if (progress.isCanceled()) {
                throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Operation_cancelled_by_user, null));
            }
            if (remoteFileManager == null) {
                throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_0));
            }
            IFileStore lres = localFileManager.getResource(localPath);
            if (!lres.fetchInfo(0, (IProgressMonitor)progress.newChild(5)).exists()) {
                throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Local_resource_does_not_exist));
            }
            IFileStore rres = remoteFileManager.getResource(remotePath);
            lres.copy(rres, 2, (IProgressMonitor)progress.newChild(5));
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected abstract void doCleanupLaunch(IPLaunch var1);

    protected abstract void doCompleteJobLaunch(IPLaunch var1, IPDebugger var2);

    protected void doPostLaunchSynchronization(ILaunchConfiguration configuration) throws CoreException {
        if (configuration.getAttribute("org.eclipse.ptp.launch.ATTR_SYNC_AFTER", false)) {
            List rulesList = configuration.getAttribute("org.eclipse.ptp.launch.ATTR_SYNC_RULES", new ArrayList());
            RuleActionFactory ruleActFactory = new RuleActionFactory(configuration, this, (IProgressMonitor)new NullProgressMonitor());
            for (Object ruleObj : rulesList) {
                ISynchronizationRule syncRule = RuleFactory.createRuleFromString((String)ruleObj);
                if (!syncRule.isDownloadRule()) continue;
                IRuleAction action = ruleActFactory.getAction(syncRule);
                action.run();
            }
        }
    }

    protected void doPreLaunchSynchronization(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        if (configuration.getAttribute("org.eclipse.ptp.launch.ATTR_SYNC_BEFORE", false)) {
            RuleActionFactory ruleActFactory = new RuleActionFactory(configuration, this, monitor);
            try {
                List rulesList = configuration.getAttribute("org.eclipse.ptp.launch.ATTR_SYNC_RULES", new ArrayList());
                for (Object ruleObj : rulesList) {
                    ISynchronizationRule syncRule = RuleFactory.createRuleFromString((String)ruleObj);
                    if (!syncRule.isUploadRule()) continue;
                    IRuleAction action = ruleActFactory.getAction(syncRule);
                    action.run();
                }
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
    }

    protected void verifyLaunchAttributes(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)30);
        try {
            this.verifyExecutablePath(configuration, (IProgressMonitor)progress.newChild(10));
            String workPath = this.getWorkingDirectory(configuration);
            if (workPath != null) {
                this.verifyResource(workPath, configuration, monitor);
            }
            if (progress.isCanceled()) {
                throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Operation_cancelled_by_user, null));
            }
            if (mode.equals("debug")) {
                this.verifyDebuggerPath(configuration, (IProgressMonitor)progress.newChild(10));
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected IPDebugConfiguration getDebugConfig(ILaunchConfiguration config) throws CoreException {
        return PTPDebugCorePlugin.getDefault().getDebugConfiguration(AbstractParallelLaunchConfigurationDelegate.getDebuggerID(config));
    }

    protected String getExecutablePath(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.ATTR_REMOTE_EXECUTABLE_PATH", null);
    }

    protected String[] getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        ArgumentParser ap;
        List args;
        String temp = AbstractParallelLaunchConfigurationDelegate.getArguments(configuration);
        if (temp != null && temp.length() > 0 && (args = (ap = new ArgumentParser(temp)).getTokenList()) != null) {
            return args.toArray(new String[args.size()]);
        }
        return new String[0];
    }

    protected String getProgramName(ILaunchConfiguration configuration) throws CoreException {
        String exePath = this.getExecutablePath(configuration);
        if (exePath != null) {
            return new Path(exePath).lastSegment();
        }
        return null;
    }

    protected String getProgramPath(ILaunchConfiguration configuration) throws CoreException {
        String exePath = this.getExecutablePath(configuration);
        if (exePath != null) {
            return new Path(exePath).removeLastSegments(1).toString();
        }
        return null;
    }

    protected IProject getProject(String project) {
        return this.getWorkspaceRoot().getProject(project);
    }

    protected IPQueue getQueueDefault(IPResourceManager rm) {
        IPQueue[] queues = rm.getQueues();
        if (queues.length == 0) {
            return null;
        }
        return queues[0];
    }

    protected IResourceManager getResourceManager(ILaunchConfiguration configuration) throws CoreException {
        String rmUniqueName = AbstractParallelLaunchConfigurationDelegate.getResourceManagerUniqueName(configuration);
        if (rmUniqueName != null) {
            return PTPCorePlugin.getDefault().getModelManager().getResourceManagerFromUniqueName(rmUniqueName);
        }
        return null;
    }

    protected ISynchronizationRule[] getSynchronizeRules(ILaunchConfiguration configuration) throws CoreException {
        List ruleStrings = configuration.getAttribute("org.eclipse.ptp.launch.ATTR_SYNC_RULES", new ArrayList());
        ArrayList<ISynchronizationRule> result = new ArrayList<ISynchronizationRule>();
        for (Object ruleObj : ruleStrings) {
            String element = (String)ruleObj;
            try {
                ISynchronizationRule rule = RuleFactory.createRuleFromString(element);
                result.add(rule);
            }
            catch (RuntimeException runtimeException) {
                throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Error_converting_rules));
            }
        }
        return result.toArray(new ISynchronizationRule[result.size()]);
    }

    protected String getWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.WORKING_DIR_ATTR", null);
    }

    protected void setWorkingDirectory(ILaunchConfigurationWorkingCopy configuration, String dir) throws CoreException {
        configuration.setAttribute("org.eclipse.ptp.launch.WORKING_DIR_ATTR", dir);
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected void setDefaultSourceLocator(ILaunch launch, ILaunchConfiguration configuration) throws CoreException {
        if (launch.getSourceLocator() == null) {
            IPersistableSourceLocator sourceLocator;
            String id = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, null);
            if (id == null) {
                sourceLocator = PTPDebugUIPlugin.createDefaultSourceLocator();
                sourceLocator.initializeDefaults(configuration);
            } else {
                sourceLocator = DebugPlugin.getDefault().getLaunchManager().newSourceLocator(id);
                String memento = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
                if (memento == null) {
                    sourceLocator.initializeDefaults(configuration);
                } else {
                    sourceLocator.initializeFromMemento(memento);
                }
            }
            launch.setSourceLocator((ISourceLocator)sourceLocator);
        }
    }

    protected void setSourceLocator(ILaunch launch, ILaunchConfiguration config) throws CoreException {
        this.setDefaultSourceLocator(launch, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void submitJob(ILaunchConfiguration configuration, String mode, IPLaunch launch, IPDebugger debugger, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            IResourceManager rm = this.getResourceManager(configuration);
            if (rm == null) {
                throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_No_ResourceManager));
            }
            rm.addJobListener(this.fJobListener);
            launch.setResourceManager(rm);
            String jobId = rm.submitJob(configuration, mode, (IProgressMonitor)progress.newChild(5));
            if (rm.getJobStatus(jobId, (IProgressMonitor)progress.newChild(50)).equals("UNDETERMINED")) {
                throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_UnableToDetermineJobStatus));
            }
            launch.setJobId(jobId);
            JobSubmission jobSub = new JobSubmission(launch, debugger);
            Map<String, JobSubmission> map = this.jobSubmissions;
            synchronized (map) {
                this.jobSubmissions.put(jobId, jobSub);
            }
            jobSub.schedule();
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected void verifyDebuggerPath(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        String dbgPath = AbstractParallelLaunchConfigurationDelegate.getDebuggerExePath(configuration);
        if (dbgPath == null) {
            throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_debuggerPathNotSpecified));
        }
        try {
            this.verifyResource(dbgPath, configuration, monitor);
            if (monitor.isCanceled()) {
                throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Operation_cancelled_by_user, null));
            }
        }
        catch (CoreException e) {
            throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Debugger_path_not_found, (Throwable)new FileNotFoundException(e.getLocalizedMessage())));
        }
    }

    protected IPath verifyExecutablePath(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        if (this.getCopyExecutable(configuration)) {
            return new Path(this.getExecutablePath(configuration));
        }
        String exePath = this.getExecutablePath(configuration);
        try {
            IPath path = this.verifyResource(exePath, configuration, monitor);
            if (monitor.isCanceled()) {
                throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Operation_cancelled_by_user, null));
            }
            return path;
        }
        catch (CoreException e) {
            throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Application_file_does_not_exist, (Throwable)new FileNotFoundException(e.getLocalizedMessage())));
        }
    }

    protected IProject verifyProject(ILaunchConfiguration configuration) throws CoreException {
        String proName = AbstractParallelLaunchConfigurationDelegate.getProjectName(configuration);
        if (proName == null) {
            throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Project_not_specified));
        }
        IProject project = this.getProject(proName);
        if (project == null || !project.exists() || !project.isOpen()) {
            throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Project_does_not_exist_or_is_not_a_project));
        }
        return project;
    }

    protected IPath verifyResource(String path, ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        return PTPLaunchPlugin.getDefault().verifyResource(path, configuration, monitor);
    }

    protected String verifyWorkDirectory(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        String workPath = this.getWorkingDirectory(configuration);
        IPath path = workPath == null ? this.verifyExecutablePath(configuration, monitor).removeLastSegments(1) : this.verifyResource(workPath, configuration, monitor);
        if (monitor.isCanceled()) {
            throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Operation_cancelled_by_user, null));
        }
        return path.toString();
    }

    static /* synthetic */ IJobListener access$0(AbstractParallelLaunchConfigurationDelegate abstractParallelLaunchConfigurationDelegate) {
        return abstractParallelLaunchConfigurationDelegate.fJobListener;
    }

    private final class JobListener
    implements IJobListener {
        private JobListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(IJobChangedEvent e) {
            JobSubmission jobSub;
            Map<String, JobSubmission> map = AbstractParallelLaunchConfigurationDelegate.this.jobSubmissions;
            synchronized (map) {
                jobSub = AbstractParallelLaunchConfigurationDelegate.this.jobSubmissions.get(e.getJobId());
            }
            if (jobSub != null) {
                jobSub.statusChanged();
            }
        }
    }

    private class JobSubmission
    extends Job {
        private final IPLaunch fLaunch;
        private final IPDebugger fDebugger;
        private final ReentrantLock fSubLock;
        private final Condition fSubCondition;

        public JobSubmission(IPLaunch launch, IPDebugger debugger) {
            super(launch.getJobId());
            this.fSubLock = new ReentrantLock();
            this.fSubCondition = this.fSubLock.newCondition();
            this.fLaunch = launch;
            this.fDebugger = debugger;
            this.setSystem(true);
        }

        public void statusChanged() {
            this.fSubLock.lock();
            try {
                this.fSubCondition.signalAll();
            }
            finally {
                this.fSubLock.unlock();
            }
        }

        /*
         * Exception decompiling
         */
        protected IStatus run(IProgressMonitor monitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[DOLOOP]], but top level block is 24[SIMPLE_IF_TAKEN]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

