/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.openmp.core.editorHelp;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.ptp.pldt.common.editorHelp.CHelpBookImpl;
import org.eclipse.ptp.pldt.common.editorHelp.FunctionPrototypeSummaryImpl;
import org.eclipse.ptp.pldt.common.editorHelp.FunctionSummaryImpl;
import org.eclipse.ptp.pldt.openmp.core.OpenMPPlugin;
import org.eclipse.ptp.pldt.openmp.core.editorHelp.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenMPCHelpBook
extends CHelpBookImpl {
    private static final String TITLE = Messages.OpenMPCHelpBook_omp_c_and_fortran_help_book_title;
    private static final String HTML_DIR = "C:\\ews\\ptpJan06\\org.eclipse.ptp.pldt.openmp.core\\html\\";

    public OpenMPCHelpBook() {
        super(OpenMPPlugin.getPluginId());
        this.funcName2FuncInfo = OpenMPCHelpBook.makeFunctionMap();
        this.setTitle(TITLE);
    }

    private static Map<String, IFunctionSummary> makeFunctionMap() {
        HashMap<String, IFunctionSummary> funcMap = new HashMap<String, IFunctionSummary>();
        funcMap.put("omp_set_num_threads", (IFunctionSummary)new FunctionSummaryImpl("omp_set_num_threads", "", Messages.OpenMPCHelpBook_set_num_threads, (IFunctionSummary.IFunctionPrototypeSummary)new FunctionPrototypeSummaryImpl("omp_set_num_threads", "void", "int num_threads"), null));
        funcMap.put("omp_get_num_threads", (IFunctionSummary)new FunctionSummaryImpl("omp_get_num_threads", "", Messages.OpenMPCHelpBook_get_num_threads, (IFunctionSummary.IFunctionPrototypeSummary)new FunctionPrototypeSummaryImpl("omp_get_num_threads", "int", "int num_threads"), null));
        funcMap.put("omp_get_max_threads", (IFunctionSummary)new FunctionSummaryImpl("omp_get_max_threads", "", Messages.OpenMPCHelpBook_get_max_threads, (IFunctionSummary.IFunctionPrototypeSummary)new FunctionPrototypeSummaryImpl("omp_get_max_threads", "int", "void"), null));
        funcMap.put("omp_get_thread_num", (IFunctionSummary)new FunctionSummaryImpl("get_thread_num", "", Messages.OpenMPCHelpBook_get_thread_num, (IFunctionSummary.IFunctionPrototypeSummary)new FunctionPrototypeSummaryImpl("get_thread_num", "int", "void"), null));
        funcMap.put("omp_get_num_procs", (IFunctionSummary)new FunctionSummaryImpl("get_num_procs", "", Messages.OpenMPCHelpBook_get_num_procs, (IFunctionSummary.IFunctionPrototypeSummary)new FunctionPrototypeSummaryImpl("get_num_procs", "int", "void"), null));
        funcMap.put("omp_in_parallel", (IFunctionSummary)new FunctionSummaryImpl("omp_in_parallel", "", Messages.OpenMPCHelpBook_in_parallel, (IFunctionSummary.IFunctionPrototypeSummary)new FunctionPrototypeSummaryImpl("omp_in_parallel", "int", "void"), null));
        funcMap.put("omp_set_dynamic", (IFunctionSummary)new FunctionSummaryImpl("omp_set_dynamic", "", Messages.OpenMPCHelpBook_set_dynamic, (IFunctionSummary.IFunctionPrototypeSummary)new FunctionPrototypeSummaryImpl("omp_set_dynamic", "void", "int dynamic_threads"), null));
        funcMap.put("omp_get_dynamic", (IFunctionSummary)new FunctionSummaryImpl("omp_get_dynamic", "", Messages.OpenMPCHelpBook_get_dynamic, (IFunctionSummary.IFunctionPrototypeSummary)new FunctionPrototypeSummaryImpl("omp_get_dynamic", "int", "void"), null));
        funcMap.put("omp_set_nested", (IFunctionSummary)new FunctionSummaryImpl("omp_set_nested", "", Messages.OpenMPCHelpBook_set_nested, (IFunctionSummary.IFunctionPrototypeSummary)new FunctionPrototypeSummaryImpl("omp_set_nested", "void", "int nested"), null));
        funcMap.put("omp_get_nested", (IFunctionSummary)new FunctionSummaryImpl("omp_get_nested", "", Messages.OpenMPCHelpBook_get_nested, (IFunctionSummary.IFunctionPrototypeSummary)new FunctionPrototypeSummaryImpl("omp_get_nested", "int", "void"), null));
        funcMap.put("omp_init_lock", (IFunctionSummary)new FunctionSummaryImpl("omp_init_lock", "", Messages.OpenMPCHelpBook_init_lock, (IFunctionSummary.IFunctionPrototypeSummary)new FunctionPrototypeSummaryImpl("omp_init_lock", "void", "omp_lock_t *lock"), null));
        funcMap.put("omp_init_nest_lock", (IFunctionSummary)new FunctionSummaryImpl("omp_init_nest_lock", "", Messages.OpenMPCHelpBook_nest_lock, (IFunctionSummary.IFunctionPrototypeSummary)new FunctionPrototypeSummaryImpl("omp_init_nest_lock", "void", "omp_nest_lock_t *lock"), null));
        funcMap.put("omp_destroy_lock", (IFunctionSummary)new FunctionSummaryImpl("omp_destroy_lock", "", Messages.OpenMPCHelpBook_destroy_lock, (IFunctionSummary.IFunctionPrototypeSummary)new FunctionPrototypeSummaryImpl("omp_destroy_lock", "void", "omp_lock_t *lock"), null));
        funcMap.put("omp_destroy_nest_lock", (IFunctionSummary)new FunctionSummaryImpl("omp_destroy_nest_lock", "", Messages.OpenMPCHelpBook_destroy_nest_lock, (IFunctionSummary.IFunctionPrototypeSummary)new FunctionPrototypeSummaryImpl("omp_destroy_nest_lock", "void", "omp_nest_lock_t *lock"), null));
        funcMap.put("omp_set_lock", (IFunctionSummary)new FunctionSummaryImpl("omp_set_lock", "", Messages.OpenMPCHelpBook_set_lock, (IFunctionSummary.IFunctionPrototypeSummary)new FunctionPrototypeSummaryImpl("omp_set_lock", "void", "omp_lock_t *lock"), null));
        funcMap.put("omp_set_nest_lock", (IFunctionSummary)new FunctionSummaryImpl("omp_set_nest_lock", "", Messages.OpenMPCHelpBook_set_nest_lock, (IFunctionSummary.IFunctionPrototypeSummary)new FunctionPrototypeSummaryImpl("omp_set_nest_lock", "void", "omp_nest_lock_t *lock"), null));
        funcMap.put("omp_test_lock", (IFunctionSummary)new FunctionSummaryImpl("omp_test_lock", "", Messages.OpenMPCHelpBook_test_lock, (IFunctionSummary.IFunctionPrototypeSummary)new FunctionPrototypeSummaryImpl("omp_test_lock", "int", "omp_lock_t *lock2"), null));
        funcMap.put("omp_test_nest_lock", (IFunctionSummary)new FunctionSummaryImpl("omp_test_nest_lock", "", Messages.OpenMPCHelpBook_test_nest_lock, (IFunctionSummary.IFunctionPrototypeSummary)new FunctionPrototypeSummaryImpl("omp_test_nest_lock", "int", "omp_nest_lock_t *lock"), null));
        funcMap.put("omp_unset_lock", (IFunctionSummary)new FunctionSummaryImpl("omp_unset_lock", "", Messages.OpenMPCHelpBook_unset_lock, (IFunctionSummary.IFunctionPrototypeSummary)new FunctionPrototypeSummaryImpl("omp_unset_lock", "void", "omp_lock_t *lock"), null));
        funcMap.put("omp_unset_nest_lock", (IFunctionSummary)new FunctionSummaryImpl("omp_unset_nest_lock", "", Messages.OpenMPCHelpBook_unset_nest_lock, (IFunctionSummary.IFunctionPrototypeSummary)new FunctionPrototypeSummaryImpl("omp_unset_nest_lock", "void", "omp_nest_lock_t *lock"), null));
        funcMap.put("omp_get_wtime", (IFunctionSummary)new FunctionSummaryImpl("omp_get_wtime", "", Messages.OpenMPCHelpBook_get_wtime, (IFunctionSummary.IFunctionPrototypeSummary)new FunctionPrototypeSummaryImpl("omp_get_wtime", "double", "void"), null));
        funcMap.put("omp_get_wtick", (IFunctionSummary)new FunctionSummaryImpl("omp_get_wtick", "", Messages.OpenMPCHelpBook_get_wtick, (IFunctionSummary.IFunctionPrototypeSummary)new FunctionPrototypeSummaryImpl("omp_get_wtick", "double", "void"), null));
        return funcMap;
    }

    public static void generateHTML(Map fMap) {
        int count = 0;
        Collection fColl = fMap.values();
        for (FunctionSummaryImpl fsi : fColl) {
            IFunctionSummary.IFunctionPrototypeSummary fspi = fsi.getPrototype();
            fspi.getPrototypeString(false);
            fspi.getArguments();
            fspi.getReturnType();
            if (fsi == null) continue;
            PrintStream html = null;
            String filename = HTML_DIR + fsi.getName() + ".html";
            try {
                try {
                    html = new PrintStream(new FileOutputStream(filename));
                    html.print("<html><head><title>");
                    html.print(fsi.getName());
                    html.println("</title>");
                    html.println("<body>");
                    html.print("<H3>");
                    html.print(fsi.getName());
                    html.println("</H3>");
                    html.println("<PRE>");
                    html.println(fspi.getPrototypeString(false));
                    html.println("</PRE>");
                    html.println("<DL><DD>");
                    html.println(fsi.getDescription());
                    html.println("<P></DL></body></html>");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (html != null) {
                        html.close();
                    }
                    System.out.println("wrote " + filename);
                    ++count;
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (html != null) {
                    html.close();
                }
                System.out.println("wrote " + filename);
                ++count;
                throw throwable;
            }
            if (html != null) {
                html.close();
            }
            System.out.println("wrote " + filename);
            ++count;
        }
        System.out.println("Wrote " + count + " html files.");
    }

    public static void main(String[] args) {
        Map<String, IFunctionSummary> map = OpenMPCHelpBook.makeFunctionMap();
        OpenMPCHelpBook.generateHTML(map);
    }
}

