/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.rdt.sync.ui.ISynchronizeParticipant;
import org.eclipse.ptp.rdt.sync.ui.ISynchronizeParticipantDescriptor;
import org.eclipse.ptp.rdt.sync.ui.RDTSyncUIPlugin;
import org.eclipse.ptp.rdt.sync.ui.messages.Messages;

public class SynchronizeParticipantDescriptor
implements ISynchronizeParticipantDescriptor {
    public static final String ATTR_ID = "id";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_CLASS = "class";
    private final String fName;
    private final String fId;
    private ISynchronizeParticipant fParticipant;

    public SynchronizeParticipantDescriptor(IConfigurationElement configElement) {
        this.fId = configElement.getAttribute(ATTR_ID);
        this.fName = configElement.getAttribute(ATTR_NAME);
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }

    public ISynchronizeParticipant getParticipant() {
        if (this.fParticipant == null) {
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ptp.rdt.sync.ui", "synchronizeParticipants");
            if (point != null) {
                IExtension[] iExtensionArray = point.getExtensions();
                int n = iExtensionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension extension = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement configElement = iConfigurationElementArray[n4];
                        String extensionId = configElement.getAttribute(ATTR_ID);
                        if (extensionId != null && extensionId.equals(this.fId)) {
                            try {
                                this.fParticipant = (ISynchronizeParticipant)configElement.createExecutableExtension(ATTR_CLASS);
                                return this.fParticipant;
                            }
                            catch (CoreException e) {
                                RDTSyncUIPlugin.log(e);
                            }
                            catch (ClassCastException e) {
                                String className = configElement.getAttribute(ATTR_CLASS);
                                RDTSyncUIPlugin.log(NLS.bind((String)Messages.SynchronizeParticipantDescriptor_invalidClass, (Object[])new String[]{className, this.fId}), e);
                            }
                            return null;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            return null;
        }
        return this.fParticipant;
    }
}

