/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.ui;

import java.util.EnumSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.ptp.rdt.sync.core.RDTSyncCorePlugin;
import org.eclipse.ptp.rdt.sync.core.SyncExceptionHandler;
import org.eclipse.ptp.rdt.sync.core.SyncFlag;
import org.eclipse.ptp.rdt.sync.core.SyncManager;
import org.eclipse.ptp.rdt.sync.core.resources.RemoteSyncNature;
import org.eclipse.ptp.rdt.sync.core.serviceproviders.ISyncServiceProvider;
import org.eclipse.ptp.rdt.sync.ui.RDTSyncUIPlugin;
import org.eclipse.ptp.rdt.sync.ui.messages.Messages;
import org.eclipse.swt.widgets.Display;

public class ResourceChangeListener {
    private static IResourceChangeListener resourceListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() == 4) {
                IProject project = (IProject)event.getResource();
                SyncManager.setSyncMode((IProject)project, (SyncManager.SYNC_MODE)SyncManager.SYNC_MODE.NONE);
                ISyncServiceProvider provider = SyncManager.getSyncProvider((IProject)project);
                provider.close();
                return;
            }
            IResourceDelta[] iResourceDeltaArray = event.getDelta().getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta delta = iResourceDeltaArray[n2];
                IProject project = delta.getResource().getProject();
                if (project == null) {
                    return;
                }
                if (RemoteSyncNature.hasNature((IProject)project)) {
                    SyncManager.SYNC_MODE syncMode = SyncManager.getSyncMode((IProject)project);
                    boolean syncEnabled = true;
                    if (!SyncManager.getSyncAuto() || syncMode == SyncManager.SYNC_MODE.NONE) {
                        syncEnabled = false;
                    }
                    try {
                        if (event.getType() == 16) {
                            if (syncEnabled) {
                                if (syncMode == SyncManager.SYNC_MODE.ALL) {
                                    SyncManager.syncAll(null, (IProject)project, (EnumSet)SyncFlag.FORCE, (SyncExceptionHandler)new SyncRCLExceptionHandler(project));
                                } else if (syncMode == SyncManager.SYNC_MODE.ACTIVE) {
                                    SyncManager.sync(null, (IProject)project, (EnumSet)SyncFlag.FORCE, (SyncExceptionHandler)new SyncRCLExceptionHandler(project));
                                }
                            }
                        } else if (!syncEnabled) {
                            SyncManager.sync((IResourceDelta)delta, (IProject)project, (EnumSet)SyncFlag.NO_SYNC, null);
                        } else if (syncMode == SyncManager.SYNC_MODE.ALL) {
                            SyncManager.syncAll((IResourceDelta)delta, (IProject)project, (EnumSet)SyncFlag.NO_FORCE, (SyncExceptionHandler)new SyncRCLExceptionHandler(project));
                        } else if (syncMode == SyncManager.SYNC_MODE.ACTIVE) {
                            SyncManager.sync((IResourceDelta)delta, (IProject)project, (EnumSet)SyncFlag.NO_FORCE, (SyncExceptionHandler)new SyncRCLExceptionHandler(project));
                        }
                    }
                    catch (CoreException coreException) {
                        RDTSyncCorePlugin.log((String)Messages.ResourceChangeListener_0);
                    }
                }
                ++n2;
            }
        }
    };

    private ResourceChangeListener() {
    }

    public static void startListening() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(resourceListener, 21);
    }

    public static void stopListening() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(resourceListener);
    }

    private static class SyncRCLExceptionHandler
    implements SyncExceptionHandler {
        private final IProject project;

        public SyncRCLExceptionHandler(IProject p) {
            this.project = p;
        }

        public void handle(CoreException e) {
            if (!SyncManager.getShowErrors((IProject)this.project)) {
                return;
            }
            String endOfLineChar = System.getProperty("line.separator");
            Display errorDisplay = RDTSyncUIPlugin.getStandardDisplay();
            String message = String.valueOf(Messages.SyncMenuOperation_5) + this.project.getName() + ":" + endOfLineChar + endOfLineChar;
            message = e.getMessage() != null && e.getMessage().length() > 0 || e.getCause() == null ? String.valueOf(message) + e.getMessage() : String.valueOf(message) + e.getCause().getMessage();
            final String finalMessage = message;
            errorDisplay.syncExec(new Runnable(){

                public void run() {
                    MessageDialogWithToggle dialog = MessageDialogWithToggle.openError(null, (String)Messages.SyncMenuOperation_3, (String)finalMessage, (String)Messages.SyncMenuOperation_4, (!SyncManager.getShowErrors((IProject)SyncRCLExceptionHandler.this.project) ? 1 : 0) != 0, null, null);
                    if (dialog.getToggleState()) {
                        SyncManager.setShowErrors((IProject)SyncRCLExceptionHandler.this.project, (boolean)false);
                    } else {
                        SyncManager.setShowErrors((IProject)SyncRCLExceptionHandler.this.project, (boolean)true);
                    }
                }
            });
        }
    }
}

