/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTImplicitName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownClass;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Conversions;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExpressionTypes;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class CPPASTArraySubscriptExpression
extends ASTNode
implements ICPPASTArraySubscriptExpression,
IASTAmbiguityParent {
    private IASTExpression arrayExpression;
    private IASTInitializerClause subscriptExp;
    private ICPPFunction overload = UNINITIALIZED_FUNCTION;
    private IASTImplicitName[] implicitNames = null;

    public CPPASTArraySubscriptExpression() {
    }

    public CPPASTArraySubscriptExpression(IASTExpression arrayExpression, IASTInitializerClause operand) {
        this.setArrayExpression(arrayExpression);
        this.setArgument(operand);
    }

    public CPPASTArraySubscriptExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    public CPPASTArraySubscriptExpression copy(IASTNode.CopyStyle style) {
        CPPASTArraySubscriptExpression copy = new CPPASTArraySubscriptExpression();
        copy.setArrayExpression(this.arrayExpression == null ? null : this.arrayExpression.copy(style));
        copy.setArgument(this.subscriptExp == null ? null : this.subscriptExp.copy(style));
        copy.setOffsetAndLength(this);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    public IASTExpression getArrayExpression() {
        return this.arrayExpression;
    }

    public void setArrayExpression(IASTExpression expression) {
        this.assertNotFrozen();
        this.arrayExpression = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(ARRAY);
        }
    }

    public IASTInitializerClause getArgument() {
        return this.subscriptExp;
    }

    public void setArgument(IASTInitializerClause arg) {
        this.assertNotFrozen();
        this.subscriptExp = arg;
        if (arg != null) {
            arg.setParent(this);
            arg.setPropertyInParent(SUBSCRIPT);
        }
    }

    @Deprecated
    public IASTExpression getSubscriptExpression() {
        if (this.subscriptExp instanceof IASTExpression) {
            return (IASTExpression)this.subscriptExp;
        }
        return null;
    }

    @Deprecated
    public void setSubscriptExpression(IASTExpression expression) {
        this.setArgument(expression);
    }

    public IASTImplicitName[] getImplicitNames() {
        if (this.implicitNames == null) {
            ICPPFunction overload = this.getOverload();
            if (overload == null || overload instanceof CPPImplicitFunction) {
                this.implicitNames = IASTImplicitName.EMPTY_NAME_ARRAY;
                return IASTImplicitName.EMPTY_NAME_ARRAY;
            }
            CPPASTImplicitName n1 = new CPPASTImplicitName(OverloadableOperator.BRACKET, (IASTNode)this);
            n1.setBinding(overload);
            n1.computeOperatorOffsets(this.arrayExpression, true);
            CPPASTImplicitName n2 = new CPPASTImplicitName(OverloadableOperator.BRACKET, (IASTNode)this);
            n2.setBinding(overload);
            n2.computeOperatorOffsets(this.subscriptExp, true);
            n2.setAlternate(true);
            this.implicitNames = new IASTImplicitName[]{n1, n2};
        }
        return this.implicitNames;
    }

    public ICPPFunction getOverload() {
        if (this.overload == UNINITIALIZED_FUNCTION) {
            this.overload = null;
            IType t = this.getArrayExpression().getExpressionType();
            if ((t = SemanticUtil.getNestedType(t, 7)) instanceof ICPPClassType) {
                this.overload = CPPSemantics.findOverloadedOperator(this);
            }
        }
        return this.overload;
    }

    public boolean accept(ASTVisitor action) {
        IASTImplicitName[] implicits;
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.arrayExpression != null && !this.arrayExpression.accept(action)) {
            return false;
        }
        IASTImplicitName[] iASTImplicitNameArray = implicits = action.shouldVisitImplicitNames ? this.getImplicitNames() : null;
        if (implicits != null && implicits.length > 0 && !implicits[0].accept(action)) {
            return false;
        }
        if (this.subscriptExp != null && !this.subscriptExp.accept(action)) {
            return false;
        }
        if (implicits != null && implicits.length > 0 && !implicits[1].accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.subscriptExp) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.subscriptExp = (IASTExpression)other;
        }
        if (child == this.arrayExpression) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.arrayExpression = (IASTExpression)other;
        }
    }

    public IType getExpressionType() {
        ICPPFunction op = this.getOverload();
        if (op != null) {
            return ExpressionTypes.typeFromFunctionCall(op);
        }
        IType t1 = this.getArrayExpression().getExpressionType();
        if ((t1 = Conversions.lvalue_to_rvalue(t1)) instanceof IPointerType) {
            t1 = ((IPointerType)t1).getType();
            return ExpressionTypes.glvalueType(t1);
        }
        IType t2 = null;
        IASTInitializerClause arg = this.getArgument();
        if (arg instanceof IASTExpression && (t2 = Conversions.lvalue_to_rvalue(t2)) instanceof IPointerType) {
            t2 = ((IPointerType)t2).getType();
            return ExpressionTypes.glvalueType(t2);
        }
        if (t1 instanceof ICPPUnknownType || t2 instanceof ICPPUnknownType) {
            return CPPUnknownClass.createUnnamedInstance();
        }
        return new ProblemType(10004);
    }

    public boolean isLValue() {
        return this.getValueCategory() == IASTExpression.ValueCategory.LVALUE;
    }

    public IASTExpression.ValueCategory getValueCategory() {
        ICPPFunction op = this.getOverload();
        if (op != null) {
            return ExpressionTypes.valueCategoryFromFunctionCall(op);
        }
        return IASTExpression.ValueCategory.LVALUE;
    }
}

