/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPArgumentList;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPFunctionSpecialization;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPTypeList;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPFunctionInstance
extends PDOMCPPFunctionSpecialization
implements ICPPTemplateInstance {
    private static final int ARGUMENTS = 64;
    private static final int EXCEPTION_SPEC = 68;
    protected static final int RECORD_SIZE = 72;

    public PDOMCPPFunctionInstance(PDOMLinkage linkage, PDOMNode parent, ICPPFunction function, PDOMBinding orig) throws CoreException {
        super(linkage, parent, function, orig);
        ICPPTemplateInstance asInstance = (ICPPTemplateInstance)((Object)function);
        long argListRec = PDOMCPPArgumentList.putArguments(this, asInstance.getTemplateArguments());
        Database db = this.getDB();
        db.putRecPtr(this.record + 64L, argListRec);
        long exceptSpecRec = PDOMCPPTypeList.putTypes(this, function.getExceptionSpecification());
        db.putRecPtr(this.record + 68L, exceptSpecRec);
    }

    public PDOMCPPFunctionInstance(PDOMLinkage linkage, long bindingRecord) {
        super(linkage, bindingRecord);
    }

    protected int getRecordSize() {
        return 72;
    }

    public int getNodeType() {
        return 26;
    }

    public ICPPTemplateDefinition getTemplateDefinition() {
        return (ICPPTemplateDefinition)this.getSpecializedBinding();
    }

    public boolean isExplicitSpecialization() {
        try {
            return this.hasDefinition();
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public ICPPTemplateArgument[] getTemplateArguments() {
        try {
            long rec = this.getPDOM().getDB().getRecPtr(this.record + 64L);
            return PDOMCPPArgumentList.getArguments(this, rec);
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return ICPPTemplateArgument.EMPTY_ARGUMENTS;
        }
    }

    public IType[] getExceptionSpecification() {
        try {
            long rec = this.getPDOM().getDB().getRecPtr(this.record + 68L);
            return PDOMCPPTypeList.getTypes(this, rec);
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return null;
        }
    }

    @Deprecated
    public IType[] getArguments() {
        return CPPTemplates.getArguments(this.getTemplateArguments());
    }
}

