/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.lrparser.action.c99;

import java.util.Collections;
import java.util.List;
import lpg.lpgjavaruntime.IToken;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerList;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.INodeFactory;
import org.eclipse.cdt.core.dom.ast.c.ICASTArrayDesignator;
import org.eclipse.cdt.core.dom.ast.c.ICASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignatedInitializer;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignator;
import org.eclipse.cdt.core.dom.ast.c.ICASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTFieldDesignator;
import org.eclipse.cdt.core.dom.ast.c.ICASTPointer;
import org.eclipse.cdt.core.dom.ast.c.ICASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTTypeIdInitializerExpression;
import org.eclipse.cdt.core.dom.ast.c.ICASTTypedefNameSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICNodeFactory;
import org.eclipse.cdt.core.dom.ast.gnu.c.ICASTKnRFunctionDeclarator;
import org.eclipse.cdt.core.dom.lrparser.action.BuildASTParserAction;
import org.eclipse.cdt.core.dom.lrparser.action.ISecondaryParserFactory;
import org.eclipse.cdt.core.dom.lrparser.action.ITokenMap;
import org.eclipse.cdt.core.dom.lrparser.action.ITokenStream;
import org.eclipse.cdt.core.dom.lrparser.action.ParserUtil;
import org.eclipse.cdt.core.dom.lrparser.action.ScopedStack;
import org.eclipse.cdt.core.dom.lrparser.action.TokenMap;
import org.eclipse.cdt.core.parser.util.CollectionUtils;
import org.eclipse.cdt.internal.core.dom.lrparser.c99.C99Parsersym;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousExpression;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousStatement;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTAmbiguousExpression;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTAmbiguousStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class C99BuildASTParserAction
extends BuildASTParserAction {
    private final ITokenMap tokenMap;
    protected final ICNodeFactory nodeFactory;

    public C99BuildASTParserAction(ITokenStream parser, ScopedStack<Object> astStack, ICNodeFactory nodeFactory, ISecondaryParserFactory parserFactory) {
        super(parser, astStack, (INodeFactory)nodeFactory, parserFactory);
        this.nodeFactory = nodeFactory;
        this.tokenMap = new TokenMap(C99Parsersym.orderedTerminalSymbols, parser.getOrderedTerminalSymbols());
    }

    private int baseKind(IToken token) {
        return this.tokenMap.mapKind(token.getKind());
    }

    @Override
    protected boolean isCompletionToken(IToken token) {
        return this.baseKind(token) == 3;
    }

    @Override
    protected boolean isIdentifierToken(IToken token) {
        return this.baseKind(token) == 1;
    }

    @Override
    protected IASTName createName(char[] image) {
        return this.nodeFactory.newName(image);
    }

    public void consumeExpressionFieldReference(boolean isPointerDereference) {
        IASTName name = this.createName(this.stream.getRightIToken());
        IASTExpression owner = (IASTExpression)this.astStack.pop();
        IASTFieldReference expr = this.nodeFactory.newFieldReference(name, owner);
        expr.setIsPointerDereference(isPointerDereference);
        this.setOffsetAndLength((IASTNode)expr);
        this.astStack.push(expr);
    }

    public void consumeExpressionTypeIdInitializer() {
        IASTInitializerList list = (IASTInitializerList)this.astStack.pop();
        IASTTypeId typeId = (IASTTypeId)this.astStack.pop();
        ICASTTypeIdInitializerExpression expr = this.nodeFactory.newTypeIdInitializerExpression(typeId, (IASTInitializer)list);
        this.setOffsetAndLength((IASTNode)expr);
        this.astStack.push(expr);
    }

    public void setSpecifier(ICASTDeclSpecifier node, Object specifier) {
        if (!(specifier instanceof IToken)) {
            return;
        }
        IToken token = (IToken)specifier;
        int kind = this.baseKind(token);
        switch (kind) {
            case 29: {
                node.setStorageClass(1);
                return;
            }
            case 26: {
                node.setStorageClass(2);
                return;
            }
            case 23: {
                node.setStorageClass(3);
                return;
            }
            case 25: {
                node.setStorageClass(4);
                return;
            }
            case 28: {
                node.setStorageClass(5);
                return;
            }
            case 27: {
                node.setInline(true);
                return;
            }
            case 19: {
                node.setConst(true);
                return;
            }
            case 20: {
                node.setRestrict(true);
                return;
            }
            case 21: {
                node.setVolatile(true);
                return;
            }
        }
        if (node instanceof ICASTSimpleDeclSpecifier) {
            ICASTSimpleDeclSpecifier n = (ICASTSimpleDeclSpecifier)node;
            switch (kind) {
                case 49: {
                    n.setType(1);
                    break;
                }
                case 41: {
                    n.setType(2);
                    break;
                }
                case 50: {
                    n.setType(6);
                    break;
                }
                case 44: {
                    n.setType(3);
                    break;
                }
                case 43: {
                    n.setType(4);
                    break;
                }
                case 42: {
                    n.setType(5);
                    break;
                }
                case 47: {
                    n.setSigned(true);
                    break;
                }
                case 48: {
                    n.setUnsigned(true);
                    break;
                }
                case 46: {
                    n.setShort(true);
                    break;
                }
                case 51: {
                    n.setComplex(true);
                    break;
                }
                case 45: {
                    boolean isLong = n.isLong();
                    n.setLongLong(isLong);
                    n.setLong(!isLong);
                }
            }
        }
    }

    private void collectArrayModifierTypeQualifiers(ICASTArrayModifier arrayModifier) {
        for (Object o : this.astStack.closeScope()) {
            switch (this.baseKind((IToken)o)) {
                case 19: {
                    arrayModifier.setConst(true);
                    break;
                }
                case 20: {
                    arrayModifier.setRestrict(true);
                    break;
                }
                case 21: {
                    arrayModifier.setVolatile(true);
                }
            }
        }
    }

    public void consumeDirectDeclaratorModifiedArrayModifier(boolean isStatic, boolean isVarSized, boolean hasTypeQualifierList, boolean hasAssignmentExpr) {
        assert (isStatic || isVarSized || hasTypeQualifierList);
        ICASTArrayModifier arrayModifier = this.nodeFactory.newArrayModifier(null);
        arrayModifier.setStatic(isStatic);
        arrayModifier.setVariableSized(isVarSized);
        if (hasAssignmentExpr) {
            arrayModifier.setConstantExpression((IASTExpression)this.astStack.pop());
        }
        if (hasTypeQualifierList) {
            this.collectArrayModifierTypeQualifiers(arrayModifier);
        }
        this.setOffsetAndLength((IASTNode)arrayModifier);
        this.astStack.push(arrayModifier);
    }

    public void consumeDirectDeclaratorFunctionDeclaratorKnR() {
        ICASTKnRFunctionDeclarator declarator = this.nodeFactory.newKnRFunctionDeclarator(null, null);
        IASTName[] names = this.astStack.topScope().toArray(new IASTName[0]);
        declarator.setParameterNames(names);
        this.astStack.closeScope();
        int endOffset = ParserUtil.endOffset(this.stream.getRightIToken());
        this.addFunctionModifier((IASTFunctionDeclarator)declarator, endOffset);
    }

    public void consumeIdentifierKnR() {
        IASTName name = this.createName(this.stream.getRightIToken());
        this.astStack.push(name);
    }

    public void consumePointer() {
        ICASTPointer pointer = this.nodeFactory.newPointer();
        IToken star = this.stream.getRightIToken();
        ParserUtil.setOffsetAndLength((IASTNode)pointer, star);
        this.astStack.push(pointer);
    }

    public void consumePointerTypeQualifierList() {
        ICASTPointer pointer = this.nodeFactory.newPointer();
        for (Object o : this.astStack.closeScope()) {
            IToken token = (IToken)o;
            switch (this.baseKind(token)) {
                default: {
                    assert (false);
                }
                case 19: {
                    pointer.setConst(true);
                    break;
                }
                case 21: {
                    pointer.setVolatile(true);
                    break;
                }
                case 20: {
                    pointer.setRestrict(true);
                }
            }
        }
        this.setOffsetAndLength((IASTNode)pointer);
        this.astStack.push(pointer);
    }

    public void consumeDirectDeclaratorFunctionDeclarator(boolean hasDeclarator, boolean hasParameters) {
        IASTName name = this.nodeFactory.newName();
        IASTStandardFunctionDeclarator declarator = this.nodeFactory.newFunctionDeclarator(name);
        if (hasParameters) {
            boolean isVarArgs = this.astStack.pop() == PLACE_HOLDER;
            declarator.setVarArgs(isVarArgs);
            for (Object param : this.astStack.closeScope()) {
                declarator.addParameterDeclaration((IASTParameterDeclaration)param);
            }
        }
        if (hasDeclarator) {
            this.addFunctionModifier((IASTFunctionDeclarator)declarator, ParserUtil.endOffset(this.stream.getRightIToken()));
        } else {
            this.setOffsetAndLength((IASTNode)declarator);
            this.astStack.push(declarator);
        }
    }

    public void consumeInitializerDesignated() {
        IASTInitializer initializer = (IASTInitializer)this.astStack.pop();
        ICASTDesignatedInitializer result = this.nodeFactory.newDesignatedInitializer(initializer);
        for (Object o : this.astStack.closeScope()) {
            result.addDesignator((ICASTDesignator)o);
        }
        this.setOffsetAndLength((IASTNode)result);
        this.astStack.push(result);
    }

    public void consumeDesignatorArray() {
        IASTExpression expr = (IASTExpression)this.astStack.pop();
        ICASTArrayDesignator designator = this.nodeFactory.newArrayDesignator(expr);
        this.setOffsetAndLength((IASTNode)designator);
        this.astStack.push(designator);
    }

    public void consumeDesignatorField() {
        IASTName name = this.createName(this.stream.getRightIToken());
        ICASTFieldDesignator designator = this.nodeFactory.newFieldDesignator(name);
        this.setOffsetAndLength((IASTNode)designator);
        this.astStack.push(designator);
    }

    public void consumeDeclarationSpecifiersSimple() {
        ICASTSimpleDeclSpecifier declSpec = this.nodeFactory.newSimpleDeclSpecifier();
        for (Object specifier : this.astStack.closeScope()) {
            this.setSpecifier((ICASTDeclSpecifier)declSpec, specifier);
        }
        this.setOffsetAndLength((IASTNode)declSpec);
        this.astStack.push(declSpec);
    }

    public void consumeDeclarationSpecifiersStructUnionEnum() {
        List topScope = this.astStack.closeScope();
        ICASTDeclSpecifier declSpec = (ICASTDeclSpecifier)CollectionUtils.findFirstAndRemove(topScope, ICASTDeclSpecifier.class);
        for (Object specifier : topScope) {
            this.setSpecifier(declSpec, specifier);
        }
        this.setOffsetAndLength((IASTNode)declSpec);
        this.astStack.push(declSpec);
    }

    public void consumeDeclarationSpecifiersTypedefName() {
        ICASTTypedefNameSpecifier declSpec = this.nodeFactory.newTypedefNameSpecifier(null);
        for (Object o : this.astStack.topScope()) {
            if (!(o instanceof IToken)) continue;
            IToken token = (IToken)o;
            int kind = this.baseKind(token);
            if (kind == 1 || kind == 3) {
                IASTName name = this.createName(token);
                declSpec.setName(name);
                continue;
            }
            this.setSpecifier((ICASTDeclSpecifier)declSpec, token);
        }
        this.astStack.closeScope();
        this.setOffsetAndLength((IASTNode)declSpec);
        this.astStack.push(declSpec);
    }

    public void consumeDeclarationSimple(boolean hasDeclaratorList) {
        List declarators = hasDeclaratorList ? this.astStack.closeScope() : Collections.emptyList();
        IASTDeclSpecifier declSpecifier = (IASTDeclSpecifier)this.astStack.pop();
        List<IToken> ruleTokens = this.stream.getRuleTokens();
        if (ruleTokens.size() == 1 && this.baseKind(ruleTokens.get(0)) == 4) {
            return;
        }
        IASTSimpleDeclaration declaration = this.nodeFactory.newSimpleDeclaration(declSpecifier);
        for (Object declarator : declarators) {
            declaration.addDeclarator((IASTDeclarator)declarator);
        }
        this.setOffsetAndLength((IASTNode)declaration);
        this.astStack.push(declaration);
    }

    public void consumeDeclarationEmpty() {
        if (this.baseKind(this.stream.getLeftIToken()) == 4) {
            return;
        }
        ICASTSimpleDeclSpecifier declSpecifier = this.nodeFactory.newSimpleDeclSpecifier();
        IASTSimpleDeclaration declaration = this.nodeFactory.newSimpleDeclaration((IASTDeclSpecifier)declSpecifier);
        this.setOffsetAndLength((IASTNode)declSpecifier);
        this.setOffsetAndLength((IASTNode)declaration);
        this.astStack.push(declaration);
    }

    public void consumeStructDeclaration(boolean hasDeclaration) {
        this.consumeDeclarationSimple(hasDeclaration);
    }

    public void consumeTypeSpecifierComposite(boolean hasName) {
        int key = 0;
        switch (this.baseKind(this.stream.getLeftIToken())) {
            case 55: {
                key = 1;
            }
            case 56: {
                key = 2;
            }
        }
        IASTName name = hasName ? this.createName(this.stream.getRuleTokens().get(1)) : this.nodeFactory.newName();
        ICASTCompositeTypeSpecifier typeSpec = this.nodeFactory.newCompositeTypeSpecifier(key, name);
        for (Object o : this.astStack.closeScope()) {
            typeSpec.addMemberDeclaration((IASTDeclaration)o);
        }
        this.setOffsetAndLength((IASTNode)typeSpec);
        this.astStack.push(typeSpec);
    }

    public void consumeTypeSpecifierElaborated(int kind) {
        IASTName name = this.createName(this.stream.getRuleTokens().get(1));
        ICASTElaboratedTypeSpecifier typeSpec = this.nodeFactory.newElaboratedTypeSpecifier(kind, name);
        this.setOffsetAndLength((IASTNode)typeSpec);
        this.astStack.push(typeSpec);
    }

    public void consumeStatementWhileLoop() {
        IASTStatement body = (IASTStatement)this.astStack.pop();
        IASTExpression condition = (IASTExpression)this.astStack.pop();
        IASTWhileStatement whileStatement = this.nodeFactory.newWhileStatement(condition, body);
        this.setOffsetAndLength((IASTNode)whileStatement);
        this.astStack.push(whileStatement);
    }

    public void consumeStatementForLoop() {
        IASTStatement body = (IASTStatement)this.astStack.pop();
        IASTExpression expr3 = (IASTExpression)this.astStack.pop();
        IASTExpression expr2 = (IASTExpression)this.astStack.pop();
        IASTNode node = (IASTNode)this.astStack.pop();
        Object initializer = node instanceof IASTExpression ? this.nodeFactory.newExpressionStatement((IASTExpression)node) : (node instanceof IASTDeclaration ? this.nodeFactory.newDeclarationStatement((IASTDeclaration)node) : this.nodeFactory.newNullStatement());
        int TK_EOC = 4;
        List<IToken> tokens = this.stream.getRuleTokens();
        if (ParserUtil.matchTokens(tokens, this.tokenMap, 36, 2, 3, TK_EOC, TK_EOC, TK_EOC, TK_EOC)) {
            IASTName name = this.createName(tokens.get(2));
            IASTIdExpression idExpression = this.nodeFactory.newIdExpression(name);
            ParserUtil.setOffsetAndLength((IASTNode)idExpression, ParserUtil.offset((IASTNode)name), ParserUtil.length((IASTNode)name));
            initializer = this.nodeFactory.newExpressionStatement((IASTExpression)idExpression);
            ParserUtil.setOffsetAndLength((IASTNode)initializer, ParserUtil.offset((IASTNode)name), ParserUtil.length((IASTNode)name));
        }
        if (node != null) {
            ParserUtil.setOffsetAndLength((IASTNode)initializer, ParserUtil.offset(node), ParserUtil.length(node));
        }
        IASTForStatement forStat = this.nodeFactory.newForStatement((IASTStatement)initializer, expr2, expr3, body);
        this.setOffsetAndLength((IASTNode)forStat);
        this.astStack.push(forStat);
    }

    public void consumeStatementSwitch() {
        IASTStatement body = (IASTStatement)this.astStack.pop();
        IASTExpression expr = (IASTExpression)this.astStack.pop();
        IASTSwitchStatement stat = this.nodeFactory.newSwitchStatement(expr, body);
        this.setOffsetAndLength((IASTNode)stat);
        this.astStack.push(stat);
    }

    public void consumeStatementIf(boolean hasElse) {
        IASTStatement elseClause = null;
        if (hasElse) {
            elseClause = (IASTStatement)this.astStack.pop();
        }
        IASTStatement thenClause = (IASTStatement)this.astStack.pop();
        IASTExpression condition = (IASTExpression)this.astStack.pop();
        IASTIfStatement ifStatement = this.nodeFactory.newIfStatement(condition, thenClause, elseClause);
        this.setOffsetAndLength((IASTNode)ifStatement);
        this.astStack.push(ifStatement);
    }

    public void consumeFunctionDefinition(boolean hasDeclSpecifiers) {
        IASTCompoundStatement body = (IASTCompoundStatement)this.astStack.pop();
        IASTFunctionDeclarator decl = (IASTFunctionDeclarator)this.astStack.pop();
        this.astStack.closeScope();
        Object declSpecifier = hasDeclSpecifiers ? (IASTDeclSpecifier)this.astStack.pop() : this.nodeFactory.newSimpleDeclSpecifier();
        IASTFunctionDefinition def = this.nodeFactory.newFunctionDefinition((IASTDeclSpecifier)declSpecifier, decl, (IASTStatement)body);
        this.setOffsetAndLength((IASTNode)def);
        this.astStack.push(def);
    }

    public void consumeFunctionDefinitionKnR() {
        IASTCompoundStatement body = (IASTCompoundStatement)this.astStack.pop();
        IASTDeclaration[] declarations = this.astStack.topScope().toArray(new IASTDeclaration[0]);
        this.astStack.closeScope();
        ICASTKnRFunctionDeclarator decl = (ICASTKnRFunctionDeclarator)this.astStack.pop();
        this.astStack.closeScope();
        ICASTDeclSpecifier declSpecifier = (ICASTDeclSpecifier)this.astStack.pop();
        decl.setParameterDeclarations(declarations);
        ASTNode lastDeclaration = (ASTNode)declarations[declarations.length - 1];
        int endOffset = lastDeclaration.getOffset() + lastDeclaration.getLength();
        ((ASTNode)decl).setLength(endOffset - ParserUtil.offset((IASTNode)decl));
        IASTFunctionDefinition def = this.nodeFactory.newFunctionDefinition((IASTDeclSpecifier)declSpecifier, (IASTFunctionDeclarator)decl, (IASTStatement)body);
        this.setOffsetAndLength((IASTNode)def);
        this.astStack.push(def);
    }

    @Override
    protected IASTAmbiguousExpression createAmbiguousExpression(IASTExpression ... expressions) {
        return new CASTAmbiguousExpression(expressions);
    }

    @Override
    protected IASTAmbiguousStatement createAmbiguousStatement(IASTStatement ... statements) {
        return new CASTAmbiguousStatement(statements);
    }
}

