/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.remotemake;

import java.util.List;
import org.eclipse.cdt.core.resources.RefreshScopeManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.ptp.internal.rdt.core.remotemake.Messages;
import org.eclipse.ptp.rdt.core.activator.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceRefreshJob
extends Job {
    private List<IProject> fProjectsToRefresh;

    public ResourceRefreshJob(List<IProject> projectsToRefresh) {
        super(Messages.ResourceRefreshJob_0);
        this.fProjectsToRefresh = projectsToRefresh;
        this.setRule((ISchedulingRule)new MultiRule(this.fProjectsToRefresh.toArray(new ISchedulingRule[0])));
    }

    protected IStatus run(IProgressMonitor arg0) {
        RefreshScopeManager manager = RefreshScopeManager.getInstance();
        for (IProject project : this.fProjectsToRefresh) {
            try {
                IWorkspaceRunnable runnable = manager.getRefreshRunnable(project);
                ResourcesPlugin.getWorkspace().run(runnable, null, 1, arg0);
            }
            catch (CoreException e) {
                return Activator.createStatus(Messages.ResourceRefreshJob_1, e);
            }
        }
        return Status.OK_STATUS;
    }
}

