/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.gem.util;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.ptp.gem.messages.Messages;
import org.eclipse.ptp.gem.util.CB;
import org.eclipse.ptp.gem.util.GemUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Envelope {
    private int interleaving;
    private int rank;
    private int index;
    private int orderIndex;
    private int issueIndex;
    private int linenumber;
    private String functionName;
    private String filePath;
    private String toStringOutput;
    private int match_rank;
    private int match_index;
    private Envelope match_envelope;
    private int communicator;
    private String communicator_ranks_string;
    private ArrayList<Integer> communicator_ranks;
    private ArrayList<Envelope> communicator_matches;
    private int src_rank;
    private int dest_rank;
    private int tag;
    private ArrayList<CB> intraCb;
    private ArrayList<CB> interCb;
    private boolean communicator_set;
    private boolean src_rank_set;
    private boolean dest_rank_set;
    private boolean tag_set;
    private boolean assertion;
    private String assert_message;
    private String assert_function;
    private boolean leak;
    private String leak_resource;
    private static Pattern envelopeRegex = Pattern.compile("^([0-9]+)\\s+([0-9]+)\\s+([0-9]+)\\s+([0-9]+)\\s+([-0-9]+)\\s+([^\\s]+)(?:\\s+([^\\s]+))?(?:\\s+([^\\s]+))?(?:\\s+([^\\s]+))?\\s+\\{\\s+([^\\}]*)\\}\\s+\\{\\s+([^}]*)\\}\\s+Match:\\s+([-]?[0-9]+)\\s+([-]?[0-9]+)\\s+File:\\s+[-]?[0-9]+ (.+?) ([-]?[0-9]+)$");
    private static Pattern assertRegex = Pattern.compile("^([0-9]+)\\s+([0-9]+)\\s+ASSERT[ ]+Message:[ ]+[0-9]+ (.+?)Function:[ ]+[0-9]+ (.+?) File:[ ]+[0-9]+ (.+?) ([-]?[0-9]+)$");
    private static Pattern leakRegex = Pattern.compile("^([0-9]+)\\s+([0-9]+)\\s+Leak\\s+(.+?)\\s+\\{\\s+\\}\\s+\\{\\s+\\}\\s+Match:\\s+-1\\s+-1\\sFile:[ ]+[0-9]+ (.+?) ([-]?[0-9]+)$");
    private static Pattern communicatorRegex = Pattern.compile("^([0-9]+)_(?:([0-9]+):)*$");
    private static Pattern interCbRegex = Pattern.compile("^(?:\\[\\s+([0-9]+)\\s+([0-9]+)\\s+\\]\\s+)*$");
    private static Pattern intraCbRegex = Pattern.compile("^([0-9]+\\s+)*$");

    private static boolean isNullOrEmpty(String value) {
        return value == null || value == "";
    }

    public static Envelope parse(String line) {
        Matcher envelopeMatch = envelopeRegex.matcher(line);
        if (!envelopeMatch.matches()) {
            Matcher assertMatch = assertRegex.matcher(line);
            if (assertMatch.matches()) {
                Envelope env = new Envelope();
                env.assertion = true;
                env.issueIndex = -1;
                env.orderIndex = Integer.MAX_VALUE;
                env.index = Integer.MAX_VALUE;
                env.match_index = -1;
                env.match_rank = -1;
                env.functionName = "MPI_assert";
                try {
                    env.interleaving = Integer.parseInt(assertMatch.group(1));
                }
                catch (NumberFormatException numberFormatException) {
                    env.interleaving = -1;
                }
                try {
                    env.rank = Integer.parseInt(assertMatch.group(2));
                }
                catch (NumberFormatException numberFormatException) {
                    env.rank = -1;
                }
                env.assert_message = assertMatch.group(3);
                env.assert_function = assertMatch.group(4);
                env.filePath = assertMatch.group(5);
                try {
                    env.linenumber = Integer.parseInt(assertMatch.group(6));
                }
                catch (NumberFormatException numberFormatException) {
                    env.linenumber = -1;
                }
                return env;
            }
            Matcher leakMatch = leakRegex.matcher(line);
            if (leakMatch.matches()) {
                Envelope env = new Envelope();
                env.leak = true;
                env.issueIndex = -1;
                env.orderIndex = Integer.MAX_VALUE;
                env.index = Integer.MAX_VALUE;
                env.match_index = -1;
                env.match_rank = -1;
                env.functionName = "leak";
                try {
                    env.interleaving = Integer.parseInt(leakMatch.group(1));
                }
                catch (NumberFormatException numberFormatException) {
                    env.interleaving = -1;
                }
                try {
                    env.rank = Integer.parseInt(leakMatch.group(2));
                }
                catch (NumberFormatException numberFormatException) {
                    env.rank = -1;
                }
                env.leak_resource = leakMatch.group(3);
                env.filePath = leakMatch.group(4);
                try {
                    env.linenumber = Integer.parseInt(leakMatch.group(5));
                }
                catch (NumberFormatException numberFormatException) {
                    env.linenumber = -1;
                }
                return env;
            }
            return null;
        }
        Envelope env = new Envelope();
        int i = 1;
        while (i <= envelopeMatch.groupCount()) {
            String value = envelopeMatch.group(i);
            switch (i) {
                case 1: {
                    env.interleaving = Integer.parseInt(value);
                    break;
                }
                case 2: {
                    env.rank = Integer.parseInt(value);
                    break;
                }
                case 3: {
                    env.index = Integer.parseInt(value);
                    break;
                }
                case 4: {
                    env.orderIndex = Integer.parseInt(value);
                    break;
                }
                case 5: {
                    env.issueIndex = Integer.parseInt(value);
                    break;
                }
                case 6: {
                    env.functionName = "MPI_" + value;
                    break;
                }
                case 7: {
                    if (!Envelope.isNullOrEmpty(value) && Envelope.isNullOrEmpty(envelopeMatch.group(i + 1)) && Envelope.isNullOrEmpty(envelopeMatch.group(i + 2))) {
                        Envelope.parseCommunicator(env, value);
                        env.tag = 0;
                        env.tag_set = false;
                        env.src_rank = 0;
                        env.src_rank_set = false;
                        env.dest_rank = 0;
                        env.dest_rank_set = false;
                        break;
                    }
                    if (!(Envelope.isNullOrEmpty(value) || Envelope.isNullOrEmpty(envelopeMatch.group(i + 1)) || Envelope.isNullOrEmpty(envelopeMatch.group(i + 2)))) {
                        if (env.functionName.toLowerCase().contains("recv") || env.functionName.toLowerCase().contains("probe")) {
                            env.src_rank = Integer.parseInt(value);
                            env.src_rank_set = true;
                            env.dest_rank = 0;
                            env.dest_rank_set = false;
                        } else {
                            env.src_rank = 0;
                            env.src_rank_set = false;
                            env.dest_rank = Integer.parseInt(value);
                            env.dest_rank_set = true;
                        }
                        env.tag = Integer.parseInt(envelopeMatch.group(i + 1));
                        env.tag_set = true;
                        Envelope.parseCommunicator(env, envelopeMatch.group(i + 2));
                        break;
                    }
                    env.src_rank = 0;
                    env.src_rank_set = false;
                    env.dest_rank = 0;
                    env.dest_rank_set = false;
                    env.tag = 0;
                    env.tag_set = false;
                    env.communicator = 0;
                    env.communicator_set = false;
                    break;
                }
                case 10: {
                    Matcher matcher;
                    Pattern pattern;
                    ArrayList<CB> intraCb = new ArrayList<CB>();
                    Matcher intraCbMatch = intraCbRegex.matcher(value);
                    if (intraCbMatch.matches()) {
                        pattern = Pattern.compile("([0-9]+\\s+)");
                        matcher = pattern.matcher(value);
                        String index = "";
                        while (matcher.find()) {
                            index = matcher.group().trim();
                            if (Envelope.isNullOrEmpty(index)) continue;
                            intraCb.add(new CB(env.rank, Integer.parseInt(index)));
                        }
                    }
                    env.intraCb = intraCb;
                    break;
                }
                case 11: {
                    ArrayList<CB> interCb = new ArrayList<CB>();
                    Matcher interCbMatcher = interCbRegex.matcher(value);
                    if (!interCbMatcher.matches()) break;
                    Pattern pattern = Pattern.compile("[\\s+([0-9])+\\s+[0-9]+)\\s+]\\s+");
                    Matcher matcher = pattern.matcher(value);
                    String rank = "";
                    String index = "";
                    while (matcher.find()) {
                        rank = matcher.group().trim();
                        if (matcher.find()) {
                            index = matcher.group().trim();
                        }
                        if (Envelope.isNullOrEmpty(rank) || Envelope.isNullOrEmpty(index)) continue;
                        interCb.add(new CB(Integer.parseInt(rank), Integer.parseInt(index)));
                    }
                    env.interCb = interCb;
                    break;
                }
                case 12: {
                    env.match_rank = Integer.parseInt(value);
                    break;
                }
                case 13: {
                    env.match_index = Integer.parseInt(value);
                    break;
                }
                case 14: {
                    env.filePath = value;
                    break;
                }
                case 15: {
                    env.linenumber = Integer.parseInt(value);
                }
            }
            ++i;
        }
        return env;
    }

    private static void parseCommunicator(Envelope env, String value) {
        if (value == null) {
            GemUtilities.showErrorDialog(Messages.Envelope_0);
            return;
        }
        Matcher communicatorMatch = communicatorRegex.matcher(value);
        if (!communicatorMatch.matches() || communicatorMatch.groupCount() == 1) {
            env.communicator_set = false;
            env.communicator = -1;
        } else {
            env.communicator_set = true;
            env.communicator = Integer.parseInt(communicatorMatch.group(1));
            env.communicator_ranks_string = value.trim();
            Pattern pattern = Pattern.compile("([0-9]+):");
            Matcher matcher = pattern.matcher(value);
            env.communicator_ranks = new ArrayList();
            while (matcher.find()) {
                String commMemberRank = matcher.group().trim().replace(":", "");
                if (Envelope.isNullOrEmpty(commMemberRank)) continue;
                env.communicator_ranks.add(Integer.parseInt(commMemberRank));
            }
        }
    }

    private Envelope() {
    }

    public void addCollectiveMatch(Envelope envelope) {
        if (this.communicator_matches == null) {
            this.communicator_matches = new ArrayList();
        }
        this.communicator_matches.add(envelope);
        if (envelope.communicator_matches == null) {
            envelope.communicator_matches = new ArrayList();
        }
        envelope.communicator_matches.add(this);
    }

    public boolean equals(Envelope otherEnvelope) {
        return this.getIndex() == otherEnvelope.getIndex() && this.getInterleaving() == otherEnvelope.getInterleaving();
    }

    public ArrayList<Envelope> getCommunicator_matches() {
        return this.communicator_matches;
    }

    public ArrayList<Integer> getCommunicator_ranks() {
        return this.communicator_ranks;
    }

    public String getCommunicator_ranks_string() {
        return this.communicator_ranks_string;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public int getIndex() {
        return this.index;
    }

    public int getInterleaving() {
        return this.interleaving;
    }

    public int getIssueIndex() {
        return this.issueIndex;
    }

    public String getLeakResource() {
        return this.leak_resource;
    }

    public int getLinenumber() {
        return this.linenumber;
    }

    public Envelope getMatch_envelope() {
        return this.match_envelope;
    }

    public int getMatch_index() {
        return this.match_index;
    }

    public int getMatch_rank() {
        return this.match_rank;
    }

    public int getOrderIndex() {
        return this.orderIndex;
    }

    public int getRank() {
        return this.rank;
    }

    public int getSrc_rank() {
        return this.src_rank;
    }

    public boolean isAssertion() {
        return this.assertion;
    }

    public boolean isCollective() {
        String MPICall = this.getFunctionName();
        return MPICall.equals("MPI_Barrier") || MPICall.equals("MPI_Gather") || MPICall.equalsIgnoreCase("MPI_Comm_create") || MPICall.equalsIgnoreCase("MPI_gather") || MPICall.equalsIgnoreCase("MPI_gatherv") || MPICall.equalsIgnoreCase("MPI_Allgather") || MPICall.equalsIgnoreCase("MPI_Allgatherv") || MPICall.equalsIgnoreCase("MPI_Reduce") || MPICall.equalsIgnoreCase("MPI_Allreduce") || MPICall.equalsIgnoreCase("MPI_Alltoall") || MPICall.equalsIgnoreCase("MPI_Alltoallv") || MPICall.equalsIgnoreCase("MPI_Scatter") || MPICall.equalsIgnoreCase("MPI_Scatterv") || MPICall.equalsIgnoreCase("MPI_Finalize") || MPICall.equalsIgnoreCase("MPI_Reduce_scatter") || MPICall.equalsIgnoreCase("MPI_Bcast") || MPICall.equals("MPI_Scan");
    }

    public boolean isCommunicator_set() {
        return this.communicator_set;
    }

    public boolean isLeak() {
        return this.leak;
    }

    public boolean isSrc_rank_set() {
        return this.src_rank_set;
    }

    public void pairWithEnvelope(Envelope envelope) {
        this.match_envelope = envelope;
        envelope.match_envelope = this;
    }

    public void setInterleaving(int interleaving) {
        this.interleaving = interleaving;
    }

    public void setIssueIndex(int value) {
        this.issueIndex = value;
    }

    public String toString() {
        if (this.toStringOutput != null) {
            return this.toStringOutput;
        }
        if (this.assertion) {
            Pattern assertPattern = Pattern.compile("^Assertion `(.+?)' failed.$");
            Matcher m = assertPattern.matcher(this.assert_message);
            this.toStringOutput = m.matches() ? String.format("{0}({1})", this.functionName, m.group(1)) : String.format("{0}({1})", this.functionName, this.assert_message);
            return this.toStringOutput;
        }
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        sb.append("{0}(" + this.functionName + " ");
        if (this.src_rank_set) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            if (this.src_rank == -1) {
                sb.append("source = MPI_ANY_SOURCE");
            } else {
                sb.append(String.format("source = {0}", this.src_rank));
            }
        }
        if (this.dest_rank_set) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(String.format("dest = {0}", this.dest_rank));
        }
        if (this.tag_set) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            if (this.tag == -1) {
                sb.append("tag = MPI_ANY_TAG");
            } else {
                sb.append(String.format("tag = {0}", this.tag));
            }
        }
        if (this.communicator_set) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            switch (this.communicator) {
                case 0: {
                    sb.append("comm = MPI_COMM_WORLD");
                    break;
                }
                case 1: {
                    sb.append("comm = MPI_COMM_SELF");
                    break;
                }
                case 2: {
                    sb.append("comm = MPI_COMM_NULL");
                    break;
                }
                default: {
                    sb.append(String.format("comm = {0}", this.communicator));
                }
            }
        }
        sb.append(")");
        this.toStringOutput = sb.toString();
        return this.toStringOutput;
    }
}

