/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rmsystem;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.ptp.core.ModelManager;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.rmsystem.AbstractResourceManager;
import org.eclipse.ptp.rmsystem.AbstractResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.IJobStatus;
import org.eclipse.ptp.rmsystem.IResourceManager;
import org.eclipse.ptp.rmsystem.IResourceManagerComponentConfiguration;
import org.eclipse.ptp.rmsystem.IResourceManagerControl;

public abstract class AbstractResourceManagerControl
implements IResourceManagerControl {
    private final AbstractResourceManagerConfiguration fConfig;
    private final ModelManager fModelManager = (ModelManager)PTPCorePlugin.getDefault().getModelManager();
    private IResourceManager fResourceManager = null;

    public AbstractResourceManagerControl(AbstractResourceManagerConfiguration config) {
        this.fConfig = config;
    }

    public void control(String jobId, String operation, IProgressMonitor monitor) throws CoreException {
        this.doControlJob(jobId, operation, monitor);
    }

    public void dispose() {
        this.doDispose();
    }

    public IResourceManagerComponentConfiguration getControlConfiguration() {
        return this.fConfig;
    }

    public IJobStatus getJobStatus(String jobId, boolean force, IProgressMonitor monitor) {
        IJobStatus status = null;
        try {
            status = this.doGetJobStatus(jobId, force, monitor);
        }
        catch (CoreException coreException) {}
        if (status == null) {
            status = new IJobStatus(){

                public String getErrorPath() {
                    return null;
                }

                public String getJobId() {
                    return null;
                }

                public ILaunchConfiguration getLaunchConfiguration() {
                    return null;
                }

                public String getOutputPath() {
                    return null;
                }

                public String getOwner() {
                    return null;
                }

                public String getQueueName() {
                    return null;
                }

                public String getRmUniqueName() {
                    return AbstractResourceManagerControl.this.getResourceManager().getUniqueName();
                }

                public String getState() {
                    return "UNDETERMINED";
                }

                public String getStateDetail() {
                    return "UNDETERMINED";
                }

                public IStreamsProxy getStreamsProxy() {
                    return null;
                }

                public boolean isInteractive() {
                    return false;
                }
            };
        }
        return status;
    }

    public IJobStatus getJobStatus(String jobId, IProgressMonitor monitor) {
        return this.getJobStatus(jobId, false, monitor);
    }

    public void start(IProgressMonitor monitor) throws CoreException {
        this.doStartup(monitor);
    }

    public void stop() throws CoreException {
        this.doShutdown();
    }

    public String submitJob(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        IJobStatus status = this.doSubmitJob(configuration, mode, monitor);
        String jobId = status.getJobId();
        this.getResourceManager().fireJobChanged(jobId);
        return jobId;
    }

    protected abstract void doControlJob(String var1, String var2, IProgressMonitor var3) throws CoreException;

    protected abstract void doDispose();

    protected abstract IJobStatus doGetJobStatus(String var1, boolean var2, IProgressMonitor var3) throws CoreException;

    protected abstract void doShutdown() throws CoreException;

    protected abstract void doStartup(IProgressMonitor var1) throws CoreException;

    protected abstract IJobStatus doSubmitJob(ILaunchConfiguration var1, String var2, IProgressMonitor var3) throws CoreException;

    protected void fireResourceManagerError(String message) {
        this.getResourceManager().fireResourceManagerError(message);
    }

    protected ModelManager getModelManager() {
        return this.fModelManager;
    }

    protected AbstractResourceManager getResourceManager() {
        if (this.fResourceManager == null) {
            this.fResourceManager = this.fModelManager.getResourceManagerFromUniqueName(this.fConfig.getUniqueName());
        }
        return (AbstractResourceManager)this.fResourceManager;
    }
}

