/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rtsystem;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.messages.Messages;
import org.eclipse.ptp.rmsystem.AbstractResourceManager;
import org.eclipse.ptp.rmsystem.AbstractResourceManagerConfiguration;
import org.eclipse.ptp.rtsystem.AbstractRuntimeResourceManagerControl;
import org.eclipse.ptp.rtsystem.AbstractRuntimeResourceManagerMonitor;
import org.eclipse.ptp.rtsystem.IRuntimeSystem;
import org.eclipse.ptp.rtsystem.IRuntimeSystemFactory;

public abstract class AbstractRuntimeResourceManager
extends AbstractResourceManager {
    private static String ID_ATTRIBUTE = "id";
    private static String CLASS_ATTRIBUTE = "class";
    private static String EXTENSION_POINT = "org.eclipse.ptp.core.runtimeSystems";
    private static final Map<String, IRuntimeSystem> fRuntimeSystems = new HashMap<String, IRuntimeSystem>();
    private static Map<String, IRuntimeSystemFactory> fRuntimeSystemFactories = null;

    private static void getRuntimeSystemFactories() {
        if (fRuntimeSystemFactories == null) {
            fRuntimeSystemFactories = new HashMap<String, IRuntimeSystemFactory>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_POINT);
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement ce = iConfigurationElementArray[n4];
                    String id = ce.getAttribute(ID_ATTRIBUTE);
                    if (ce.getAttribute(CLASS_ATTRIBUTE) != null) {
                        try {
                            IRuntimeSystemFactory factory = (IRuntimeSystemFactory)ce.createExecutableExtension(CLASS_ATTRIBUTE);
                            fRuntimeSystemFactories.put(id, factory);
                        }
                        catch (Exception e) {
                            PTPCorePlugin.log(e);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    public AbstractRuntimeResourceManager(AbstractResourceManagerConfiguration config, AbstractRuntimeResourceManagerControl control, AbstractRuntimeResourceManagerMonitor monitor) {
        super(config, control, monitor);
    }

    protected void doDispose() {
        super.doDispose();
    }

    protected void doShutdown() throws CoreException {
        CoreException exception = null;
        try {
            if (this.getRuntimeSystem() != null) {
                this.getRuntimeSystem().shutdown();
            }
        }
        catch (CoreException e) {
            exception = e;
        }
        super.doShutdown();
        if (exception != null) {
            throw exception;
        }
    }

    protected void doStartup(IProgressMonitor monitor) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        monitor.subTask(Messages.AbstractRuntimeResourceManager_5);
        super.doStartup((IProgressMonitor)subMon.newChild(50));
        try {
            this.getRuntimeSystem().startup((IProgressMonitor)subMon.newChild(50));
        }
        catch (CoreException e) {
            this.doShutdown();
            throw e;
        }
    }

    protected void fireJobChanged(String jobId) {
        super.fireJobChanged(jobId);
    }

    protected void fireResourceManagerChanged() {
        super.fireResourceManagerChanged();
    }

    protected void fireResourceManagerError(String message) {
        super.fireResourceManagerError(message);
    }

    protected void fireResourceManagerStarted() {
        super.fireResourceManagerStarted();
    }

    protected void fireResourceManagerStopped() {
        super.fireResourceManagerStopped();
    }

    protected IRuntimeSystem getRuntimeSystem() {
        String uniqueId = this.getConfiguration().getUniqueName();
        IRuntimeSystem rts = fRuntimeSystems.get(uniqueId);
        if (rts == null) {
            AbstractRuntimeResourceManager.getRuntimeSystemFactories();
            IRuntimeSystemFactory factory = fRuntimeSystemFactories.get(this.getConfiguration().getResourceManagerId());
            if (factory != null) {
                rts = factory.create(this);
                fRuntimeSystems.put(uniqueId, rts);
            }
        }
        return rts;
    }
}

